# coding: utf-8

"""
    Отчёты

    <div class=\"description_important\">   Узнать больше об отчётах можно в <a href=\"https://seller.wildberries.ru/instructions/subcategory/5f2162c5-069b-416d-a4e1-48da2a76e6b0\">справочном центре</a> </div>  С помощью этих методов вы можете получить [основные отчёты](/openapi/reports#tag/Osnovnye-otchyoty) и отчёты о:   1. [Остатках на складах](/openapi/reports#tag/Otchyot-ob-ostatkah-na-skladah)   2. [Товарах с обязательной маркировкой](/openapi/reports#tag/Otchyot-o-tovarah-c-obyazatelnoj-markirovkoj)   3. [Удержаниях](/openapi/reports#tag/Otchyoty-ob-uderzhaniyah)   4. [Платной приёмке](/openapi/reports#tag/Platnaya-priyomka)   5. [Платном хранении](/openapi/reports#tag/Platnoe-hranenie)   6. [Продажах по регионам](/openapi/reports#tag/Prodazhi-po-regionam)   7. [Доле бренда в продажах](/openapi/reports#tag/Dolya-brenda-v-prodazhah)   8. [Скрытых товарах](/openapi/reports#tag/Skrytye-tovary)   9. [Возвратах и перемещении товаров](/openapi/reports#tag/Otchyot-o-vozvratah-i-peremeshenii-tovarov) 

    The version of the OpenAPI document: reports
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ApiV1AnalyticsGoodsReturnGet200ResponseReportInner(BaseModel):
    """
    ApiV1AnalyticsGoodsReturnGet200ResponseReportInner
    """ # noqa: E501
    barcode: Optional[StrictStr] = Field(default=None, description="Баркод")
    brand: Optional[StrictStr] = Field(default=None, description="Бренд")
    completed_dt: Optional[datetime] = Field(default=None, description="Дата и время выдачи возврата продавцу", alias="completedDt")
    dst_office_address: Optional[StrictStr] = Field(default=None, description="Адрес ПВЗ выдачи возврата", alias="dstOfficeAddress")
    dst_office_id: Optional[StrictInt] = Field(default=None, description="ID ПВЗ выдачи возврата", alias="dstOfficeId")
    expired_dt: Optional[datetime] = Field(default=None, description="Дата и время истечения срока хранения возврата", alias="expiredDt")
    is_status_active: Optional[StrictInt] = Field(default=None, description="Тип статуса возврата:    * `0` — архивный   * `1` — активный ", alias="isStatusActive")
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB", alias="nmId")
    order_dt: Optional[date] = Field(default=None, description="Дата заказа на возврат", alias="orderDt")
    order_id: Optional[StrictInt] = Field(default=None, description="Номер сборочного задания", alias="orderId")
    ready_to_return_dt: Optional[datetime] = Field(default=None, description="Дата и время готовности возврата к выдаче", alias="readyToReturnDt")
    reason: Optional[StrictStr] = Field(default=None, description="Причина возврата")
    return_type: Optional[StrictStr] = Field(default=None, description="Тип возврата", alias="returnType")
    shk_id: Optional[StrictInt] = Field(default=None, description="Штрихкод", alias="shkId")
    srid: Optional[StrictStr] = Field(default=None, description="Уникальный ID заказа на возврат")
    status: Optional[StrictStr] = Field(default=None, description="Статус возврата")
    sticker_id: Optional[StrictStr] = Field(default=None, description="Стикер заказа на возврат", alias="stickerId")
    subject_name: Optional[StrictStr] = Field(default=None, description="Предмет", alias="subjectName")
    tech_size: Optional[StrictStr] = Field(default=None, description="Размер", alias="techSize")
    __properties: ClassVar[List[str]] = ["barcode", "brand", "completedDt", "dstOfficeAddress", "dstOfficeId", "expiredDt", "isStatusActive", "nmId", "orderDt", "orderId", "readyToReturnDt", "reason", "returnType", "shkId", "srid", "status", "stickerId", "subjectName", "techSize"]

    @field_validator('is_status_active')
    def is_status_active_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([0, 1]):
            raise ValueError("must be one of enum values (0, 1)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiV1AnalyticsGoodsReturnGet200ResponseReportInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if completed_dt (nullable) is None
        # and model_fields_set contains the field
        if self.completed_dt is None and "completed_dt" in self.model_fields_set:
            _dict['completedDt'] = None

        # set to None if expired_dt (nullable) is None
        # and model_fields_set contains the field
        if self.expired_dt is None and "expired_dt" in self.model_fields_set:
            _dict['expiredDt'] = None

        # set to None if ready_to_return_dt (nullable) is None
        # and model_fields_set contains the field
        if self.ready_to_return_dt is None and "ready_to_return_dt" in self.model_fields_set:
            _dict['readyToReturnDt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiV1AnalyticsGoodsReturnGet200ResponseReportInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "barcode": obj.get("barcode"),
            "brand": obj.get("brand"),
            "completedDt": obj.get("completedDt"),
            "dstOfficeAddress": obj.get("dstOfficeAddress"),
            "dstOfficeId": obj.get("dstOfficeId"),
            "expiredDt": obj.get("expiredDt"),
            "isStatusActive": obj.get("isStatusActive"),
            "nmId": obj.get("nmId"),
            "orderDt": obj.get("orderDt"),
            "orderId": obj.get("orderId"),
            "readyToReturnDt": obj.get("readyToReturnDt"),
            "reason": obj.get("reason"),
            "returnType": obj.get("returnType"),
            "shkId": obj.get("shkId"),
            "srid": obj.get("srid"),
            "status": obj.get("status"),
            "stickerId": obj.get("stickerId"),
            "subjectName": obj.get("subjectName"),
            "techSize": obj.get("techSize")
        })
        return _obj


