# coding: utf-8

"""
    Отчёты

    <div class=\"description_important\">   Узнать больше об отчётах можно в <a href=\"https://seller.wildberries.ru/instructions/subcategory/5f2162c5-069b-416d-a4e1-48da2a76e6b0\">справочном центре</a> </div>  С помощью этих методов вы можете получить [основные отчёты](/openapi/reports#tag/Osnovnye-otchyoty) и отчёты о:   1. [Остатках на складах](/openapi/reports#tag/Otchyot-ob-ostatkah-na-skladah)   2. [Товарах с обязательной маркировкой](/openapi/reports#tag/Otchyot-o-tovarah-c-obyazatelnoj-markirovkoj)   3. [Удержаниях](/openapi/reports#tag/Otchyoty-ob-uderzhaniyah)   4. [Платной приёмке](/openapi/reports#tag/Platnaya-priyomka)   5. [Платном хранении](/openapi/reports#tag/Platnoe-hranenie)   6. [Продажах по регионам](/openapi/reports#tag/Prodazhi-po-regionam)   7. [Доле бренда в продажах](/openapi/reports#tag/Dolya-brenda-v-prodazhah)   8. [Скрытых товарах](/openapi/reports#tag/Skrytye-tovary)   9. [Возвратах и перемещении товаров](/openapi/reports#tag/Otchyot-o-vozvratah-i-peremeshenii-tovarov) 

    The version of the OpenAPI document: reports
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wildberries_sdk.reports.models.response_error_statistics import ResponseErrorStatistics
from wildberries_sdk.reports.models.response_error_statistics2 import ResponseErrorStatistics2
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

APIV1SUPPLIERINCOMESGET400RESPONSE_ONE_OF_SCHEMAS = ["ResponseErrorStatistics", "ResponseErrorStatistics2"]

class ApiV1SupplierIncomesGet400Response(BaseModel):
    """
    ApiV1SupplierIncomesGet400Response
    """
    # data type: ResponseErrorStatistics
    oneof_schema_1_validator: Optional[ResponseErrorStatistics] = None
    # data type: ResponseErrorStatistics2
    oneof_schema_2_validator: Optional[ResponseErrorStatistics2] = None
    actual_instance: Optional[Union[ResponseErrorStatistics, ResponseErrorStatistics2]] = None
    one_of_schemas: Set[str] = { "ResponseErrorStatistics", "ResponseErrorStatistics2" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ApiV1SupplierIncomesGet400Response.model_construct()
        error_messages = []
        match = 0
        # validate data type: ResponseErrorStatistics
        if not isinstance(v, ResponseErrorStatistics):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseErrorStatistics`")
        else:
            match += 1
        # validate data type: ResponseErrorStatistics2
        if not isinstance(v, ResponseErrorStatistics2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseErrorStatistics2`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ApiV1SupplierIncomesGet400Response with oneOf schemas: ResponseErrorStatistics, ResponseErrorStatistics2. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ApiV1SupplierIncomesGet400Response with oneOf schemas: ResponseErrorStatistics, ResponseErrorStatistics2. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into ResponseErrorStatistics
        try:
            instance.actual_instance = ResponseErrorStatistics.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ResponseErrorStatistics2
        try:
            instance.actual_instance = ResponseErrorStatistics2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ApiV1SupplierIncomesGet400Response with oneOf schemas: ResponseErrorStatistics, ResponseErrorStatistics2. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ApiV1SupplierIncomesGet400Response with oneOf schemas: ResponseErrorStatistics, ResponseErrorStatistics2. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ResponseErrorStatistics, ResponseErrorStatistics2]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


