# coding: utf-8

"""
    Отчёты

    <div class=\"description_important\">   Узнать больше об отчётах можно в <a href=\"https://seller.wildberries.ru/instructions/subcategory/5f2162c5-069b-416d-a4e1-48da2a76e6b0\">справочном центре</a> </div>  С помощью этих методов вы можете получить [основные отчёты](/openapi/reports#tag/Osnovnye-otchyoty) и отчёты о:   1. [Остатках на складах](/openapi/reports#tag/Otchyot-ob-ostatkah-na-skladah)   2. [Товарах с обязательной маркировкой](/openapi/reports#tag/Otchyot-o-tovarah-c-obyazatelnoj-markirovkoj)   3. [Удержаниях](/openapi/reports#tag/Otchyoty-ob-uderzhaniyah)   4. [Платной приёмке](/openapi/reports#tag/Platnaya-priyomka)   5. [Платном хранении](/openapi/reports#tag/Platnoe-hranenie)   6. [Продажах по регионам](/openapi/reports#tag/Prodazhi-po-regionam)   7. [Доле бренда в продажах](/openapi/reports#tag/Dolya-brenda-v-prodazhah)   8. [Скрытых товарах](/openapi/reports#tag/Skrytye-tovary)   9. [Возвратах и перемещении товаров](/openapi/reports#tag/Otchyot-o-vozvratah-i-peremeshenii-tovarov) 

    The version of the OpenAPI document: reports
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from wildberries_sdk.reports.models.api_v1_warehouse_remains_tasks_task_id_download_get200_response_inner_warehouses_inner import ApiV1WarehouseRemainsTasksTaskIdDownloadGet200ResponseInnerWarehousesInner
from typing import Optional, Set
from typing_extensions import Self

class ApiV1WarehouseRemainsTasksTaskIdDownloadGet200ResponseInner(BaseModel):
    """
    ApiV1WarehouseRemainsTasksTaskIdDownloadGet200ResponseInner
    """ # noqa: E501
    brand: Optional[StrictStr] = Field(default=None, description="Бренд")
    subject_name: Optional[StrictStr] = Field(default=None, description="Название предмета", alias="subjectName")
    vendor_code: Optional[StrictStr] = Field(default=None, description="Артикул продавца", alias="vendorCode")
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB", alias="nmId")
    barcode: Optional[StrictStr] = Field(default=None, description="Баркод")
    tech_size: Optional[StrictStr] = Field(default=None, description="Размер", alias="techSize")
    volume: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Объём, л")
    warehouses: Optional[List[ApiV1WarehouseRemainsTasksTaskIdDownloadGet200ResponseInnerWarehousesInner]] = Field(default=None, description="Остатки на складах и товары в пути. Будут в ответе только при ненулевом `quantity`")
    __properties: ClassVar[List[str]] = ["brand", "subjectName", "vendorCode", "nmId", "barcode", "techSize", "volume", "warehouses"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiV1WarehouseRemainsTasksTaskIdDownloadGet200ResponseInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in warehouses (list)
        _items = []
        if self.warehouses:
            for _item_warehouses in self.warehouses:
                if _item_warehouses:
                    _items.append(_item_warehouses.to_dict())
            _dict['warehouses'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiV1WarehouseRemainsTasksTaskIdDownloadGet200ResponseInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "brand": obj.get("brand"),
            "subjectName": obj.get("subjectName"),
            "vendorCode": obj.get("vendorCode"),
            "nmId": obj.get("nmId"),
            "barcode": obj.get("barcode"),
            "techSize": obj.get("techSize"),
            "volume": obj.get("volume"),
            "warehouses": [ApiV1WarehouseRemainsTasksTaskIdDownloadGet200ResponseInnerWarehousesInner.from_dict(_item) for _item in obj["warehouses"]] if obj.get("warehouses") is not None else None
        })
        return _obj


