# coding: utf-8

"""
    Отчёты

    <div class=\"description_important\">   Узнать больше об отчётах можно в <a href=\"https://seller.wildberries.ru/instructions/subcategory/5f2162c5-069b-416d-a4e1-48da2a76e6b0\">справочном центре</a> </div>  С помощью этих методов вы можете получить [основные отчёты](/openapi/reports#tag/Osnovnye-otchyoty) и отчёты о:   1. [Остатках на складах](/openapi/reports#tag/Otchyot-ob-ostatkah-na-skladah)   2. [Товарах с обязательной маркировкой](/openapi/reports#tag/Otchyot-o-tovarah-c-obyazatelnoj-markirovkoj)   3. [Удержаниях](/openapi/reports#tag/Otchyoty-ob-uderzhaniyah)   4. [Платной приёмке](/openapi/reports#tag/Platnaya-priyomka)   5. [Платном хранении](/openapi/reports#tag/Platnoe-hranenie)   6. [Продажах по регионам](/openapi/reports#tag/Prodazhi-po-regionam)   7. [Доле бренда в продажах](/openapi/reports#tag/Dolya-brenda-v-prodazhah)   8. [Скрытых товарах](/openapi/reports#tag/Skrytye-tovary)   9. [Возвратах и перемещении товаров](/openapi/reports#tag/Otchyot-o-vozvratah-i-peremeshenii-tovarov) 

    The version of the OpenAPI document: reports
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class IncomesItem(BaseModel):
    """
    IncomesItem
    """ # noqa: E501
    income_id: Optional[StrictInt] = Field(default=None, description="Номер поставки", alias="incomeId")
    number: Optional[Annotated[str, Field(strict=True, max_length=40)]] = Field(default=None, description="Номер УПД")
    var_date: Optional[StrictStr] = Field(default=None, description="Дата поступления. Если часовой пояс не указан, то берётся Московское время UTC+3.", alias="date")
    last_change_date: Optional[StrictStr] = Field(default=None, description="Дата и время обновления информации в сервисе. Это поле соответствует параметру `dateFrom` в запросе. Если часовой пояс не указан, то берётся Московское время UTC+3.", alias="lastChangeDate")
    supplier_article: Optional[Annotated[str, Field(strict=True, max_length=75)]] = Field(default=None, description="Артикул продавца", alias="supplierArticle")
    tech_size: Optional[Annotated[str, Field(strict=True, max_length=30)]] = Field(default=None, description="Размер товара", alias="techSize")
    barcode: Optional[Annotated[str, Field(strict=True, max_length=30)]] = Field(default=None, description="Баркод")
    quantity: Optional[StrictInt] = Field(default=None, description="Количество")
    total_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Цена из УПД", alias="totalPrice")
    date_close: Optional[StrictStr] = Field(default=None, description="Дата принятия (закрытия) в WB. Если часовой пояс не указан, то берётся Московское время UTC+3", alias="dateClose")
    warehouse_name: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="Название склада", alias="warehouseName")
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB", alias="nmId")
    status: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="Текущий статус поставки")
    __properties: ClassVar[List[str]] = ["incomeId", "number", "date", "lastChangeDate", "supplierArticle", "techSize", "barcode", "quantity", "totalPrice", "dateClose", "warehouseName", "nmId", "status"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Принято']):
            raise ValueError("must be one of enum values ('Принято')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IncomesItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IncomesItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "incomeId": obj.get("incomeId"),
            "number": obj.get("number"),
            "date": obj.get("date"),
            "lastChangeDate": obj.get("lastChangeDate"),
            "supplierArticle": obj.get("supplierArticle"),
            "techSize": obj.get("techSize"),
            "barcode": obj.get("barcode"),
            "quantity": obj.get("quantity"),
            "totalPrice": obj.get("totalPrice"),
            "dateClose": obj.get("dateClose"),
            "warehouseName": obj.get("warehouseName"),
            "nmId": obj.get("nmId"),
            "status": obj.get("status")
        })
        return _obj


