# coding: utf-8

"""
    Отчёты

    <div class=\"description_important\">   Узнать больше об отчётах можно в <a href=\"https://seller.wildberries.ru/instructions/subcategory/5f2162c5-069b-416d-a4e1-48da2a76e6b0\">справочном центре</a> </div>  С помощью этих методов вы можете получить [основные отчёты](/openapi/reports#tag/Osnovnye-otchyoty) и отчёты о:   1. [Остатках на складах](/openapi/reports#tag/Otchyot-ob-ostatkah-na-skladah)   2. [Товарах с обязательной маркировкой](/openapi/reports#tag/Otchyot-o-tovarah-c-obyazatelnoj-markirovkoj)   3. [Удержаниях](/openapi/reports#tag/Otchyoty-ob-uderzhaniyah)   4. [Платной приёмке](/openapi/reports#tag/Platnaya-priyomka)   5. [Платном хранении](/openapi/reports#tag/Platnoe-hranenie)   6. [Продажах по регионам](/openapi/reports#tag/Prodazhi-po-regionam)   7. [Доле бренда в продажах](/openapi/reports#tag/Dolya-brenda-v-prodazhah)   8. [Скрытых товарах](/openapi/reports#tag/Skrytye-tovary)   9. [Возвратах и перемещении товаров](/openapi/reports#tag/Otchyot-o-vozvratah-i-peremeshenii-tovarov) 

    The version of the OpenAPI document: reports
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class OrdersItem(BaseModel):
    """
    OrdersItem
    """ # noqa: E501
    var_date: Optional[StrictStr] = Field(default=None, description="Дата и время заказа. Это поле соответствует параметру `dateFrom` в запросе, если параметр `flag`=1. Если часовой пояс не указан, то берётся Московское время (UTC+3).", alias="date")
    last_change_date: Optional[StrictStr] = Field(default=None, description="Дата и время обновления информации в сервисе. Это поле соответствует параметру `dateFrom` в запросе, если параметр `flag`=0 или не указан. Если часовой пояс не указан, то берётся Московское время (UTC+3).", alias="lastChangeDate")
    warehouse_name: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="Склад отгрузки", alias="warehouseName")
    warehouse_type: Optional[StrictStr] = Field(default=None, description="Тип склада хранения товаров", alias="warehouseType")
    country_name: Optional[Annotated[str, Field(strict=True, max_length=200)]] = Field(default=None, description="Страна", alias="countryName")
    oblast_okrug_name: Optional[Annotated[str, Field(strict=True, max_length=200)]] = Field(default=None, description="Округ", alias="oblastOkrugName")
    region_name: Optional[Annotated[str, Field(strict=True, max_length=200)]] = Field(default=None, description="Регион", alias="regionName")
    supplier_article: Optional[Annotated[str, Field(strict=True, max_length=75)]] = Field(default=None, description="Артикул продавца", alias="supplierArticle")
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB", alias="nmId")
    barcode: Optional[Annotated[str, Field(strict=True, max_length=30)]] = Field(default=None, description="Баркод")
    category: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="Категория")
    subject: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="Предмет")
    brand: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="Бренд")
    tech_size: Optional[Annotated[str, Field(strict=True, max_length=30)]] = Field(default=None, description="Размер товара", alias="techSize")
    income_id: Optional[StrictInt] = Field(default=None, description="Номер поставки", alias="incomeID")
    is_supply: Optional[StrictBool] = Field(default=None, description="Договор поставки", alias="isSupply")
    is_realization: Optional[StrictBool] = Field(default=None, description="Договор реализации", alias="isRealization")
    total_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Цена без скидок", alias="totalPrice")
    discount_percent: Optional[StrictInt] = Field(default=None, description="Скидка продавца, %", alias="discountPercent")
    spp: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Скидка WB, %")
    finished_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Цена с учетом всех скидок, кроме суммы по WB Кошельку", alias="finishedPrice")
    price_with_disc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Цена со скидкой продавца, в том числе со скидкой WB Клуба", alias="priceWithDisc")
    is_cancel: Optional[StrictBool] = Field(default=None, description="Отмена заказа:   - `true` — заказ отменен ", alias="isCancel")
    cancel_date: Optional[StrictStr] = Field(default=None, description="Дата и время отмены заказа. Если заказ не был отменен, то \"0001-01-01T00:00:00\".Если часовой пояс не указан, то берётся Московское время UTC+3.", alias="cancelDate")
    sticker: Optional[StrictStr] = Field(default=None, description="ID стикера")
    g_number: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="ID корзины покупателя. Заказы одной транзакции будут иметь одинаковый `gNumber`", alias="gNumber")
    srid: Optional[StrictStr] = Field(default=None, description="Уникальный ID заказа.<br> Примечание для использующих API Маркетплейс: `srid` равен `rid` в ответах методов сборочных заданий. ")
    __properties: ClassVar[List[str]] = ["date", "lastChangeDate", "warehouseName", "warehouseType", "countryName", "oblastOkrugName", "regionName", "supplierArticle", "nmId", "barcode", "category", "subject", "brand", "techSize", "incomeID", "isSupply", "isRealization", "totalPrice", "discountPercent", "spp", "finishedPrice", "priceWithDisc", "isCancel", "cancelDate", "sticker", "gNumber", "srid"]

    @field_validator('warehouse_type')
    def warehouse_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Склад WB', 'Склад продавца']):
            raise ValueError("must be one of enum values ('Склад WB', 'Склад продавца')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrdersItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrdersItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date": obj.get("date"),
            "lastChangeDate": obj.get("lastChangeDate"),
            "warehouseName": obj.get("warehouseName"),
            "warehouseType": obj.get("warehouseType"),
            "countryName": obj.get("countryName"),
            "oblastOkrugName": obj.get("oblastOkrugName"),
            "regionName": obj.get("regionName"),
            "supplierArticle": obj.get("supplierArticle"),
            "nmId": obj.get("nmId"),
            "barcode": obj.get("barcode"),
            "category": obj.get("category"),
            "subject": obj.get("subject"),
            "brand": obj.get("brand"),
            "techSize": obj.get("techSize"),
            "incomeID": obj.get("incomeID"),
            "isSupply": obj.get("isSupply"),
            "isRealization": obj.get("isRealization"),
            "totalPrice": obj.get("totalPrice"),
            "discountPercent": obj.get("discountPercent"),
            "spp": obj.get("spp"),
            "finishedPrice": obj.get("finishedPrice"),
            "priceWithDisc": obj.get("priceWithDisc"),
            "isCancel": obj.get("isCancel"),
            "cancelDate": obj.get("cancelDate"),
            "sticker": obj.get("sticker"),
            "gNumber": obj.get("gNumber"),
            "srid": obj.get("srid")
        })
        return _obj


