# coding: utf-8

"""
    Отчёты

    <div class=\"description_important\">   Узнать больше об отчётах можно в <a href=\"https://seller.wildberries.ru/instructions/subcategory/5f2162c5-069b-416d-a4e1-48da2a76e6b0\">справочном центре</a> </div>  С помощью этих методов вы можете получить [основные отчёты](/openapi/reports#tag/Osnovnye-otchyoty) и отчёты о:   1. [Остатках на складах](/openapi/reports#tag/Otchyot-ob-ostatkah-na-skladah)   2. [Товарах с обязательной маркировкой](/openapi/reports#tag/Otchyot-o-tovarah-c-obyazatelnoj-markirovkoj)   3. [Удержаниях](/openapi/reports#tag/Otchyoty-ob-uderzhaniyah)   4. [Платной приёмке](/openapi/reports#tag/Platnaya-priyomka)   5. [Платном хранении](/openapi/reports#tag/Platnoe-hranenie)   6. [Продажах по регионам](/openapi/reports#tag/Prodazhi-po-regionam)   7. [Доле бренда в продажах](/openapi/reports#tag/Dolya-brenda-v-prodazhah)   8. [Скрытых товарах](/openapi/reports#tag/Skrytye-tovary)   9. [Возвратах и перемещении товаров](/openapi/reports#tag/Otchyot-o-vozvratah-i-peremeshenii-tovarov) 

    The version of the OpenAPI document: reports
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ResponsePaidStorageInner(BaseModel):
    """
    ResponsePaidStorageInner
    """ # noqa: E501
    var_date: Optional[StrictStr] = Field(default=None, description="Дата, за которую был расчёт или перерасчёт", alias="date")
    log_warehouse_coef: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Коэффициент логистики и хранения", alias="logWarehouseCoef")
    office_id: Optional[StrictInt] = Field(default=None, description="ID склада", alias="officeId")
    warehouse: Optional[StrictStr] = Field(default=None, description="Название склада")
    warehouse_coef: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Коэффициент склада", alias="warehouseCoef")
    gi_id: Optional[StrictInt] = Field(default=None, description="ID поставки", alias="giId")
    chrt_id: Optional[StrictInt] = Field(default=None, description="ID размера для этого артикула WB", alias="chrtId")
    size: Optional[StrictStr] = Field(default=None, description="Размер (`techSize` в карточке товара)")
    barcode: Optional[StrictStr] = Field(default=None, description="Баркод")
    subject: Optional[StrictStr] = Field(default=None, description="Предмет")
    brand: Optional[StrictStr] = Field(default=None, description="Бренд")
    vendor_code: Optional[StrictStr] = Field(default=None, description="Артикул продавца", alias="vendorCode")
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB", alias="nmId")
    volume: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Объём товара")
    calc_type: Optional[StrictStr] = Field(default=None, description="Способ расчёта", alias="calcType")
    warehouse_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Сумма хранения", alias="warehousePrice")
    barcodes_count: Optional[StrictInt] = Field(default=None, description="Количество единиц товара (штук), подлежащих тарифицированию за расчётные сутки", alias="barcodesCount")
    pallet_place_code: Optional[StrictInt] = Field(default=None, description="Код паллетоместа", alias="palletPlaceCode")
    pallet_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Количество паллет", alias="palletCount")
    original_date: Optional[StrictStr] = Field(default=None, description="Если был перерасчёт, это дата первоначального расчёта. Если перерасчёта не было, совпадает с `date`", alias="originalDate")
    loyalty_discount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Скидка программы лояльности, ₽", alias="loyaltyDiscount")
    tariff_fix_date: Optional[StrictStr] = Field(default=None, description="Дата фиксации тарифа", alias="tariffFixDate")
    tariff_lower_date: Optional[StrictStr] = Field(default=None, description="Дата понижения тарифа", alias="tariffLowerDate")
    __properties: ClassVar[List[str]] = ["date", "logWarehouseCoef", "officeId", "warehouse", "warehouseCoef", "giId", "chrtId", "size", "barcode", "subject", "brand", "vendorCode", "nmId", "volume", "calcType", "warehousePrice", "barcodesCount", "palletPlaceCode", "palletCount", "originalDate", "loyaltyDiscount", "tariffFixDate", "tariffLowerDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResponsePaidStorageInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResponsePaidStorageInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date": obj.get("date"),
            "logWarehouseCoef": obj.get("logWarehouseCoef"),
            "officeId": obj.get("officeId"),
            "warehouse": obj.get("warehouse"),
            "warehouseCoef": obj.get("warehouseCoef"),
            "giId": obj.get("giId"),
            "chrtId": obj.get("chrtId"),
            "size": obj.get("size"),
            "barcode": obj.get("barcode"),
            "subject": obj.get("subject"),
            "brand": obj.get("brand"),
            "vendorCode": obj.get("vendorCode"),
            "nmId": obj.get("nmId"),
            "volume": obj.get("volume"),
            "calcType": obj.get("calcType"),
            "warehousePrice": obj.get("warehousePrice"),
            "barcodesCount": obj.get("barcodesCount"),
            "palletPlaceCode": obj.get("palletPlaceCode"),
            "palletCount": obj.get("palletCount"),
            "originalDate": obj.get("originalDate"),
            "loyaltyDiscount": obj.get("loyaltyDiscount"),
            "tariffFixDate": obj.get("tariffFixDate"),
            "tariffLowerDate": obj.get("tariffLowerDate")
        })
        return _obj


