# coding: utf-8

"""
    Тарифы

    <div class=\"description_important\">     Узнать больше о комиссиях и тарифах можно в <a href=\"https://seller.wildberries.ru/instructions/category/a04560b5-256d-48cb-8f09-60e283b5d493\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Комиссий](/openapi/wb-tariffs#tag/Komissii)   2. [Тарифов на остаток](/openapi/wb-tariffs#tag/Tarify-na-ostatok)   3. [Тарифов на возврат товаров продавцу](/openapi/wb-tariffs#tag/Stoimost-vozvrata-prodavcu) 

    The version of the OpenAPI document: tariffs
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wildberries_sdk.tariffs.models.commission import Commission
from wildberries_sdk.tariffs.models.commission_china import CommissionChina
from wildberries_sdk.tariffs.models.commission_turkey import CommissionTurkey
from wildberries_sdk.tariffs.models.commission_uae import CommissionUAE
from wildberries_sdk.tariffs.models.commission_uzbekistan import CommissionUzbekistan
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

APIV1TARIFFSCOMMISSIONGET200RESPONSE_ONE_OF_SCHEMAS = ["Commission", "CommissionChina", "CommissionTurkey", "CommissionUAE", "CommissionUzbekistan"]

class ApiV1TariffsCommissionGet200Response(BaseModel):
    """
    ApiV1TariffsCommissionGet200Response
    """
    # data type: Commission
    oneof_schema_1_validator: Optional[Commission] = None
    # data type: CommissionChina
    oneof_schema_2_validator: Optional[CommissionChina] = None
    # data type: CommissionTurkey
    oneof_schema_3_validator: Optional[CommissionTurkey] = None
    # data type: CommissionUzbekistan
    oneof_schema_4_validator: Optional[CommissionUzbekistan] = None
    # data type: CommissionUAE
    oneof_schema_5_validator: Optional[CommissionUAE] = None
    actual_instance: Optional[Union[Commission, CommissionChina, CommissionTurkey, CommissionUAE, CommissionUzbekistan]] = None
    one_of_schemas: Set[str] = { "Commission", "CommissionChina", "CommissionTurkey", "CommissionUAE", "CommissionUzbekistan" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ApiV1TariffsCommissionGet200Response.model_construct()
        error_messages = []
        match = 0
        # validate data type: Commission
        if not isinstance(v, Commission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Commission`")
        else:
            match += 1
        # validate data type: CommissionChina
        if not isinstance(v, CommissionChina):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CommissionChina`")
        else:
            match += 1
        # validate data type: CommissionTurkey
        if not isinstance(v, CommissionTurkey):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CommissionTurkey`")
        else:
            match += 1
        # validate data type: CommissionUzbekistan
        if not isinstance(v, CommissionUzbekistan):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CommissionUzbekistan`")
        else:
            match += 1
        # validate data type: CommissionUAE
        if not isinstance(v, CommissionUAE):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CommissionUAE`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ApiV1TariffsCommissionGet200Response with oneOf schemas: Commission, CommissionChina, CommissionTurkey, CommissionUAE, CommissionUzbekistan. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ApiV1TariffsCommissionGet200Response with oneOf schemas: Commission, CommissionChina, CommissionTurkey, CommissionUAE, CommissionUzbekistan. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into Commission
        try:
            instance.actual_instance = Commission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CommissionChina
        try:
            instance.actual_instance = CommissionChina.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CommissionTurkey
        try:
            instance.actual_instance = CommissionTurkey.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CommissionUzbekistan
        try:
            instance.actual_instance = CommissionUzbekistan.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CommissionUAE
        try:
            instance.actual_instance = CommissionUAE.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ApiV1TariffsCommissionGet200Response with oneOf schemas: Commission, CommissionChina, CommissionTurkey, CommissionUAE, CommissionUzbekistan. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ApiV1TariffsCommissionGet200Response with oneOf schemas: Commission, CommissionChina, CommissionTurkey, CommissionUAE, CommissionUzbekistan. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], Commission, CommissionChina, CommissionTurkey, CommissionUAE, CommissionUzbekistan]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


