# coding: utf-8

"""
    Тарифы

    <div class=\"description_important\">     Узнать больше о комиссиях и тарифах можно в <a href=\"https://seller.wildberries.ru/instructions/category/a04560b5-256d-48cb-8f09-60e283b5d493\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Комиссий](/openapi/wb-tariffs#tag/Komissii)   2. [Тарифов на остаток](/openapi/wb-tariffs#tag/Tarify-na-ostatok)   3. [Тарифов на возврат товаров продавцу](/openapi/wb-tariffs#tag/Stoimost-vozvrata-prodavcu) 

    The version of the OpenAPI document: tariffs
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ModelsAcceptanceCoefficient(BaseModel):
    """
    ModelsAcceptanceCoefficient
    """ # noqa: E501
    var_date: Optional[StrictStr] = Field(default=None, description="Дата начала действия коэффициента", alias="date")
    coefficient: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Коэффициент приёмки:   - `-1` — приёмка недоступна, вне зависимости от значения поля `allowUnload`   - `0` — бесплатная приёмка   - от `1` — множитель стоимости приёмки ")
    warehouse_id: Optional[StrictInt] = Field(default=None, description="ID склада. По нему можно получить [информацию о складе](./orders-fbw#tag/Informaciya-dlya-formirovaniya-postavok/paths/~1api~1v1~1warehouses/get)", alias="warehouseID")
    warehouse_name: Optional[StrictStr] = Field(default=None, description="Название склада", alias="warehouseName")
    allow_unload: Optional[StrictBool] = Field(default=None, description="Доступность приёмки для поставок данного типа, смотри значение поля `boxTypeID`:   - `true` — приёмка доступна  - `false` — приёмка не доступна ", alias="allowUnload")
    box_type_id: Optional[StrictInt] = Field(default=None, description="ID типа поставки:   - `2` — Короба   - `5` — Монопаллеты   - `6` — Суперсейф <br>Для типа поставки **QR-поставка с коробами** поле не возвращается ", alias="boxTypeID")
    storage_coef: Optional[StrictStr] = Field(default=None, description="Коэффициент хранения", alias="storageCoef")
    delivery_coef: Optional[StrictStr] = Field(default=None, description="Коэффициент логистики", alias="deliveryCoef")
    delivery_base_liter: Optional[StrictStr] = Field(default=None, description="Стоимость логистики первого литра", alias="deliveryBaseLiter")
    delivery_additional_liter: Optional[StrictStr] = Field(default=None, description="Стоимость логистики каждого следующего литра", alias="deliveryAdditionalLiter")
    storage_base_liter: Optional[StrictStr] = Field(default=None, description="Стоимость хранения:   - для паллет — стоимость за одну паллету   - для коробов — стоимость хранения за первый литр ", alias="storageBaseLiter")
    storage_additional_liter: Optional[StrictStr] = Field(default=None, description="Стоимость хранения каждого последующего литра:   - для паллет — всегда будет `null`, т.к. стоимость хранения за единицу паллеты определяется в `StorageBaseLiter`   - для коробов — стоимость хранения за каждый последующий литр ", alias="storageAdditionalLiter")
    is_sorting_center: Optional[StrictBool] = Field(default=None, description="Тип склада:   - `true` — сортировочный центр (СЦ)  - `false` — обычный ", alias="isSortingCenter")
    __properties: ClassVar[List[str]] = ["date", "coefficient", "warehouseID", "warehouseName", "allowUnload", "boxTypeID", "storageCoef", "deliveryCoef", "deliveryBaseLiter", "deliveryAdditionalLiter", "storageBaseLiter", "storageAdditionalLiter", "isSortingCenter"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModelsAcceptanceCoefficient from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if storage_coef (nullable) is None
        # and model_fields_set contains the field
        if self.storage_coef is None and "storage_coef" in self.model_fields_set:
            _dict['storageCoef'] = None

        # set to None if delivery_coef (nullable) is None
        # and model_fields_set contains the field
        if self.delivery_coef is None and "delivery_coef" in self.model_fields_set:
            _dict['deliveryCoef'] = None

        # set to None if delivery_base_liter (nullable) is None
        # and model_fields_set contains the field
        if self.delivery_base_liter is None and "delivery_base_liter" in self.model_fields_set:
            _dict['deliveryBaseLiter'] = None

        # set to None if delivery_additional_liter (nullable) is None
        # and model_fields_set contains the field
        if self.delivery_additional_liter is None and "delivery_additional_liter" in self.model_fields_set:
            _dict['deliveryAdditionalLiter'] = None

        # set to None if storage_base_liter (nullable) is None
        # and model_fields_set contains the field
        if self.storage_base_liter is None and "storage_base_liter" in self.model_fields_set:
            _dict['storageBaseLiter'] = None

        # set to None if storage_additional_liter (nullable) is None
        # and model_fields_set contains the field
        if self.storage_additional_liter is None and "storage_additional_liter" in self.model_fields_set:
            _dict['storageAdditionalLiter'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModelsAcceptanceCoefficient from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date": obj.get("date"),
            "coefficient": obj.get("coefficient"),
            "warehouseID": obj.get("warehouseID"),
            "warehouseName": obj.get("warehouseName"),
            "allowUnload": obj.get("allowUnload"),
            "boxTypeID": obj.get("boxTypeID"),
            "storageCoef": obj.get("storageCoef"),
            "deliveryCoef": obj.get("deliveryCoef"),
            "deliveryBaseLiter": obj.get("deliveryBaseLiter"),
            "deliveryAdditionalLiter": obj.get("deliveryAdditionalLiter"),
            "storageBaseLiter": obj.get("storageBaseLiter"),
            "storageAdditionalLiter": obj.get("storageAdditionalLiter"),
            "isSortingCenter": obj.get("isSortingCenter")
        })
        return _obj


