# coding: utf-8

"""
    Тарифы

    <div class=\"description_important\">     Узнать больше о комиссиях и тарифах можно в <a href=\"https://seller.wildberries.ru/instructions/category/a04560b5-256d-48cb-8f09-60e283b5d493\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Комиссий](/openapi/wb-tariffs#tag/Komissii)   2. [Тарифов на остаток](/openapi/wb-tariffs#tag/Tarify-na-ostatok)   3. [Тарифов на возврат товаров продавцу](/openapi/wb-tariffs#tag/Stoimost-vozvrata-prodavcu) 

    The version of the OpenAPI document: tariffs
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ModelsWarehouseReturnRates(BaseModel):
    """
    ModelsWarehouseReturnRates
    """ # noqa: E501
    delivery_dump_kgt_office_base: Optional[StrictStr] = Field(default=None, description="**Стоимость возврата при грузовой доставке, доставка на ПВЗ (базовая цена за 1 л), ₽** Применяется для крупногабаритных товаров, когда:   - продавец хочет вывезти товары со склада WB;   - на складе обнаружили бракованные товары;   - покупатель возвращает товар, но его нельзя вернуть в продажу. ", alias="deliveryDumpKgtOfficeBase")
    delivery_dump_kgt_office_liter: Optional[StrictStr] = Field(default=None, description="**Стоимость возврата при грузовой доставке, доставка на ПВЗ (доп. литр), ₽**<br> Стоимость за каждый дополнительный литр. ", alias="deliveryDumpKgtOfficeLiter")
    delivery_dump_kgt_return_expr: Optional[StrictStr] = Field(default=None, description="**Стоимость возврата при грузовой доставке, обратная логистика невостребованного возврата, ₽**<br> Грузовая доставка невостребованного возврата обратно на склад WB. За единицу товара. ", alias="deliveryDumpKgtReturnExpr")
    delivery_dump_srg_office_expr: Optional[StrictStr] = Field(default=None, description="**Стоимость возврата неопознанного складом товара за каждую единицу, доставка на ПВЗ, ₽**<br> Применяется для товаров, которые не смогли принять на складе. ", alias="deliveryDumpSrgOfficeExpr")
    delivery_dump_srg_return_expr: Optional[StrictStr] = Field(default=None, description="**Стоимость возврата неопознанного складом товара за каждую единицу, обратная логистика невостребованного возврата, ₽** <br>Доставка невостребованного возврата обратно на склад WB. ", alias="deliveryDumpSrgReturnExpr")
    delivery_dump_sup_courier_base: Optional[StrictStr] = Field(default=None, description="**Стоимость возврата, доставка курьером (базовая цена за 1 л), ₽**  Применяется, когда:   - продавец хочет вывезти товары со склада Wildberries   - на складе обнаружили бракованные товары   - покупатель возвращает товар, но его нельзя вернуть в продажу   - подключён автовозврат товаров, продаваемых по схеме Маркетплейс ", alias="deliveryDumpSupCourierBase")
    delivery_dump_sup_courier_liter: Optional[StrictStr] = Field(default=None, description="**Стоимость возврата, доставка курьером (доп. л), ₽** <br>Стоимость за каждый дополнительный литр. ", alias="deliveryDumpSupCourierLiter")
    delivery_dump_sup_office_base: Optional[StrictStr] = Field(default=None, description="**Стоимость возврата, доставка на ПВЗ (базовая цена за 1 л), ₽**  Применяется, когда:   - продавец хочет вывезти товары со склада Wildberries   - на складе обнаружили бракованные товары   - покупатель возвращает товар, но его нельзя вернуть в продажу   - подключён автовозврат товаров, продаваемых по схеме Маркетплейс ", alias="deliveryDumpSupOfficeBase")
    delivery_dump_sup_office_liter: Optional[StrictStr] = Field(default=None, description="**Стоимость возврата, доставка на ПВЗ (доп. литр), ₽** <br>Стоимость за каждый дополнительный литр ", alias="deliveryDumpSupOfficeLiter")
    delivery_dump_sup_return_expr: Optional[StrictStr] = Field(default=None, description="**Стоимость возврата, обратная логистика невостребованного возврата, за единицу товара, ₽**<br> Доставка невостребованного возврата обратно на склад Wildberries.  Применяется, когда:   - продавец хочет вывезти товары со склада Wildberries   - на складе обнаружили бракованные товары   - покупатель возвращает товар, но его нельзя вернуть в продажу   - подключён автовозврат товаров, продаваемых по схеме Маркетплейс ", alias="deliveryDumpSupReturnExpr")
    warehouse_name: Optional[StrictStr] = Field(default=None, description="Название склада", alias="warehouseName")
    __properties: ClassVar[List[str]] = ["deliveryDumpKgtOfficeBase", "deliveryDumpKgtOfficeLiter", "deliveryDumpKgtReturnExpr", "deliveryDumpSrgOfficeExpr", "deliveryDumpSrgReturnExpr", "deliveryDumpSupCourierBase", "deliveryDumpSupCourierLiter", "deliveryDumpSupOfficeBase", "deliveryDumpSupOfficeLiter", "deliveryDumpSupReturnExpr", "warehouseName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModelsWarehouseReturnRates from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModelsWarehouseReturnRates from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deliveryDumpKgtOfficeBase": obj.get("deliveryDumpKgtOfficeBase"),
            "deliveryDumpKgtOfficeLiter": obj.get("deliveryDumpKgtOfficeLiter"),
            "deliveryDumpKgtReturnExpr": obj.get("deliveryDumpKgtReturnExpr"),
            "deliveryDumpSrgOfficeExpr": obj.get("deliveryDumpSrgOfficeExpr"),
            "deliveryDumpSrgReturnExpr": obj.get("deliveryDumpSrgReturnExpr"),
            "deliveryDumpSupCourierBase": obj.get("deliveryDumpSupCourierBase"),
            "deliveryDumpSupCourierLiter": obj.get("deliveryDumpSupCourierLiter"),
            "deliveryDumpSupOfficeBase": obj.get("deliveryDumpSupOfficeBase"),
            "deliveryDumpSupOfficeLiter": obj.get("deliveryDumpSupOfficeLiter"),
            "deliveryDumpSupReturnExpr": obj.get("deliveryDumpSupReturnExpr"),
            "warehouseName": obj.get("warehouseName")
        })
        return _obj


