# coding: utf-8

"""
    Wildberries Цифровой

    По вопросам работы с WBD API обращайтесь в <a href=\"https://digital.wildberries.ru/support\" target=\"_blank\">техническую поддержку</a> 

    The version of the OpenAPI document: wbd
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr, field_validator
from typing import List, Optional, Tuple, Union
from typing_extensions import Annotated
from wildberries_sdk.wbd.models.content import Content
from wildberries_sdk.wbd.models.content_delete_request import ContentDeleteRequest
from wildberries_sdk.wbd.models.content_list import ContentList
from wildberries_sdk.wbd.models.get_full_catalog_response import GetFullCatalogResponse
from wildberries_sdk.wbd.models.illustration_response import IllustrationResponse
from wildberries_sdk.wbd.models.keys_count_response import KeysCountResponse
from wildberries_sdk.wbd.models.keys_delete_response import KeysDeleteResponse
from wildberries_sdk.wbd.models.keys_load_request import KeysLoadRequest
from wildberries_sdk.wbd.models.keys_redeemed_response_list import KeysRedeemedResponseList
from wildberries_sdk.wbd.models.keys_response_list import KeysResponseList
from wildberries_sdk.wbd.models.offer_create_request import OfferCreateRequest
from wildberries_sdk.wbd.models.offer_price_update_request import OfferPriceUpdateRequest
from wildberries_sdk.wbd.models.offer_response import OfferResponse
from wildberries_sdk.wbd.models.offer_response_list import OfferResponseList
from wildberries_sdk.wbd.models.offer_status_update_request import OfferStatusUpdateRequest
from wildberries_sdk.wbd.models.offer_update_request import OfferUpdateRequest
from wildberries_sdk.wbd.models.update_content_request import UpdateContentRequest
from wildberries_sdk.wbd.models.upload_chunk_response import UploadChunkResponse
from wildberries_sdk.wbd.models.upload_gallery_response import UploadGalleryResponse
from wildberries_sdk.wbd.models.upload_init_request import UploadInitRequest
from wildberries_sdk.wbd.models.upload_init_response import UploadInitResponse

from wildberries_sdk.wbd.api_client import ApiClient, RequestSerialized
from wildberries_sdk.wbd.api_response import ApiResponse
from wildberries_sdk.wbd.rest import RESTResponseType


class DefaultApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def content_author_get(
        self,
        search: Annotated[Optional[StrictStr], Field(description="Поиск по названию контента")] = None,
        category: Annotated[Optional[StrictInt], Field(description="Фильтрация по категории: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ ")] = None,
        status: Annotated[Optional[StrictInt], Field(description="Фильтрация по статусу: - `0` — Создан - `1` — Загружено на сервер - `2` — Опубликован - `3` — Ошибка в обработке или публикации - `4` — Обрабатывается - `5` — Отправлено на сервер ")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Сортировка контента по дате создания или обновления")] = None,
        sort_dir: Annotated[Optional[StrictStr], Field(description="Направление сортировки: - `asc` — по возрастанию - `desc` — по убыванию ")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Смещение. Количество контента, которые нужно пропустить в результирующем наборе.")] = None,
        take: Annotated[Optional[StrictInt], Field(description="Количество контента для получения")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ContentList:
        """Получить список своего контента

        Метод позволяет получить список своего контента с использованием фильтрации.<br><br>  **Описание параметров фильтрации**  - `search` — Поиск контента по названию. Укажите часть или полное название контента для поиска. - `category` — Фильтрация контента по категории. Список категорий находится в [таблице](/openapi/wbd#tag/Kontent/Kategorii-kontenta), колонка — `catalog_id` — Идентифицировать категории. - `status` — Фильтрация контента по статусу. Возможные значения:     - `0` — Создан     - `1` — Загружено на сервер     - `2` — Опубликован     - `3` — Ошибка в обработке или публикации     - `4` — Обрабатывается     - `5` — Отправлено на сервер - `sort` — Сортировка контента по дате создания или обновления. Укажите `created` для сортировки по дате создания и `updated` для сортировки по дате обновления. - `sort_dir` — Направление сортировки. Укажите `asc` для сортировки по возрастанию или `desc` для сортировки по убыванию. - `skip` — Смещение. Позволяет пропустить определенное количество контента в результирующем наборе.<br> **Например**, если `skip` равно 20, то выборка начнется с 21 записи. - `take` — Количество контента, которое нужно вернуть в ответе.<br> **Например**, если `take` равно 10, то в ответе будет не более 10 записей.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param search: Поиск по названию контента
        :type search: str
        :param category: Фильтрация по категории: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ 
        :type category: int
        :param status: Фильтрация по статусу: - `0` — Создан - `1` — Загружено на сервер - `2` — Опубликован - `3` — Ошибка в обработке или публикации - `4` — Обрабатывается - `5` — Отправлено на сервер 
        :type status: int
        :param sort: Сортировка контента по дате создания или обновления
        :type sort: str
        :param sort_dir: Направление сортировки: - `asc` — по возрастанию - `desc` — по убыванию 
        :type sort_dir: str
        :param skip: Смещение. Количество контента, которые нужно пропустить в результирующем наборе.
        :type skip: int
        :param take: Количество контента для получения
        :type take: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_author_get_serialize(
            search=search,
            category=category,
            status=status,
            sort=sort,
            sort_dir=sort_dir,
            skip=skip,
            take=take,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ContentList",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def content_author_get_with_http_info(
        self,
        search: Annotated[Optional[StrictStr], Field(description="Поиск по названию контента")] = None,
        category: Annotated[Optional[StrictInt], Field(description="Фильтрация по категории: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ ")] = None,
        status: Annotated[Optional[StrictInt], Field(description="Фильтрация по статусу: - `0` — Создан - `1` — Загружено на сервер - `2` — Опубликован - `3` — Ошибка в обработке или публикации - `4` — Обрабатывается - `5` — Отправлено на сервер ")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Сортировка контента по дате создания или обновления")] = None,
        sort_dir: Annotated[Optional[StrictStr], Field(description="Направление сортировки: - `asc` — по возрастанию - `desc` — по убыванию ")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Смещение. Количество контента, которые нужно пропустить в результирующем наборе.")] = None,
        take: Annotated[Optional[StrictInt], Field(description="Количество контента для получения")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[ContentList]:
        """Получить список своего контента

        Метод позволяет получить список своего контента с использованием фильтрации.<br><br>  **Описание параметров фильтрации**  - `search` — Поиск контента по названию. Укажите часть или полное название контента для поиска. - `category` — Фильтрация контента по категории. Список категорий находится в [таблице](/openapi/wbd#tag/Kontent/Kategorii-kontenta), колонка — `catalog_id` — Идентифицировать категории. - `status` — Фильтрация контента по статусу. Возможные значения:     - `0` — Создан     - `1` — Загружено на сервер     - `2` — Опубликован     - `3` — Ошибка в обработке или публикации     - `4` — Обрабатывается     - `5` — Отправлено на сервер - `sort` — Сортировка контента по дате создания или обновления. Укажите `created` для сортировки по дате создания и `updated` для сортировки по дате обновления. - `sort_dir` — Направление сортировки. Укажите `asc` для сортировки по возрастанию или `desc` для сортировки по убыванию. - `skip` — Смещение. Позволяет пропустить определенное количество контента в результирующем наборе.<br> **Например**, если `skip` равно 20, то выборка начнется с 21 записи. - `take` — Количество контента, которое нужно вернуть в ответе.<br> **Например**, если `take` равно 10, то в ответе будет не более 10 записей.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param search: Поиск по названию контента
        :type search: str
        :param category: Фильтрация по категории: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ 
        :type category: int
        :param status: Фильтрация по статусу: - `0` — Создан - `1` — Загружено на сервер - `2` — Опубликован - `3` — Ошибка в обработке или публикации - `4` — Обрабатывается - `5` — Отправлено на сервер 
        :type status: int
        :param sort: Сортировка контента по дате создания или обновления
        :type sort: str
        :param sort_dir: Направление сортировки: - `asc` — по возрастанию - `desc` — по убыванию 
        :type sort_dir: str
        :param skip: Смещение. Количество контента, которые нужно пропустить в результирующем наборе.
        :type skip: int
        :param take: Количество контента для получения
        :type take: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_author_get_serialize(
            search=search,
            category=category,
            status=status,
            sort=sort,
            sort_dir=sort_dir,
            skip=skip,
            take=take,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ContentList",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def content_author_get_without_preload_content(
        self,
        search: Annotated[Optional[StrictStr], Field(description="Поиск по названию контента")] = None,
        category: Annotated[Optional[StrictInt], Field(description="Фильтрация по категории: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ ")] = None,
        status: Annotated[Optional[StrictInt], Field(description="Фильтрация по статусу: - `0` — Создан - `1` — Загружено на сервер - `2` — Опубликован - `3` — Ошибка в обработке или публикации - `4` — Обрабатывается - `5` — Отправлено на сервер ")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Сортировка контента по дате создания или обновления")] = None,
        sort_dir: Annotated[Optional[StrictStr], Field(description="Направление сортировки: - `asc` — по возрастанию - `desc` — по убыванию ")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Смещение. Количество контента, которые нужно пропустить в результирующем наборе.")] = None,
        take: Annotated[Optional[StrictInt], Field(description="Количество контента для получения")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Получить список своего контента

        Метод позволяет получить список своего контента с использованием фильтрации.<br><br>  **Описание параметров фильтрации**  - `search` — Поиск контента по названию. Укажите часть или полное название контента для поиска. - `category` — Фильтрация контента по категории. Список категорий находится в [таблице](/openapi/wbd#tag/Kontent/Kategorii-kontenta), колонка — `catalog_id` — Идентифицировать категории. - `status` — Фильтрация контента по статусу. Возможные значения:     - `0` — Создан     - `1` — Загружено на сервер     - `2` — Опубликован     - `3` — Ошибка в обработке или публикации     - `4` — Обрабатывается     - `5` — Отправлено на сервер - `sort` — Сортировка контента по дате создания или обновления. Укажите `created` для сортировки по дате создания и `updated` для сортировки по дате обновления. - `sort_dir` — Направление сортировки. Укажите `asc` для сортировки по возрастанию или `desc` для сортировки по убыванию. - `skip` — Смещение. Позволяет пропустить определенное количество контента в результирующем наборе.<br> **Например**, если `skip` равно 20, то выборка начнется с 21 записи. - `take` — Количество контента, которое нужно вернуть в ответе.<br> **Например**, если `take` равно 10, то в ответе будет не более 10 записей.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param search: Поиск по названию контента
        :type search: str
        :param category: Фильтрация по категории: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ 
        :type category: int
        :param status: Фильтрация по статусу: - `0` — Создан - `1` — Загружено на сервер - `2` — Опубликован - `3` — Ошибка в обработке или публикации - `4` — Обрабатывается - `5` — Отправлено на сервер 
        :type status: int
        :param sort: Сортировка контента по дате создания или обновления
        :type sort: str
        :param sort_dir: Направление сортировки: - `asc` — по возрастанию - `desc` — по убыванию 
        :type sort_dir: str
        :param skip: Смещение. Количество контента, которые нужно пропустить в результирующем наборе.
        :type skip: int
        :param take: Количество контента для получения
        :type take: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_author_get_serialize(
            search=search,
            category=category,
            status=status,
            sort=sort,
            sort_dir=sort_dir,
            skip=skip,
            take=take,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ContentList",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _content_author_get_serialize(
        self,
        search,
        category,
        status,
        sort,
        sort_dir,
        skip,
        take,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if search is not None:
            
            _query_params.append(('search', search))
            
        if category is not None:
            
            _query_params.append(('category', category))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if sort_dir is not None:
            
            _query_params.append(('sort_dir', sort_dir))
            
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if take is not None:
            
            _query_params.append(('take', take))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/content/author',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def content_delete(
        self,
        content_delete_request: ContentDeleteRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """Удалить контент

        Метод позволяет удалить контент по ID.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param content_delete_request: (required)
        :type content_delete_request: ContentDeleteRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_delete_serialize(
            content_delete_request=content_delete_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def content_delete_with_http_info(
        self,
        content_delete_request: ContentDeleteRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """Удалить контент

        Метод позволяет удалить контент по ID.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param content_delete_request: (required)
        :type content_delete_request: ContentDeleteRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_delete_serialize(
            content_delete_request=content_delete_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def content_delete_without_preload_content(
        self,
        content_delete_request: ContentDeleteRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Удалить контент

        Метод позволяет удалить контент по ID.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param content_delete_request: (required)
        :type content_delete_request: ContentDeleteRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_delete_serialize(
            content_delete_request=content_delete_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _content_delete_serialize(
        self,
        content_delete_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if content_delete_request is not None:
            _body_params = content_delete_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/content/delete',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def content_download_get(
        self,
        uri: Annotated[StrictStr, Field(description="URI-адрес контента")],
        range: Annotated[Optional[StrictStr], Field(description="Позволять скачивать файл частями.<br><br>  **Пример**: `bytes=0-524287999` ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """Скачать контент

        Метод позволяет скачать контент по URI.<br><br>  **Получение URI-адреса контента** 1. Воспользуйтесь одним из методов для получения информации о контенте.     - [Получить информацию о контенте](/openapi/wbd#tag/Kontent/operation/contentIdGet)     - [Получить список своего контента](/openapi/wbd#tag/Kontent/operation/contentAuthorGet) 2. В информации о контенте возьмите URI-адрес из поля `uri` или `files`.  **Скачивание контента частями**<br><br> Вы можете скачать файл частями с использованием заголовка `Range`.<br><br>  **Пример**: `Range: bytes=0-524287999`<br><br>  Ответ содержит заголовок `Content-Range` с информацией о скаченном файле.<br><br>  **Пример**: `Content-Range: bytes 0-524287999/1073741824`  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param uri: URI-адрес контента (required)
        :type uri: str
        :param range: Позволять скачивать файл частями.<br><br>  **Пример**: `bytes=0-524287999` 
        :type range: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_download_get_serialize(
            uri=uri,
            range=range,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '206': None,
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
            '502': "ProblemDetails502",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def content_download_get_with_http_info(
        self,
        uri: Annotated[StrictStr, Field(description="URI-адрес контента")],
        range: Annotated[Optional[StrictStr], Field(description="Позволять скачивать файл частями.<br><br>  **Пример**: `bytes=0-524287999` ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """Скачать контент

        Метод позволяет скачать контент по URI.<br><br>  **Получение URI-адреса контента** 1. Воспользуйтесь одним из методов для получения информации о контенте.     - [Получить информацию о контенте](/openapi/wbd#tag/Kontent/operation/contentIdGet)     - [Получить список своего контента](/openapi/wbd#tag/Kontent/operation/contentAuthorGet) 2. В информации о контенте возьмите URI-адрес из поля `uri` или `files`.  **Скачивание контента частями**<br><br> Вы можете скачать файл частями с использованием заголовка `Range`.<br><br>  **Пример**: `Range: bytes=0-524287999`<br><br>  Ответ содержит заголовок `Content-Range` с информацией о скаченном файле.<br><br>  **Пример**: `Content-Range: bytes 0-524287999/1073741824`  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param uri: URI-адрес контента (required)
        :type uri: str
        :param range: Позволять скачивать файл частями.<br><br>  **Пример**: `bytes=0-524287999` 
        :type range: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_download_get_serialize(
            uri=uri,
            range=range,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '206': None,
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
            '502': "ProblemDetails502",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def content_download_get_without_preload_content(
        self,
        uri: Annotated[StrictStr, Field(description="URI-адрес контента")],
        range: Annotated[Optional[StrictStr], Field(description="Позволять скачивать файл частями.<br><br>  **Пример**: `bytes=0-524287999` ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Скачать контент

        Метод позволяет скачать контент по URI.<br><br>  **Получение URI-адреса контента** 1. Воспользуйтесь одним из методов для получения информации о контенте.     - [Получить информацию о контенте](/openapi/wbd#tag/Kontent/operation/contentIdGet)     - [Получить список своего контента](/openapi/wbd#tag/Kontent/operation/contentAuthorGet) 2. В информации о контенте возьмите URI-адрес из поля `uri` или `files`.  **Скачивание контента частями**<br><br> Вы можете скачать файл частями с использованием заголовка `Range`.<br><br>  **Пример**: `Range: bytes=0-524287999`<br><br>  Ответ содержит заголовок `Content-Range` с информацией о скаченном файле.<br><br>  **Пример**: `Content-Range: bytes 0-524287999/1073741824`  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param uri: URI-адрес контента (required)
        :type uri: str
        :param range: Позволять скачивать файл частями.<br><br>  **Пример**: `bytes=0-524287999` 
        :type range: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_download_get_serialize(
            uri=uri,
            range=range,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '206': None,
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
            '502': "ProblemDetails502",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _content_download_get_serialize(
        self,
        uri,
        range,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if uri is not None:
            _path_params['uri'] = uri
        # process the query parameters
        # process the header parameters
        if range is not None:
            _header_params['Range'] = range
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/content/download/{uri}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def content_gallery(
        self,
        files: List[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> UploadGalleryResponse:
        """Загрузить медиафайлы для предложения

        Метод позволяет загружать медиафайлы на сервер.<br><br>  После успешной загрузки возвращает список URI-адресов, которые можно использовать для добавления дополнительных медиафайлов в предложение.<br><br>  Данный метод поможет вам добавить дополнительные медиафайлы при создании или обновлении предложения. - [Создать новое предложение](/openapi/wbd#tag/Predlozheniya/operation/offerCreate) - [Редактировать предложение](/openapi/wbd#tag/Predlozheniya/operation/offerUpdate)  <div class=\"description_important\">   Ограничения по размеру:   <ul>       <li>изображение: <b>5 Мб</b></li>       <li>видео: <b>50 Мб</b></li>       <li>общий размер всех файлов: <b>100 Мб</b></li>   </ul>   Допустимые форматы:   <ul>       <li>изображение: <b>PNG, JPEG</b></li>       <li>видео: <b>MP4</b></li>   </ul>   Можно передать <b>до 8 медиафайлов</b>. </div>  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param files: (required)
        :type files: List[bytearray]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_gallery_serialize(
            files=files,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UploadGalleryResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def content_gallery_with_http_info(
        self,
        files: List[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[UploadGalleryResponse]:
        """Загрузить медиафайлы для предложения

        Метод позволяет загружать медиафайлы на сервер.<br><br>  После успешной загрузки возвращает список URI-адресов, которые можно использовать для добавления дополнительных медиафайлов в предложение.<br><br>  Данный метод поможет вам добавить дополнительные медиафайлы при создании или обновлении предложения. - [Создать новое предложение](/openapi/wbd#tag/Predlozheniya/operation/offerCreate) - [Редактировать предложение](/openapi/wbd#tag/Predlozheniya/operation/offerUpdate)  <div class=\"description_important\">   Ограничения по размеру:   <ul>       <li>изображение: <b>5 Мб</b></li>       <li>видео: <b>50 Мб</b></li>       <li>общий размер всех файлов: <b>100 Мб</b></li>   </ul>   Допустимые форматы:   <ul>       <li>изображение: <b>PNG, JPEG</b></li>       <li>видео: <b>MP4</b></li>   </ul>   Можно передать <b>до 8 медиафайлов</b>. </div>  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param files: (required)
        :type files: List[bytearray]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_gallery_serialize(
            files=files,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UploadGalleryResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def content_gallery_without_preload_content(
        self,
        files: List[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Загрузить медиафайлы для предложения

        Метод позволяет загружать медиафайлы на сервер.<br><br>  После успешной загрузки возвращает список URI-адресов, которые можно использовать для добавления дополнительных медиафайлов в предложение.<br><br>  Данный метод поможет вам добавить дополнительные медиафайлы при создании или обновлении предложения. - [Создать новое предложение](/openapi/wbd#tag/Predlozheniya/operation/offerCreate) - [Редактировать предложение](/openapi/wbd#tag/Predlozheniya/operation/offerUpdate)  <div class=\"description_important\">   Ограничения по размеру:   <ul>       <li>изображение: <b>5 Мб</b></li>       <li>видео: <b>50 Мб</b></li>       <li>общий размер всех файлов: <b>100 Мб</b></li>   </ul>   Допустимые форматы:   <ul>       <li>изображение: <b>PNG, JPEG</b></li>       <li>видео: <b>MP4</b></li>   </ul>   Можно передать <b>до 8 медиафайлов</b>. </div>  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param files: (required)
        :type files: List[bytearray]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_gallery_serialize(
            files=files,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UploadGalleryResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _content_gallery_serialize(
        self,
        files,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
            'files': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if files is not None:
            _files['files'] = files
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/content/gallery',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def content_id_get(
        self,
        content_id: Annotated[StrictInt, Field(description="ID контента")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> Content:
        """Получить информацию о контенте

        Метод позволяет получить информацию о конкретном контенте.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param content_id: ID контента (required)
        :type content_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_id_get_serialize(
            content_id=content_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Content",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def content_id_get_with_http_info(
        self,
        content_id: Annotated[StrictInt, Field(description="ID контента")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[Content]:
        """Получить информацию о контенте

        Метод позволяет получить информацию о конкретном контенте.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param content_id: ID контента (required)
        :type content_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_id_get_serialize(
            content_id=content_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Content",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def content_id_get_without_preload_content(
        self,
        content_id: Annotated[StrictInt, Field(description="ID контента")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Получить информацию о контенте

        Метод позволяет получить информацию о конкретном контенте.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param content_id: ID контента (required)
        :type content_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_id_get_serialize(
            content_id=content_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Content",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _content_id_get_serialize(
        self,
        content_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if content_id is not None:
            _path_params['content_id'] = content_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/content/author/{content_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def content_update(
        self,
        content_id: Annotated[StrictInt, Field(description="ID контента")],
        update_content_request: UpdateContentRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> Content:
        """Редактировать контент

        Метод позволяет редактировать информацию о контенте.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param content_id: ID контента (required)
        :type content_id: int
        :param update_content_request: (required)
        :type update_content_request: UpdateContentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_update_serialize(
            content_id=content_id,
            update_content_request=update_content_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Content",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def content_update_with_http_info(
        self,
        content_id: Annotated[StrictInt, Field(description="ID контента")],
        update_content_request: UpdateContentRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[Content]:
        """Редактировать контент

        Метод позволяет редактировать информацию о контенте.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param content_id: ID контента (required)
        :type content_id: int
        :param update_content_request: (required)
        :type update_content_request: UpdateContentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_update_serialize(
            content_id=content_id,
            update_content_request=update_content_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Content",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def content_update_without_preload_content(
        self,
        content_id: Annotated[StrictInt, Field(description="ID контента")],
        update_content_request: UpdateContentRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Редактировать контент

        Метод позволяет редактировать информацию о контенте.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param content_id: ID контента (required)
        :type content_id: int
        :param update_content_request: (required)
        :type update_content_request: UpdateContentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_update_serialize(
            content_id=content_id,
            update_content_request=update_content_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Content",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _content_update_serialize(
        self,
        content_id,
        update_content_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if content_id is not None:
            _path_params['content_id'] = content_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_content_request is not None:
            _body_params = update_content_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/content/author/{content_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def content_upload_chunk(
        self,
        x_content_type: Annotated[StrictStr, Field(description="Тип файла")],
        x_wbd_part_index: Annotated[StrictInt, Field(description="Индекс фрейма (части контента)")],
        x_wbd_content_uuid: Annotated[StrictStr, Field(description="Уникальный ID полученный в [инициализации нового контента](./wbd#tag/Kontent/operation/contentUploadInit)")],
        body: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> UploadChunkResponse:
        """Загрузить контент (файл)

        Метод позволяет загрузить контент (файл) по частям.<br><br>  Краткая инструкция по применению: 1. Разбейте файл на части размером не более 2 Мб. 2. Для каждой части файла:   - Убедитесь, что заголовок `X-Content-Type` соответствует типу вашего контента (например, `video/mp4`, `audio/mpeg`, `application/pdf` и т.д.).   - Установите заголовок `X-Wbd-Part-Index` в соответствии с индексом текущей части (начиная с 1).   - Укажите `uuid` контента в заголовке `X-Wbd-Content-Uuid`, который вы получили при [инициализации нового контента](/openapi/wbd#tag/Kontent/operation/contentUploadInit).   - Отправьте байты (часть файла) в теле запроса. 3. Повторяйте шаг 2 для всех частей файла до завершения загрузки.  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param x_content_type: Тип файла (required)
        :type x_content_type: str
        :param x_wbd_part_index: Индекс фрейма (части контента) (required)
        :type x_wbd_part_index: int
        :param x_wbd_content_uuid: Уникальный ID полученный в [инициализации нового контента](./wbd#tag/Kontent/operation/contentUploadInit) (required)
        :type x_wbd_content_uuid: str
        :param body: (required)
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_upload_chunk_serialize(
            x_content_type=x_content_type,
            x_wbd_part_index=x_wbd_part_index,
            x_wbd_content_uuid=x_wbd_content_uuid,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UploadChunkResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def content_upload_chunk_with_http_info(
        self,
        x_content_type: Annotated[StrictStr, Field(description="Тип файла")],
        x_wbd_part_index: Annotated[StrictInt, Field(description="Индекс фрейма (части контента)")],
        x_wbd_content_uuid: Annotated[StrictStr, Field(description="Уникальный ID полученный в [инициализации нового контента](./wbd#tag/Kontent/operation/contentUploadInit)")],
        body: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[UploadChunkResponse]:
        """Загрузить контент (файл)

        Метод позволяет загрузить контент (файл) по частям.<br><br>  Краткая инструкция по применению: 1. Разбейте файл на части размером не более 2 Мб. 2. Для каждой части файла:   - Убедитесь, что заголовок `X-Content-Type` соответствует типу вашего контента (например, `video/mp4`, `audio/mpeg`, `application/pdf` и т.д.).   - Установите заголовок `X-Wbd-Part-Index` в соответствии с индексом текущей части (начиная с 1).   - Укажите `uuid` контента в заголовке `X-Wbd-Content-Uuid`, который вы получили при [инициализации нового контента](/openapi/wbd#tag/Kontent/operation/contentUploadInit).   - Отправьте байты (часть файла) в теле запроса. 3. Повторяйте шаг 2 для всех частей файла до завершения загрузки.  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param x_content_type: Тип файла (required)
        :type x_content_type: str
        :param x_wbd_part_index: Индекс фрейма (части контента) (required)
        :type x_wbd_part_index: int
        :param x_wbd_content_uuid: Уникальный ID полученный в [инициализации нового контента](./wbd#tag/Kontent/operation/contentUploadInit) (required)
        :type x_wbd_content_uuid: str
        :param body: (required)
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_upload_chunk_serialize(
            x_content_type=x_content_type,
            x_wbd_part_index=x_wbd_part_index,
            x_wbd_content_uuid=x_wbd_content_uuid,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UploadChunkResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def content_upload_chunk_without_preload_content(
        self,
        x_content_type: Annotated[StrictStr, Field(description="Тип файла")],
        x_wbd_part_index: Annotated[StrictInt, Field(description="Индекс фрейма (части контента)")],
        x_wbd_content_uuid: Annotated[StrictStr, Field(description="Уникальный ID полученный в [инициализации нового контента](./wbd#tag/Kontent/operation/contentUploadInit)")],
        body: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Загрузить контент (файл)

        Метод позволяет загрузить контент (файл) по частям.<br><br>  Краткая инструкция по применению: 1. Разбейте файл на части размером не более 2 Мб. 2. Для каждой части файла:   - Убедитесь, что заголовок `X-Content-Type` соответствует типу вашего контента (например, `video/mp4`, `audio/mpeg`, `application/pdf` и т.д.).   - Установите заголовок `X-Wbd-Part-Index` в соответствии с индексом текущей части (начиная с 1).   - Укажите `uuid` контента в заголовке `X-Wbd-Content-Uuid`, который вы получили при [инициализации нового контента](/openapi/wbd#tag/Kontent/operation/contentUploadInit).   - Отправьте байты (часть файла) в теле запроса. 3. Повторяйте шаг 2 для всех частей файла до завершения загрузки.  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param x_content_type: Тип файла (required)
        :type x_content_type: str
        :param x_wbd_part_index: Индекс фрейма (части контента) (required)
        :type x_wbd_part_index: int
        :param x_wbd_content_uuid: Уникальный ID полученный в [инициализации нового контента](./wbd#tag/Kontent/operation/contentUploadInit) (required)
        :type x_wbd_content_uuid: str
        :param body: (required)
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_upload_chunk_serialize(
            x_content_type=x_content_type,
            x_wbd_part_index=x_wbd_part_index,
            x_wbd_content_uuid=x_wbd_content_uuid,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UploadChunkResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _content_upload_chunk_serialize(
        self,
        x_content_type,
        x_wbd_part_index,
        x_wbd_content_uuid,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_content_type is not None:
            _header_params['X-Content-Type'] = x_content_type
        if x_wbd_part_index is not None:
            _header_params['X-Wbd-Part-Index'] = x_wbd_part_index
        if x_wbd_content_uuid is not None:
            _header_params['X-Wbd-Content-Uuid'] = x_wbd_content_uuid
        # process the form parameters
        # process the body parameter
        if body is not None:
            # convert to byte array if the input is a file name (str)
            if isinstance(body, str):
                with open(body, "rb") as _fp:
                    _body_params = _fp.read()
            elif isinstance(body, tuple):
                # drop the filename from the tuple
                _body_params = body[1]
            else:
                _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/octet-stream'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/content/upload/chunk',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def content_upload_illustration(
        self,
        x_content_type: Annotated[StrictStr, Field(description="Тип файла")],
        body: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> IllustrationResponse:
        """Загрузить обложку контента

        Метод позволяет загрузить обложку контента.  <div class=\"description_important\">   Максимальный размер файла: 5 Мб<br>   Допустимые форматы: PNG, JPEG<br>   Рекомендации:   <ul>       <li>Соотношение сторон 1:1</li>   </ul> </div>  Краткая инструкция по применению: 1. Убедитесь, что ваш файл соответствует указанным ограничениям и рекомендациям. 2. Вызовите этот метод. 3. При загрузке обложки вы получите список URI адресов для нового контента. 4. Воспользуйтесь методом [Инициализировать новый контент](/openapi/wbd#tag/Kontent/operation/contentUploadInit) и передайте список URI адресов в поле `meta` в формате **JSON** используя следующий пример.  **Пример:**  ```json {     \"meta\": {         \"thumbnail\": [             \"vol6/529/013cfs7f229183179aj53d2b3bbb839a/480.jpg\",             \"vol6/529/013cfs7f229183179aj53d2b3bbb839a/1280.jpg\",             \"vol6/529/013cfs7f229183179aj53d2b3bbb839a/1920.jpg\"         ]     } } ```  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param x_content_type: Тип файла (required)
        :type x_content_type: str
        :param body: (required)
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_upload_illustration_serialize(
            x_content_type=x_content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "IllustrationResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def content_upload_illustration_with_http_info(
        self,
        x_content_type: Annotated[StrictStr, Field(description="Тип файла")],
        body: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[IllustrationResponse]:
        """Загрузить обложку контента

        Метод позволяет загрузить обложку контента.  <div class=\"description_important\">   Максимальный размер файла: 5 Мб<br>   Допустимые форматы: PNG, JPEG<br>   Рекомендации:   <ul>       <li>Соотношение сторон 1:1</li>   </ul> </div>  Краткая инструкция по применению: 1. Убедитесь, что ваш файл соответствует указанным ограничениям и рекомендациям. 2. Вызовите этот метод. 3. При загрузке обложки вы получите список URI адресов для нового контента. 4. Воспользуйтесь методом [Инициализировать новый контент](/openapi/wbd#tag/Kontent/operation/contentUploadInit) и передайте список URI адресов в поле `meta` в формате **JSON** используя следующий пример.  **Пример:**  ```json {     \"meta\": {         \"thumbnail\": [             \"vol6/529/013cfs7f229183179aj53d2b3bbb839a/480.jpg\",             \"vol6/529/013cfs7f229183179aj53d2b3bbb839a/1280.jpg\",             \"vol6/529/013cfs7f229183179aj53d2b3bbb839a/1920.jpg\"         ]     } } ```  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param x_content_type: Тип файла (required)
        :type x_content_type: str
        :param body: (required)
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_upload_illustration_serialize(
            x_content_type=x_content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "IllustrationResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def content_upload_illustration_without_preload_content(
        self,
        x_content_type: Annotated[StrictStr, Field(description="Тип файла")],
        body: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Загрузить обложку контента

        Метод позволяет загрузить обложку контента.  <div class=\"description_important\">   Максимальный размер файла: 5 Мб<br>   Допустимые форматы: PNG, JPEG<br>   Рекомендации:   <ul>       <li>Соотношение сторон 1:1</li>   </ul> </div>  Краткая инструкция по применению: 1. Убедитесь, что ваш файл соответствует указанным ограничениям и рекомендациям. 2. Вызовите этот метод. 3. При загрузке обложки вы получите список URI адресов для нового контента. 4. Воспользуйтесь методом [Инициализировать новый контент](/openapi/wbd#tag/Kontent/operation/contentUploadInit) и передайте список URI адресов в поле `meta` в формате **JSON** используя следующий пример.  **Пример:**  ```json {     \"meta\": {         \"thumbnail\": [             \"vol6/529/013cfs7f229183179aj53d2b3bbb839a/480.jpg\",             \"vol6/529/013cfs7f229183179aj53d2b3bbb839a/1280.jpg\",             \"vol6/529/013cfs7f229183179aj53d2b3bbb839a/1920.jpg\"         ]     } } ```  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param x_content_type: Тип файла (required)
        :type x_content_type: str
        :param body: (required)
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_upload_illustration_serialize(
            x_content_type=x_content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "IllustrationResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _content_upload_illustration_serialize(
        self,
        x_content_type,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_content_type is not None:
            _header_params['X-Content-Type'] = x_content_type
        # process the form parameters
        # process the body parameter
        if body is not None:
            # convert to byte array if the input is a file name (str)
            if isinstance(body, str):
                with open(body, "rb") as _fp:
                    _body_params = _fp.read()
            elif isinstance(body, tuple):
                # drop the filename from the tuple
                _body_params = body[1]
            else:
                _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/octet-stream'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/content/illustration',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def content_upload_init(
        self,
        upload_init_request: UploadInitRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> UploadInitResponse:
        """Инициализировать новый контент

        Метод позволяет инициализировать (загрузить) информацию нового контента.<br><br>  Типы контента и требования к ним вы можете посмотреть в оглавлении [Работа с контентом](/openapi/wbd#tag/Kontent).<br><br>  Подготовка файла к последующей загрузке: - Вам необходимо разбить файл на части (фреймы) не более 2 Мб. - Передать размер (в байтах) каждой части и порядковый номер в параметре `parts`.  **Пример:**<br> Файл размером 5 Мб, нужно разбить на 3 части — 2 Мб, 2 Мб и 1 Мб. ```json {     \"parts\": [         {           \"index\": 1,           \"size\": 2097152         },         {           \"index\": 2,           \"size\": 2097152         },         {           \"index\": 3,           \"size\": 1048576         }     ], } ```  В методе [Загрузить контент (файл)](/openapi/wbd#tag/Kontent/operation/contentUploadChunk) вам нужно будет загрузить 3 части файла с указанием их порядкового номера через `X-Wbd-Part-Index`.<br><br>  **Обязательные поля в метаданных (`meta`) для загрузки контента**<br><br>  Общие поля: - `thumbnail` - `rating`  Аудиоконтент: - `author`  Документ: - `author` - `pages`  Краткая инструкция по применению: 1. Подготовьте метаданные и информацию о вашем контенте. 2. Убедитесь, что ваш контент соответствует [требованиям](/openapi/wbd#tag/Kontent/Trebovaniya-k-kontentu) (формат и размер файла). 3. Вызовите этот метод для инициализации нового контента. 4. В ответе вы получите `uuid` контента, необходимый для последующей загрузки самого файла. 5. Используйте метод [Загрузить файл контента](/openapi/wbd#tag/Kontent/operation/contentUploadChunk), чтобы загрузить файл.  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param upload_init_request: (required)
        :type upload_init_request: UploadInitRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_upload_init_serialize(
            upload_init_request=upload_init_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UploadInitResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def content_upload_init_with_http_info(
        self,
        upload_init_request: UploadInitRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[UploadInitResponse]:
        """Инициализировать новый контент

        Метод позволяет инициализировать (загрузить) информацию нового контента.<br><br>  Типы контента и требования к ним вы можете посмотреть в оглавлении [Работа с контентом](/openapi/wbd#tag/Kontent).<br><br>  Подготовка файла к последующей загрузке: - Вам необходимо разбить файл на части (фреймы) не более 2 Мб. - Передать размер (в байтах) каждой части и порядковый номер в параметре `parts`.  **Пример:**<br> Файл размером 5 Мб, нужно разбить на 3 части — 2 Мб, 2 Мб и 1 Мб. ```json {     \"parts\": [         {           \"index\": 1,           \"size\": 2097152         },         {           \"index\": 2,           \"size\": 2097152         },         {           \"index\": 3,           \"size\": 1048576         }     ], } ```  В методе [Загрузить контент (файл)](/openapi/wbd#tag/Kontent/operation/contentUploadChunk) вам нужно будет загрузить 3 части файла с указанием их порядкового номера через `X-Wbd-Part-Index`.<br><br>  **Обязательные поля в метаданных (`meta`) для загрузки контента**<br><br>  Общие поля: - `thumbnail` - `rating`  Аудиоконтент: - `author`  Документ: - `author` - `pages`  Краткая инструкция по применению: 1. Подготовьте метаданные и информацию о вашем контенте. 2. Убедитесь, что ваш контент соответствует [требованиям](/openapi/wbd#tag/Kontent/Trebovaniya-k-kontentu) (формат и размер файла). 3. Вызовите этот метод для инициализации нового контента. 4. В ответе вы получите `uuid` контента, необходимый для последующей загрузки самого файла. 5. Используйте метод [Загрузить файл контента](/openapi/wbd#tag/Kontent/operation/contentUploadChunk), чтобы загрузить файл.  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param upload_init_request: (required)
        :type upload_init_request: UploadInitRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_upload_init_serialize(
            upload_init_request=upload_init_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UploadInitResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def content_upload_init_without_preload_content(
        self,
        upload_init_request: UploadInitRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Инициализировать новый контент

        Метод позволяет инициализировать (загрузить) информацию нового контента.<br><br>  Типы контента и требования к ним вы можете посмотреть в оглавлении [Работа с контентом](/openapi/wbd#tag/Kontent).<br><br>  Подготовка файла к последующей загрузке: - Вам необходимо разбить файл на части (фреймы) не более 2 Мб. - Передать размер (в байтах) каждой части и порядковый номер в параметре `parts`.  **Пример:**<br> Файл размером 5 Мб, нужно разбить на 3 части — 2 Мб, 2 Мб и 1 Мб. ```json {     \"parts\": [         {           \"index\": 1,           \"size\": 2097152         },         {           \"index\": 2,           \"size\": 2097152         },         {           \"index\": 3,           \"size\": 1048576         }     ], } ```  В методе [Загрузить контент (файл)](/openapi/wbd#tag/Kontent/operation/contentUploadChunk) вам нужно будет загрузить 3 части файла с указанием их порядкового номера через `X-Wbd-Part-Index`.<br><br>  **Обязательные поля в метаданных (`meta`) для загрузки контента**<br><br>  Общие поля: - `thumbnail` - `rating`  Аудиоконтент: - `author`  Документ: - `author` - `pages`  Краткая инструкция по применению: 1. Подготовьте метаданные и информацию о вашем контенте. 2. Убедитесь, что ваш контент соответствует [требованиям](/openapi/wbd#tag/Kontent/Trebovaniya-k-kontentu) (формат и размер файла). 3. Вызовите этот метод для инициализации нового контента. 4. В ответе вы получите `uuid` контента, необходимый для последующей загрузки самого файла. 5. Используйте метод [Загрузить файл контента](/openapi/wbd#tag/Kontent/operation/contentUploadChunk), чтобы загрузить файл.  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param upload_init_request: (required)
        :type upload_init_request: UploadInitRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._content_upload_init_serialize(
            upload_init_request=upload_init_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UploadInitResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _content_upload_init_serialize(
        self,
        upload_init_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if upload_init_request is not None:
            _body_params = upload_init_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/content/upload/init',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_keys_by_ids(
        self,
        ids: Annotated[List[StrictInt], Field(description="Список ID ключей")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> KeysDeleteResponse:
        """Удалить ключи активации

        Метод позволяет удалить ключи активации по их ID.  <div class=\"description_important\">   Доступ к методу предоставляется через заявку в <a href=\"https://digital.wildberries.ru/support\" target=\"_black\">техническую поддержку</a>. </div>  <div class=\"description_limit\">     Максимум 100 запросов в секунду </div> 

        :param ids: Список ID ключей (required)
        :type ids: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_keys_by_ids_serialize(
            ids=ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KeysDeleteResponse",
            '207': "KeysDeleteResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '403': "ProblemDetails403",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_keys_by_ids_with_http_info(
        self,
        ids: Annotated[List[StrictInt], Field(description="Список ID ключей")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[KeysDeleteResponse]:
        """Удалить ключи активации

        Метод позволяет удалить ключи активации по их ID.  <div class=\"description_important\">   Доступ к методу предоставляется через заявку в <a href=\"https://digital.wildberries.ru/support\" target=\"_black\">техническую поддержку</a>. </div>  <div class=\"description_limit\">     Максимум 100 запросов в секунду </div> 

        :param ids: Список ID ключей (required)
        :type ids: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_keys_by_ids_serialize(
            ids=ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KeysDeleteResponse",
            '207': "KeysDeleteResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '403': "ProblemDetails403",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_keys_by_ids_without_preload_content(
        self,
        ids: Annotated[List[StrictInt], Field(description="Список ID ключей")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Удалить ключи активации

        Метод позволяет удалить ключи активации по их ID.  <div class=\"description_important\">   Доступ к методу предоставляется через заявку в <a href=\"https://digital.wildberries.ru/support\" target=\"_black\">техническую поддержку</a>. </div>  <div class=\"description_limit\">     Максимум 100 запросов в секунду </div> 

        :param ids: Список ID ключей (required)
        :type ids: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_keys_by_ids_serialize(
            ids=ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KeysDeleteResponse",
            '207': "KeysDeleteResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '403': "ProblemDetails403",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_keys_by_ids_serialize(
        self,
        ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
            'ids': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if ids is not None:
            
            _query_params.append(('ids', ids))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v1/keys-api/keys',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_catalog(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> GetFullCatalogResponse:
        """Получить категории и их подкатегории

        Метод позволяет получить дерево (структуру данных) с категориям и их подкатегориями.<br><br>  **Иерархия структуры данных**<br><br>  В нашей структуре есть три уровня иерархии: 1. **Корневой узел** — сущность **Каталог** 2. **Внешние узлы** представляют собой категории (`section`): - `1` — Видеоконтент - `2` — Аудиоконтент - `3` — Ключи активации - `4` — Электронные книги - `5` — Аудиокниги - `6` — Цифровые товары - `8` — Услуги - `12` — Купоны и развлечения - `13` — Подарочные сертификаты 3. **Листья дерева** являются подкатегориями (`catalog_path`): - `65` — Обучающие видео - `66` — Спорт - `67` — Мастер-класс - `68` — Йога - `69` — Медитации  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_catalog_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFullCatalogResponse",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_catalog_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[GetFullCatalogResponse]:
        """Получить категории и их подкатегории

        Метод позволяет получить дерево (структуру данных) с категориям и их подкатегориями.<br><br>  **Иерархия структуры данных**<br><br>  В нашей структуре есть три уровня иерархии: 1. **Корневой узел** — сущность **Каталог** 2. **Внешние узлы** представляют собой категории (`section`): - `1` — Видеоконтент - `2` — Аудиоконтент - `3` — Ключи активации - `4` — Электронные книги - `5` — Аудиокниги - `6` — Цифровые товары - `8` — Услуги - `12` — Купоны и развлечения - `13` — Подарочные сертификаты 3. **Листья дерева** являются подкатегориями (`catalog_path`): - `65` — Обучающие видео - `66` — Спорт - `67` — Мастер-класс - `68` — Йога - `69` — Медитации  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_catalog_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFullCatalogResponse",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_catalog_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Получить категории и их подкатегории

        Метод позволяет получить дерево (структуру данных) с категориям и их подкатегориями.<br><br>  **Иерархия структуры данных**<br><br>  В нашей структуре есть три уровня иерархии: 1. **Корневой узел** — сущность **Каталог** 2. **Внешние узлы** представляют собой категории (`section`): - `1` — Видеоконтент - `2` — Аудиоконтент - `3` — Ключи активации - `4` — Электронные книги - `5` — Аудиокниги - `6` — Цифровые товары - `8` — Услуги - `12` — Купоны и развлечения - `13` — Подарочные сертификаты 3. **Листья дерева** являются подкатегориями (`catalog_path`): - `65` — Обучающие видео - `66` — Спорт - `67` — Мастер-класс - `68` — Йога - `69` — Медитации  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_catalog_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFullCatalogResponse",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_catalog_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/catalog',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_redeemed_keys(
        self,
        offer_id: Annotated[Optional[StrictInt], Field(description="Фильтрация по ID предложения. Позволяет выбрать ключи, связанные с определенным предложением")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе. Используется для пагинации")] = None,
        take: Annotated[Optional[StrictInt], Field(description="Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе")] = None,
        date_from: Annotated[Optional[StrictStr], Field(description="Фильтрация по дате покупки начиная с указанной даты (включительно).<br><br>  Формат даты: **RFC3339** (`2023-06-17T19:20:30Z`) ")] = None,
        date_to: Annotated[Optional[StrictStr], Field(description="Фильтрация по дате покупки до указанной даты (не включительно).  Формат даты: **RFC3339** (`2024-10-18T19:20:30Z`) ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> KeysRedeemedResponseList:
        """Получить купленные ключи

        Метод позволяет получить список купленных ключей с использованием фильтрации.<br><br>  **Описание параметров фильтрации**  - `offer_id` — Фильтрация по ID предложения. Позволяет выбрать ключи, связанные с определенным предложением. - `skip` — Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе.<br> **Например**, если `skip` равно 20, то выборка начнется с 21 записи. - `take` — Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе.<br> **Например**, если `take` равно 10, то в ответе будет не более 10 записей. - `date_from` — Фильтрация по дате покупки начиная с указанной даты (включительно).<br> Формат даты: **RFC3339**. - `date_to` — Фильтрация по дате покупки до указанной даты (не включительно).<br> Формат даты: **RFC3339**.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param offer_id: Фильтрация по ID предложения. Позволяет выбрать ключи, связанные с определенным предложением
        :type offer_id: int
        :param skip: Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе. Используется для пагинации
        :type skip: int
        :param take: Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе
        :type take: int
        :param date_from: Фильтрация по дате покупки начиная с указанной даты (включительно).<br><br>  Формат даты: **RFC3339** (`2023-06-17T19:20:30Z`) 
        :type date_from: str
        :param date_to: Фильтрация по дате покупки до указанной даты (не включительно).  Формат даты: **RFC3339** (`2024-10-18T19:20:30Z`) 
        :type date_to: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_redeemed_keys_serialize(
            offer_id=offer_id,
            skip=skip,
            take=take,
            date_from=date_from,
            date_to=date_to,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KeysRedeemedResponseList",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_redeemed_keys_with_http_info(
        self,
        offer_id: Annotated[Optional[StrictInt], Field(description="Фильтрация по ID предложения. Позволяет выбрать ключи, связанные с определенным предложением")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе. Используется для пагинации")] = None,
        take: Annotated[Optional[StrictInt], Field(description="Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе")] = None,
        date_from: Annotated[Optional[StrictStr], Field(description="Фильтрация по дате покупки начиная с указанной даты (включительно).<br><br>  Формат даты: **RFC3339** (`2023-06-17T19:20:30Z`) ")] = None,
        date_to: Annotated[Optional[StrictStr], Field(description="Фильтрация по дате покупки до указанной даты (не включительно).  Формат даты: **RFC3339** (`2024-10-18T19:20:30Z`) ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[KeysRedeemedResponseList]:
        """Получить купленные ключи

        Метод позволяет получить список купленных ключей с использованием фильтрации.<br><br>  **Описание параметров фильтрации**  - `offer_id` — Фильтрация по ID предложения. Позволяет выбрать ключи, связанные с определенным предложением. - `skip` — Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе.<br> **Например**, если `skip` равно 20, то выборка начнется с 21 записи. - `take` — Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе.<br> **Например**, если `take` равно 10, то в ответе будет не более 10 записей. - `date_from` — Фильтрация по дате покупки начиная с указанной даты (включительно).<br> Формат даты: **RFC3339**. - `date_to` — Фильтрация по дате покупки до указанной даты (не включительно).<br> Формат даты: **RFC3339**.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param offer_id: Фильтрация по ID предложения. Позволяет выбрать ключи, связанные с определенным предложением
        :type offer_id: int
        :param skip: Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе. Используется для пагинации
        :type skip: int
        :param take: Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе
        :type take: int
        :param date_from: Фильтрация по дате покупки начиная с указанной даты (включительно).<br><br>  Формат даты: **RFC3339** (`2023-06-17T19:20:30Z`) 
        :type date_from: str
        :param date_to: Фильтрация по дате покупки до указанной даты (не включительно).  Формат даты: **RFC3339** (`2024-10-18T19:20:30Z`) 
        :type date_to: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_redeemed_keys_serialize(
            offer_id=offer_id,
            skip=skip,
            take=take,
            date_from=date_from,
            date_to=date_to,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KeysRedeemedResponseList",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_redeemed_keys_without_preload_content(
        self,
        offer_id: Annotated[Optional[StrictInt], Field(description="Фильтрация по ID предложения. Позволяет выбрать ключи, связанные с определенным предложением")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе. Используется для пагинации")] = None,
        take: Annotated[Optional[StrictInt], Field(description="Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе")] = None,
        date_from: Annotated[Optional[StrictStr], Field(description="Фильтрация по дате покупки начиная с указанной даты (включительно).<br><br>  Формат даты: **RFC3339** (`2023-06-17T19:20:30Z`) ")] = None,
        date_to: Annotated[Optional[StrictStr], Field(description="Фильтрация по дате покупки до указанной даты (не включительно).  Формат даты: **RFC3339** (`2024-10-18T19:20:30Z`) ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Получить купленные ключи

        Метод позволяет получить список купленных ключей с использованием фильтрации.<br><br>  **Описание параметров фильтрации**  - `offer_id` — Фильтрация по ID предложения. Позволяет выбрать ключи, связанные с определенным предложением. - `skip` — Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе.<br> **Например**, если `skip` равно 20, то выборка начнется с 21 записи. - `take` — Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе.<br> **Например**, если `take` равно 10, то в ответе будет не более 10 записей. - `date_from` — Фильтрация по дате покупки начиная с указанной даты (включительно).<br> Формат даты: **RFC3339**. - `date_to` — Фильтрация по дате покупки до указанной даты (не включительно).<br> Формат даты: **RFC3339**.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param offer_id: Фильтрация по ID предложения. Позволяет выбрать ключи, связанные с определенным предложением
        :type offer_id: int
        :param skip: Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе. Используется для пагинации
        :type skip: int
        :param take: Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе
        :type take: int
        :param date_from: Фильтрация по дате покупки начиная с указанной даты (включительно).<br><br>  Формат даты: **RFC3339** (`2023-06-17T19:20:30Z`) 
        :type date_from: str
        :param date_to: Фильтрация по дате покупки до указанной даты (не включительно).  Формат даты: **RFC3339** (`2024-10-18T19:20:30Z`) 
        :type date_to: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_redeemed_keys_serialize(
            offer_id=offer_id,
            skip=skip,
            take=take,
            date_from=date_from,
            date_to=date_to,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KeysRedeemedResponseList",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_redeemed_keys_serialize(
        self,
        offer_id,
        skip,
        take,
        date_from,
        date_to,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if offer_id is not None:
            
            _query_params.append(('offer_id', offer_id))
            
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if take is not None:
            
            _query_params.append(('take', take))
            
        if date_from is not None:
            
            _query_params.append(('date_from', date_from))
            
        if date_to is not None:
            
            _query_params.append(('date_to', date_to))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/keys-api/keys/redeemed',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def load_keys(
        self,
        keys_load_request: KeysLoadRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """Добавить ключи активации

        Метод позволяет добавить ключи для предложения по ID.  <div class=\"description_important\">   Предложение должно быть из категории (<code>section</code>):   <ul>       <li>Ключи активации — <code>3</code></li>       <li>Купоны и развлечения — <code>12</code></li>       <li>Подарочные сертификаты — <code>13</code></li>   </ul> </div>  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param keys_load_request: (required)
        :type keys_load_request: KeysLoadRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._load_keys_serialize(
            keys_load_request=keys_load_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ProblemDetails401",
            '403': "ProblemDetails403",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def load_keys_with_http_info(
        self,
        keys_load_request: KeysLoadRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """Добавить ключи активации

        Метод позволяет добавить ключи для предложения по ID.  <div class=\"description_important\">   Предложение должно быть из категории (<code>section</code>):   <ul>       <li>Ключи активации — <code>3</code></li>       <li>Купоны и развлечения — <code>12</code></li>       <li>Подарочные сертификаты — <code>13</code></li>   </ul> </div>  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param keys_load_request: (required)
        :type keys_load_request: KeysLoadRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._load_keys_serialize(
            keys_load_request=keys_load_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ProblemDetails401",
            '403': "ProblemDetails403",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def load_keys_without_preload_content(
        self,
        keys_load_request: KeysLoadRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Добавить ключи активации

        Метод позволяет добавить ключи для предложения по ID.  <div class=\"description_important\">   Предложение должно быть из категории (<code>section</code>):   <ul>       <li>Ключи активации — <code>3</code></li>       <li>Купоны и развлечения — <code>12</code></li>       <li>Подарочные сертификаты — <code>13</code></li>   </ul> </div>  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param keys_load_request: (required)
        :type keys_load_request: KeysLoadRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._load_keys_serialize(
            keys_load_request=keys_load_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ProblemDetails401",
            '403': "ProblemDetails403",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _load_keys_serialize(
        self,
        keys_load_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if keys_load_request is not None:
            _body_params = keys_load_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/keys-api/keys',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def offer_create(
        self,
        offer_create_request: OfferCreateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> OfferResponse:
        """Создать новое предложение

        Метод позволяет создать новое предложение.<br><br>  **Обязательные поля** - `title` — Название предложения - `description` — Описание предложения - `tags` — Теги предложения - `section` — Категория предложения - `catalog_path` — Подкатегория предложения - `age_rating` — Возрастное ограничение предложения - `price` — Цена предложения  **Добавить обложку**<br><br>  Обложка для предложения загружается **отдельно после создания предложения**.<br> Вам необходимо воспользоваться методом [Добавить или обновить обложку предложения](/openapi/wbd#tag/Predlozheniya/operation/offersUploadThumbnail).<br><br>  **Добавить дополнительные медиафайлы**  1. Загрузить медиафайлы с помощью метода [Загрузить медиафайл для предложения](/openapi/wbd#tag/Kontent/operation/contentGallery), метод возвращает список URI адресов загруженных медиафайлов. 2. Добавить URI медиафайлов в поле `gallery`.  **Категория и подкатегория предложения**<br><br>  Воспользуйтесь методом [Получить категории и их подкатегории](/openapi/wbd#tag/Predlozheniya/operation/GetCatalog) для получения ID подкатегории и правильного сопоставления с категорией.<br><br>  **Предложение из категории \"Услуги\"**<br><br>  `section` — `8`<br><br>  Доступ к публикации контента этой категории предоставляется через заявку в <a href=\"https://digital.wildberries.ru/support\" target=\"_blank\">техническую поддержку</a>.<br><br>  **Предложение c уникальными ключами**<br><br>  Предложение c уникальными ключами относятся к категориям (`section`): - **Ключи активации** — `3` - **Купоны и развлечения** — `12` - **Подарочные сертификаты** — `13`  Обязательные данные: - Ключи к предложению - Инструкция по активации ключа  **Загрузка ключей**<br><br> Список ключей передается в параметре `keys` вашего запроса при создании предложения.<br> В дальнейшем вы можете добавлять ключи с помощью метода [Добавить ключи активации](/openapi/wbd#tag/Klyuchi-aktivacii/operation/LoadKeys).<br><br>  **Добавление инструкции по активации ключа**<br><br>  Инструкцию по активации ключа необходимо добавить в поле `meta` в формате **JSON** используя следующий пример.<br> Чтобы сделать текст более привлекательным и удобочитаемым, **используйте перенос строки** `\\n`.<br><br>  **Пример:**  ```json {     \"meta\":{         \"key_instruction\": \"Инструкция по активации\\n1. Зайдите на сайт ...\\n2.Вставьте ключ в поле ...\"     } } ```  **Предложение с контентом**<br><br>  Предложение с контентом относится к категориям (`section`): - **Видеоконтент** — `1` - **Аудиоконтент** — `2` - **Электронные книги** — `4` - **Аудиокниги** — `5` - **Цифровые товары** — `6`  Обязательные данные: - Контент для предложения  **Добавление контента**<br><br>  Если вы ещё не добавили контент в личный кабинет продавца, то вы можете это сделать по [инструкции](/openapi/wbd#tag/Kontent/Kak-dobavit-novyj-kontent).<br><br>  Для добавления контента вам необходимо передать в параметре `content` список данных используя пример ниже.<br><br>  **Пример:**  ```json \"content\": [     {         \"category_id\": 1,         \"content\": 8942     },     {         \"category_id\": 1,         \"content\": 4211     } ] ```  где: - `category_id` — ID категории контента - `content` — ID контента  Эту информацию вы можете получить с помощью метод [Получить список своего контента](/openapi/wbd#tag/Kontent/operation/contentAuthorGet).  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param offer_create_request: (required)
        :type offer_create_request: OfferCreateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_create_serialize(
            offer_create_request=offer_create_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def offer_create_with_http_info(
        self,
        offer_create_request: OfferCreateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[OfferResponse]:
        """Создать новое предложение

        Метод позволяет создать новое предложение.<br><br>  **Обязательные поля** - `title` — Название предложения - `description` — Описание предложения - `tags` — Теги предложения - `section` — Категория предложения - `catalog_path` — Подкатегория предложения - `age_rating` — Возрастное ограничение предложения - `price` — Цена предложения  **Добавить обложку**<br><br>  Обложка для предложения загружается **отдельно после создания предложения**.<br> Вам необходимо воспользоваться методом [Добавить или обновить обложку предложения](/openapi/wbd#tag/Predlozheniya/operation/offersUploadThumbnail).<br><br>  **Добавить дополнительные медиафайлы**  1. Загрузить медиафайлы с помощью метода [Загрузить медиафайл для предложения](/openapi/wbd#tag/Kontent/operation/contentGallery), метод возвращает список URI адресов загруженных медиафайлов. 2. Добавить URI медиафайлов в поле `gallery`.  **Категория и подкатегория предложения**<br><br>  Воспользуйтесь методом [Получить категории и их подкатегории](/openapi/wbd#tag/Predlozheniya/operation/GetCatalog) для получения ID подкатегории и правильного сопоставления с категорией.<br><br>  **Предложение из категории \"Услуги\"**<br><br>  `section` — `8`<br><br>  Доступ к публикации контента этой категории предоставляется через заявку в <a href=\"https://digital.wildberries.ru/support\" target=\"_blank\">техническую поддержку</a>.<br><br>  **Предложение c уникальными ключами**<br><br>  Предложение c уникальными ключами относятся к категориям (`section`): - **Ключи активации** — `3` - **Купоны и развлечения** — `12` - **Подарочные сертификаты** — `13`  Обязательные данные: - Ключи к предложению - Инструкция по активации ключа  **Загрузка ключей**<br><br> Список ключей передается в параметре `keys` вашего запроса при создании предложения.<br> В дальнейшем вы можете добавлять ключи с помощью метода [Добавить ключи активации](/openapi/wbd#tag/Klyuchi-aktivacii/operation/LoadKeys).<br><br>  **Добавление инструкции по активации ключа**<br><br>  Инструкцию по активации ключа необходимо добавить в поле `meta` в формате **JSON** используя следующий пример.<br> Чтобы сделать текст более привлекательным и удобочитаемым, **используйте перенос строки** `\\n`.<br><br>  **Пример:**  ```json {     \"meta\":{         \"key_instruction\": \"Инструкция по активации\\n1. Зайдите на сайт ...\\n2.Вставьте ключ в поле ...\"     } } ```  **Предложение с контентом**<br><br>  Предложение с контентом относится к категориям (`section`): - **Видеоконтент** — `1` - **Аудиоконтент** — `2` - **Электронные книги** — `4` - **Аудиокниги** — `5` - **Цифровые товары** — `6`  Обязательные данные: - Контент для предложения  **Добавление контента**<br><br>  Если вы ещё не добавили контент в личный кабинет продавца, то вы можете это сделать по [инструкции](/openapi/wbd#tag/Kontent/Kak-dobavit-novyj-kontent).<br><br>  Для добавления контента вам необходимо передать в параметре `content` список данных используя пример ниже.<br><br>  **Пример:**  ```json \"content\": [     {         \"category_id\": 1,         \"content\": 8942     },     {         \"category_id\": 1,         \"content\": 4211     } ] ```  где: - `category_id` — ID категории контента - `content` — ID контента  Эту информацию вы можете получить с помощью метод [Получить список своего контента](/openapi/wbd#tag/Kontent/operation/contentAuthorGet).  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param offer_create_request: (required)
        :type offer_create_request: OfferCreateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_create_serialize(
            offer_create_request=offer_create_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def offer_create_without_preload_content(
        self,
        offer_create_request: OfferCreateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Создать новое предложение

        Метод позволяет создать новое предложение.<br><br>  **Обязательные поля** - `title` — Название предложения - `description` — Описание предложения - `tags` — Теги предложения - `section` — Категория предложения - `catalog_path` — Подкатегория предложения - `age_rating` — Возрастное ограничение предложения - `price` — Цена предложения  **Добавить обложку**<br><br>  Обложка для предложения загружается **отдельно после создания предложения**.<br> Вам необходимо воспользоваться методом [Добавить или обновить обложку предложения](/openapi/wbd#tag/Predlozheniya/operation/offersUploadThumbnail).<br><br>  **Добавить дополнительные медиафайлы**  1. Загрузить медиафайлы с помощью метода [Загрузить медиафайл для предложения](/openapi/wbd#tag/Kontent/operation/contentGallery), метод возвращает список URI адресов загруженных медиафайлов. 2. Добавить URI медиафайлов в поле `gallery`.  **Категория и подкатегория предложения**<br><br>  Воспользуйтесь методом [Получить категории и их подкатегории](/openapi/wbd#tag/Predlozheniya/operation/GetCatalog) для получения ID подкатегории и правильного сопоставления с категорией.<br><br>  **Предложение из категории \"Услуги\"**<br><br>  `section` — `8`<br><br>  Доступ к публикации контента этой категории предоставляется через заявку в <a href=\"https://digital.wildberries.ru/support\" target=\"_blank\">техническую поддержку</a>.<br><br>  **Предложение c уникальными ключами**<br><br>  Предложение c уникальными ключами относятся к категориям (`section`): - **Ключи активации** — `3` - **Купоны и развлечения** — `12` - **Подарочные сертификаты** — `13`  Обязательные данные: - Ключи к предложению - Инструкция по активации ключа  **Загрузка ключей**<br><br> Список ключей передается в параметре `keys` вашего запроса при создании предложения.<br> В дальнейшем вы можете добавлять ключи с помощью метода [Добавить ключи активации](/openapi/wbd#tag/Klyuchi-aktivacii/operation/LoadKeys).<br><br>  **Добавление инструкции по активации ключа**<br><br>  Инструкцию по активации ключа необходимо добавить в поле `meta` в формате **JSON** используя следующий пример.<br> Чтобы сделать текст более привлекательным и удобочитаемым, **используйте перенос строки** `\\n`.<br><br>  **Пример:**  ```json {     \"meta\":{         \"key_instruction\": \"Инструкция по активации\\n1. Зайдите на сайт ...\\n2.Вставьте ключ в поле ...\"     } } ```  **Предложение с контентом**<br><br>  Предложение с контентом относится к категориям (`section`): - **Видеоконтент** — `1` - **Аудиоконтент** — `2` - **Электронные книги** — `4` - **Аудиокниги** — `5` - **Цифровые товары** — `6`  Обязательные данные: - Контент для предложения  **Добавление контента**<br><br>  Если вы ещё не добавили контент в личный кабинет продавца, то вы можете это сделать по [инструкции](/openapi/wbd#tag/Kontent/Kak-dobavit-novyj-kontent).<br><br>  Для добавления контента вам необходимо передать в параметре `content` список данных используя пример ниже.<br><br>  **Пример:**  ```json \"content\": [     {         \"category_id\": 1,         \"content\": 8942     },     {         \"category_id\": 1,         \"content\": 4211     } ] ```  где: - `category_id` — ID категории контента - `content` — ID контента  Эту информацию вы можете получить с помощью метод [Получить список своего контента](/openapi/wbd#tag/Kontent/operation/contentAuthorGet).  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param offer_create_request: (required)
        :type offer_create_request: OfferCreateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_create_serialize(
            offer_create_request=offer_create_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _offer_create_serialize(
        self,
        offer_create_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if offer_create_request is not None:
            _body_params = offer_create_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/offers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def offer_get(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> OfferResponse:
        """Получить информацию о предложении

        Метод позволяет получить информацию о конкретном предложении.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_get_serialize(
            offer_id=offer_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def offer_get_with_http_info(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[OfferResponse]:
        """Получить информацию о предложении

        Метод позволяет получить информацию о конкретном предложении.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_get_serialize(
            offer_id=offer_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def offer_get_without_preload_content(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Получить информацию о предложении

        Метод позволяет получить информацию о конкретном предложении.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_get_serialize(
            offer_id=offer_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferResponse",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _offer_get_serialize(
        self,
        offer_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if offer_id is not None:
            _path_params['offer_id'] = offer_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/offers/{offer_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def offer_keys_count_get(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> KeysCountResponse:
        """Получить количество ключей для предложения

        Метод позволяет получить информацию о количестве ключей у конкретного предложения.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_keys_count_get_serialize(
            offer_id=offer_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KeysCountResponse",
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def offer_keys_count_get_with_http_info(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[KeysCountResponse]:
        """Получить количество ключей для предложения

        Метод позволяет получить информацию о количестве ключей у конкретного предложения.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_keys_count_get_serialize(
            offer_id=offer_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KeysCountResponse",
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def offer_keys_count_get_without_preload_content(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Получить количество ключей для предложения

        Метод позволяет получить информацию о количестве ключей у конкретного предложения.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_keys_count_get_serialize(
            offer_id=offer_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KeysCountResponse",
            '401': "ProblemDetails401",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _offer_keys_count_get_serialize(
        self,
        offer_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if offer_id is not None:
            _path_params['offer_id'] = offer_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/offer/keys/{offer_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def offer_keys_get(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        take: Annotated[Optional[StrictInt], Field(description="Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе. Используется для пагинации")] = None,
        deleted: Annotated[Optional[StrictBool], Field(description="Указывает, будут ли в ответе присутствовать удалённые ключи")] = None,
        sold: Annotated[Optional[StrictBool], Field(description="Указывает, будут ли в ответе присутствовать проданные ключи")] = None,
        reserved: Annotated[Optional[StrictBool], Field(description="Указывает, будут ли в ответе присутствовать зарезервированные ключи")] = None,
        expired: Annotated[Optional[StrictBool], Field(description="Указывает, будут ли в ответе присутствовать ключи с истекшим сроком действия")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> KeysResponseList:
        """Получить список ключей

        Метод позволяет получить список загруженных вами ключей для конкретного предложения.  <div class=\"description_important\">   Доступ к методу предоставляется через заявку в <a href=\"https://digital.wildberries.ru/support\" target=\"_black\">техническую поддержку</a>. </div>  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param take: Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе
        :type take: int
        :param skip: Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе. Используется для пагинации
        :type skip: int
        :param deleted: Указывает, будут ли в ответе присутствовать удалённые ключи
        :type deleted: bool
        :param sold: Указывает, будут ли в ответе присутствовать проданные ключи
        :type sold: bool
        :param reserved: Указывает, будут ли в ответе присутствовать зарезервированные ключи
        :type reserved: bool
        :param expired: Указывает, будут ли в ответе присутствовать ключи с истекшим сроком действия
        :type expired: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_keys_get_serialize(
            offer_id=offer_id,
            take=take,
            skip=skip,
            deleted=deleted,
            sold=sold,
            reserved=reserved,
            expired=expired,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KeysResponseList",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '403': "ProblemDetails403",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def offer_keys_get_with_http_info(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        take: Annotated[Optional[StrictInt], Field(description="Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе. Используется для пагинации")] = None,
        deleted: Annotated[Optional[StrictBool], Field(description="Указывает, будут ли в ответе присутствовать удалённые ключи")] = None,
        sold: Annotated[Optional[StrictBool], Field(description="Указывает, будут ли в ответе присутствовать проданные ключи")] = None,
        reserved: Annotated[Optional[StrictBool], Field(description="Указывает, будут ли в ответе присутствовать зарезервированные ключи")] = None,
        expired: Annotated[Optional[StrictBool], Field(description="Указывает, будут ли в ответе присутствовать ключи с истекшим сроком действия")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[KeysResponseList]:
        """Получить список ключей

        Метод позволяет получить список загруженных вами ключей для конкретного предложения.  <div class=\"description_important\">   Доступ к методу предоставляется через заявку в <a href=\"https://digital.wildberries.ru/support\" target=\"_black\">техническую поддержку</a>. </div>  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param take: Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе
        :type take: int
        :param skip: Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе. Используется для пагинации
        :type skip: int
        :param deleted: Указывает, будут ли в ответе присутствовать удалённые ключи
        :type deleted: bool
        :param sold: Указывает, будут ли в ответе присутствовать проданные ключи
        :type sold: bool
        :param reserved: Указывает, будут ли в ответе присутствовать зарезервированные ключи
        :type reserved: bool
        :param expired: Указывает, будут ли в ответе присутствовать ключи с истекшим сроком действия
        :type expired: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_keys_get_serialize(
            offer_id=offer_id,
            take=take,
            skip=skip,
            deleted=deleted,
            sold=sold,
            reserved=reserved,
            expired=expired,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KeysResponseList",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '403': "ProblemDetails403",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def offer_keys_get_without_preload_content(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        take: Annotated[Optional[StrictInt], Field(description="Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе. Используется для пагинации")] = None,
        deleted: Annotated[Optional[StrictBool], Field(description="Указывает, будут ли в ответе присутствовать удалённые ключи")] = None,
        sold: Annotated[Optional[StrictBool], Field(description="Указывает, будут ли в ответе присутствовать проданные ключи")] = None,
        reserved: Annotated[Optional[StrictBool], Field(description="Указывает, будут ли в ответе присутствовать зарезервированные ключи")] = None,
        expired: Annotated[Optional[StrictBool], Field(description="Указывает, будут ли в ответе присутствовать ключи с истекшим сроком действия")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Получить список ключей

        Метод позволяет получить список загруженных вами ключей для конкретного предложения.  <div class=\"description_important\">   Доступ к методу предоставляется через заявку в <a href=\"https://digital.wildberries.ru/support\" target=\"_black\">техническую поддержку</a>. </div>  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param take: Количество записей для получения. Указывает, сколько ключей должно быть возвращено в ответе
        :type take: int
        :param skip: Смещение. Указывает, сколько записей нужно пропустить в результирующем наборе. Используется для пагинации
        :type skip: int
        :param deleted: Указывает, будут ли в ответе присутствовать удалённые ключи
        :type deleted: bool
        :param sold: Указывает, будут ли в ответе присутствовать проданные ключи
        :type sold: bool
        :param reserved: Указывает, будут ли в ответе присутствовать зарезервированные ключи
        :type reserved: bool
        :param expired: Указывает, будут ли в ответе присутствовать ключи с истекшим сроком действия
        :type expired: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_keys_get_serialize(
            offer_id=offer_id,
            take=take,
            skip=skip,
            deleted=deleted,
            sold=sold,
            reserved=reserved,
            expired=expired,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KeysResponseList",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '403': "ProblemDetails403",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _offer_keys_get_serialize(
        self,
        offer_id,
        take,
        skip,
        deleted,
        sold,
        reserved,
        expired,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if offer_id is not None:
            _path_params['offer_id'] = offer_id
        # process the query parameters
        if take is not None:
            
            _query_params.append(('take', take))
            
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if deleted is not None:
            
            _query_params.append(('deleted', deleted))
            
        if sold is not None:
            
            _query_params.append(('sold', sold))
            
        if reserved is not None:
            
            _query_params.append(('reserved', reserved))
            
        if expired is not None:
            
            _query_params.append(('expired', expired))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/offer/keys/{offer_id}/list',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def offer_update(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        offer_update_request: OfferUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """Редактировать предложение

        Метод позволяет редактировать информацию о предложении.<br><br>  **Категория и подкатегория предложения**<br><br>  Воспользуйтесь методом [Получить категории и их подкатегории](/openapi/wbd#tag/Predlozheniya/operation/GetCatalog) для получения ID подкатегории и правильного сопоставления с категорией.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param offer_update_request: (required)
        :type offer_update_request: OfferUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_update_serialize(
            offer_id=offer_id,
            offer_update_request=offer_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '403': "ProblemDetails403",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def offer_update_with_http_info(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        offer_update_request: OfferUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """Редактировать предложение

        Метод позволяет редактировать информацию о предложении.<br><br>  **Категория и подкатегория предложения**<br><br>  Воспользуйтесь методом [Получить категории и их подкатегории](/openapi/wbd#tag/Predlozheniya/operation/GetCatalog) для получения ID подкатегории и правильного сопоставления с категорией.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param offer_update_request: (required)
        :type offer_update_request: OfferUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_update_serialize(
            offer_id=offer_id,
            offer_update_request=offer_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '403': "ProblemDetails403",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def offer_update_without_preload_content(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        offer_update_request: OfferUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Редактировать предложение

        Метод позволяет редактировать информацию о предложении.<br><br>  **Категория и подкатегория предложения**<br><br>  Воспользуйтесь методом [Получить категории и их подкатегории](/openapi/wbd#tag/Predlozheniya/operation/GetCatalog) для получения ID подкатегории и правильного сопоставления с категорией.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param offer_update_request: (required)
        :type offer_update_request: OfferUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_update_serialize(
            offer_id=offer_id,
            offer_update_request=offer_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '403': "ProblemDetails403",
            '404': "ProblemDetails404",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _offer_update_serialize(
        self,
        offer_id,
        offer_update_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if offer_id is not None:
            _path_params['offer_id'] = offer_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if offer_update_request is not None:
            _body_params = offer_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/offers/{offer_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def offer_update_price(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        offer_price_update_request: OfferPriceUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """Обновить цену

        Метод позволяет изменить цену предложения и цену с учетом скидок.<br><br>  Если вы не хотите выставлять скидку, то в запросе необходимо **не передавать** параметр `discount_price` или выставить у него значение `0`.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param offer_price_update_request: (required)
        :type offer_price_update_request: OfferPriceUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_update_price_serialize(
            offer_id=offer_id,
            offer_price_update_request=offer_price_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def offer_update_price_with_http_info(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        offer_price_update_request: OfferPriceUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """Обновить цену

        Метод позволяет изменить цену предложения и цену с учетом скидок.<br><br>  Если вы не хотите выставлять скидку, то в запросе необходимо **не передавать** параметр `discount_price` или выставить у него значение `0`.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param offer_price_update_request: (required)
        :type offer_price_update_request: OfferPriceUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_update_price_serialize(
            offer_id=offer_id,
            offer_price_update_request=offer_price_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def offer_update_price_without_preload_content(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        offer_price_update_request: OfferPriceUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Обновить цену

        Метод позволяет изменить цену предложения и цену с учетом скидок.<br><br>  Если вы не хотите выставлять скидку, то в запросе необходимо **не передавать** параметр `discount_price` или выставить у него значение `0`.  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param offer_price_update_request: (required)
        :type offer_price_update_request: OfferPriceUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_update_price_serialize(
            offer_id=offer_id,
            offer_price_update_request=offer_price_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _offer_update_price_serialize(
        self,
        offer_id,
        offer_price_update_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if offer_id is not None:
            _path_params['offer_id'] = offer_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if offer_price_update_request is not None:
            _body_params = offer_price_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/offer/price/{offer_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def offer_update_status(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        offer_status_update_request: OfferStatusUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """Обновить статус

        Метод позволяет обновить статус вашего предложения.<br><br>  Возможные значения: - `0` — Черновик - `1` — Опубликован - `2` — Приостановлен - `3` — Удалён  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param offer_status_update_request: (required)
        :type offer_status_update_request: OfferStatusUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_update_status_serialize(
            offer_id=offer_id,
            offer_status_update_request=offer_status_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def offer_update_status_with_http_info(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        offer_status_update_request: OfferStatusUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """Обновить статус

        Метод позволяет обновить статус вашего предложения.<br><br>  Возможные значения: - `0` — Черновик - `1` — Опубликован - `2` — Приостановлен - `3` — Удалён  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param offer_status_update_request: (required)
        :type offer_status_update_request: OfferStatusUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_update_status_serialize(
            offer_id=offer_id,
            offer_status_update_request=offer_status_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def offer_update_status_without_preload_content(
        self,
        offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        offer_status_update_request: OfferStatusUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Обновить статус

        Метод позволяет обновить статус вашего предложения.<br><br>  Возможные значения: - `0` — Черновик - `1` — Опубликован - `2` — Приостановлен - `3` — Удалён  <div class=\"description_limit\">   Максимум 50 запросов в секунду </div> 

        :param offer_id: ID предложения (required)
        :type offer_id: int
        :param offer_status_update_request: (required)
        :type offer_status_update_request: OfferStatusUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offer_update_status_serialize(
            offer_id=offer_id,
            offer_status_update_request=offer_status_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _offer_update_status_serialize(
        self,
        offer_id,
        offer_status_update_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if offer_id is not None:
            _path_params['offer_id'] = offer_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if offer_status_update_request is not None:
            _body_params = offer_status_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/offer/{offer_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def offers_author_get(
        self,
        search: Annotated[Optional[StrictStr], Field(description="Поиск по названию предложения")] = None,
        category: Annotated[Optional[StrictInt], Field(description="Фильтрация по категории контента: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ ")] = None,
        status: Annotated[Optional[StrictInt], Field(description="Фильтрация по статусу: - `0` — Черновик - `1` — Опубликован - `2` — Приостановлен ")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Сортировка предложений по дате создания или обновления")] = None,
        sort_dir: Annotated[Optional[StrictStr], Field(description="Направление сортировки: - `asc` — по возрастанию - `desc` — по убыванию ")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Смещение. Количество предложений, которые нужно пропустить в результирующем наборе")] = None,
        take: Annotated[Optional[StrictInt], Field(description="Количество предложений для получения")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> OfferResponseList:
        """Получить список своих предложений

        Метод позволяет получить список своих предложений с использованием фильтрации.<br><br>  **Описание параметров фильтрации**  - `search` — Поиск предложений по названию. Укажите часть или полное название предложения для поиска. - `category` — Фильтрация предложений по категории контента. Список категорий находится в [таблице](/openapi/wbd#tag/Kontent/Kategorii-kontenta). - `status` — Фильтрация предложений по статусу. Возможные значения:     - `0` — Черновик     - `1` — Опубликован     - `2` — Приостановлен - `sort` — Сортировка предложений по дате создания или обновления. Укажите `created` для сортировки по дате создания и `updated` для сортировки по дате обновления. - `sort_dir` — Направление сортировки. Укажите `asc` для сортировки по возрастанию или `desc` для сортировки по убыванию. - `skip` — Смещение. Позволяет пропустить определенное количество предложений в результирующем наборе.<br> **Например**, если `skip` равно 20, то выборка начнется с 21 записи. - `take` — Количество предложений, которое нужно вернуть в ответе.<br> **Например**, если `take` равно 10, то в ответе будет не более 10 записей.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param search: Поиск по названию предложения
        :type search: str
        :param category: Фильтрация по категории контента: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ 
        :type category: int
        :param status: Фильтрация по статусу: - `0` — Черновик - `1` — Опубликован - `2` — Приостановлен 
        :type status: int
        :param sort: Сортировка предложений по дате создания или обновления
        :type sort: str
        :param sort_dir: Направление сортировки: - `asc` — по возрастанию - `desc` — по убыванию 
        :type sort_dir: str
        :param skip: Смещение. Количество предложений, которые нужно пропустить в результирующем наборе
        :type skip: int
        :param take: Количество предложений для получения
        :type take: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offers_author_get_serialize(
            search=search,
            category=category,
            status=status,
            sort=sort,
            sort_dir=sort_dir,
            skip=skip,
            take=take,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferResponseList",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def offers_author_get_with_http_info(
        self,
        search: Annotated[Optional[StrictStr], Field(description="Поиск по названию предложения")] = None,
        category: Annotated[Optional[StrictInt], Field(description="Фильтрация по категории контента: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ ")] = None,
        status: Annotated[Optional[StrictInt], Field(description="Фильтрация по статусу: - `0` — Черновик - `1` — Опубликован - `2` — Приостановлен ")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Сортировка предложений по дате создания или обновления")] = None,
        sort_dir: Annotated[Optional[StrictStr], Field(description="Направление сортировки: - `asc` — по возрастанию - `desc` — по убыванию ")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Смещение. Количество предложений, которые нужно пропустить в результирующем наборе")] = None,
        take: Annotated[Optional[StrictInt], Field(description="Количество предложений для получения")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[OfferResponseList]:
        """Получить список своих предложений

        Метод позволяет получить список своих предложений с использованием фильтрации.<br><br>  **Описание параметров фильтрации**  - `search` — Поиск предложений по названию. Укажите часть или полное название предложения для поиска. - `category` — Фильтрация предложений по категории контента. Список категорий находится в [таблице](/openapi/wbd#tag/Kontent/Kategorii-kontenta). - `status` — Фильтрация предложений по статусу. Возможные значения:     - `0` — Черновик     - `1` — Опубликован     - `2` — Приостановлен - `sort` — Сортировка предложений по дате создания или обновления. Укажите `created` для сортировки по дате создания и `updated` для сортировки по дате обновления. - `sort_dir` — Направление сортировки. Укажите `asc` для сортировки по возрастанию или `desc` для сортировки по убыванию. - `skip` — Смещение. Позволяет пропустить определенное количество предложений в результирующем наборе.<br> **Например**, если `skip` равно 20, то выборка начнется с 21 записи. - `take` — Количество предложений, которое нужно вернуть в ответе.<br> **Например**, если `take` равно 10, то в ответе будет не более 10 записей.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param search: Поиск по названию предложения
        :type search: str
        :param category: Фильтрация по категории контента: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ 
        :type category: int
        :param status: Фильтрация по статусу: - `0` — Черновик - `1` — Опубликован - `2` — Приостановлен 
        :type status: int
        :param sort: Сортировка предложений по дате создания или обновления
        :type sort: str
        :param sort_dir: Направление сортировки: - `asc` — по возрастанию - `desc` — по убыванию 
        :type sort_dir: str
        :param skip: Смещение. Количество предложений, которые нужно пропустить в результирующем наборе
        :type skip: int
        :param take: Количество предложений для получения
        :type take: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offers_author_get_serialize(
            search=search,
            category=category,
            status=status,
            sort=sort,
            sort_dir=sort_dir,
            skip=skip,
            take=take,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferResponseList",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def offers_author_get_without_preload_content(
        self,
        search: Annotated[Optional[StrictStr], Field(description="Поиск по названию предложения")] = None,
        category: Annotated[Optional[StrictInt], Field(description="Фильтрация по категории контента: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ ")] = None,
        status: Annotated[Optional[StrictInt], Field(description="Фильтрация по статусу: - `0` — Черновик - `1` — Опубликован - `2` — Приостановлен ")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Сортировка предложений по дате создания или обновления")] = None,
        sort_dir: Annotated[Optional[StrictStr], Field(description="Направление сортировки: - `asc` — по возрастанию - `desc` — по убыванию ")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Смещение. Количество предложений, которые нужно пропустить в результирующем наборе")] = None,
        take: Annotated[Optional[StrictInt], Field(description="Количество предложений для получения")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Получить список своих предложений

        Метод позволяет получить список своих предложений с использованием фильтрации.<br><br>  **Описание параметров фильтрации**  - `search` — Поиск предложений по названию. Укажите часть или полное название предложения для поиска. - `category` — Фильтрация предложений по категории контента. Список категорий находится в [таблице](/openapi/wbd#tag/Kontent/Kategorii-kontenta). - `status` — Фильтрация предложений по статусу. Возможные значения:     - `0` — Черновик     - `1` — Опубликован     - `2` — Приостановлен - `sort` — Сортировка предложений по дате создания или обновления. Укажите `created` для сортировки по дате создания и `updated` для сортировки по дате обновления. - `sort_dir` — Направление сортировки. Укажите `asc` для сортировки по возрастанию или `desc` для сортировки по убыванию. - `skip` — Смещение. Позволяет пропустить определенное количество предложений в результирующем наборе.<br> **Например**, если `skip` равно 20, то выборка начнется с 21 записи. - `take` — Количество предложений, которое нужно вернуть в ответе.<br> **Например**, если `take` равно 10, то в ответе будет не более 10 записей.  <div class=\"description_limit\">   Максимум 100 запросов в секунду </div> 

        :param search: Поиск по названию предложения
        :type search: str
        :param category: Фильтрация по категории контента: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ 
        :type category: int
        :param status: Фильтрация по статусу: - `0` — Черновик - `1` — Опубликован - `2` — Приостановлен 
        :type status: int
        :param sort: Сортировка предложений по дате создания или обновления
        :type sort: str
        :param sort_dir: Направление сортировки: - `asc` — по возрастанию - `desc` — по убыванию 
        :type sort_dir: str
        :param skip: Смещение. Количество предложений, которые нужно пропустить в результирующем наборе
        :type skip: int
        :param take: Количество предложений для получения
        :type take: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offers_author_get_serialize(
            search=search,
            category=category,
            status=status,
            sort=sort,
            sort_dir=sort_dir,
            skip=skip,
            take=take,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferResponseList",
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _offers_author_get_serialize(
        self,
        search,
        category,
        status,
        sort,
        sort_dir,
        skip,
        take,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if search is not None:
            
            _query_params.append(('search', search))
            
        if category is not None:
            
            _query_params.append(('category', category))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if sort_dir is not None:
            
            _query_params.append(('sort_dir', sort_dir))
            
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if take is not None:
            
            _query_params.append(('take', take))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/offers/author',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def offers_upload_thumbnail(
        self,
        x_content_type: Annotated[StrictStr, Field(description="Тип изображения")],
        x_wbd_offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        body: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """Добавить или обновить обложку предложения

        Метод позволяет добавить или обновить обложку предложения.<br> Для добавления более привлекательной карточки предложения, мы рекомендуем:    1. Добавлять изображения с соотношением сторон 1:1.   2. Минимальный размер изображения 1200х1200 пикселей.   3. Фон контрастный белому.  <div class=\"description_important\">   Максимальный размер файла: 5 Мб<br>   Допустимые форматы: PNG, JPEG </div>  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param x_content_type: Тип изображения (required)
        :type x_content_type: str
        :param x_wbd_offer_id: ID предложения (required)
        :type x_wbd_offer_id: int
        :param body: (required)
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offers_upload_thumbnail_serialize(
            x_content_type=x_content_type,
            x_wbd_offer_id=x_wbd_offer_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def offers_upload_thumbnail_with_http_info(
        self,
        x_content_type: Annotated[StrictStr, Field(description="Тип изображения")],
        x_wbd_offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        body: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """Добавить или обновить обложку предложения

        Метод позволяет добавить или обновить обложку предложения.<br> Для добавления более привлекательной карточки предложения, мы рекомендуем:    1. Добавлять изображения с соотношением сторон 1:1.   2. Минимальный размер изображения 1200х1200 пикселей.   3. Фон контрастный белому.  <div class=\"description_important\">   Максимальный размер файла: 5 Мб<br>   Допустимые форматы: PNG, JPEG </div>  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param x_content_type: Тип изображения (required)
        :type x_content_type: str
        :param x_wbd_offer_id: ID предложения (required)
        :type x_wbd_offer_id: int
        :param body: (required)
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offers_upload_thumbnail_serialize(
            x_content_type=x_content_type,
            x_wbd_offer_id=x_wbd_offer_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def offers_upload_thumbnail_without_preload_content(
        self,
        x_content_type: Annotated[StrictStr, Field(description="Тип изображения")],
        x_wbd_offer_id: Annotated[StrictInt, Field(description="ID предложения")],
        body: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Добавить или обновить обложку предложения

        Метод позволяет добавить или обновить обложку предложения.<br> Для добавления более привлекательной карточки предложения, мы рекомендуем:    1. Добавлять изображения с соотношением сторон 1:1.   2. Минимальный размер изображения 1200х1200 пикселей.   3. Фон контрастный белому.  <div class=\"description_important\">   Максимальный размер файла: 5 Мб<br>   Допустимые форматы: PNG, JPEG </div>  <div class=\"description_limit\">   Максимум 10 запросов в секунду </div> 

        :param x_content_type: Тип изображения (required)
        :type x_content_type: str
        :param x_wbd_offer_id: ID предложения (required)
        :type x_wbd_offer_id: int
        :param body: (required)
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._offers_upload_thumbnail_serialize(
            x_content_type=x_content_type,
            x_wbd_offer_id=x_wbd_offer_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ProblemDetails400",
            '401': "ProblemDetails401",
            '500': "ProblemDetails500",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _offers_upload_thumbnail_serialize(
        self,
        x_content_type,
        x_wbd_offer_id,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://devapi-digital.wildberries.ru'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_content_type is not None:
            _header_params['X-Content-Type'] = x_content_type
        if x_wbd_offer_id is not None:
            _header_params['X-Wbd-OfferId'] = x_wbd_offer_id
        # process the form parameters
        # process the body parameter
        if body is not None:
            # convert to byte array if the input is a file name (str)
            if isinstance(body, str):
                with open(body, "rb") as _fp:
                    _body_params = _fp.read()
            elif isinstance(body, tuple):
                # drop the filename from the tuple
                _body_params = body[1]
            else:
                _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/octet-stream'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/offers/thumb',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


