# coding: utf-8

"""
    Wildberries Цифровой

    По вопросам работы с WBD API обращайтесь в <a href=\"https://digital.wildberries.ru/support\" target=\"_blank\">техническую поддержку</a> 

    The version of the OpenAPI document: wbd
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CatalogNode(BaseModel):
    """
    CatalogNode
    """ # noqa: E501
    children: Optional[List[CatalogNode]] = Field(default=None, description="Список дочерних узлов")
    img: Optional[StrictStr] = Field(default=None, description="URI адрес иконки категории ")
    name: Optional[StrictStr] = Field(default=None, description="Название узла")
    parent_id: Optional[StrictInt] = Field(default=None, description="Указывает на ID родителя подкатегории ")
    path: Optional[List[StrictInt]] = Field(default=None, description="Список `id` (ID узла). Путь до элемента каталога. ")
    id: Optional[StrictInt] = Field(default=None, description="ID узла.  Если `is_section` = `true`, то `id` является ID категории (`section`).  Если `is_section` = `false`, то `id` является ID подкатегории (`is_path`). ")
    is_section: Optional[StrictBool] = Field(default=None, description="Признак, является ли узел категорией (`section`)")
    node_order: Optional[StrictInt] = Field(default=None, description="Порядок элементов подкатегорий, которые находятся на одном уровне ")
    section_id: Optional[StrictInt] = Field(default=None, description="ID категории (`section`). Если `is_section` = `false`, то `section_id` указывает на родительскую категорию.")
    total: Optional[StrictInt] = Field(default=None, description="Общее количество предложений в этой категории. Поле заполняется только у категорий (`section`).")
    __properties: ClassVar[List[str]] = ["children", "img", "name", "parent_id", "path", "id", "is_section", "node_order", "section_id", "total"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CatalogNode from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in children (list)
        _items = []
        if self.children:
            for _item_children in self.children:
                if _item_children:
                    _items.append(_item_children.to_dict())
            _dict['children'] = _items
        # set to None if path (nullable) is None
        # and model_fields_set contains the field
        if self.path is None and "path" in self.model_fields_set:
            _dict['path'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CatalogNode from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "children": [CatalogNode.from_dict(_item) for _item in obj["children"]] if obj.get("children") is not None else None,
            "img": obj.get("img"),
            "name": obj.get("name"),
            "parent_id": obj.get("parent_id"),
            "path": obj.get("path"),
            "id": obj.get("id"),
            "is_section": obj.get("is_section"),
            "node_order": obj.get("node_order"),
            "section_id": obj.get("section_id"),
            "total": obj.get("total")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
CatalogNode.model_rebuild(raise_errors=False)

