# coding: utf-8

"""
    Wildberries Цифровой

    По вопросам работы с WBD API обращайтесь в <a href=\"https://digital.wildberries.ru/support\" target=\"_blank\">техническую поддержку</a> 

    The version of the OpenAPI document: wbd
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.wbd.models.content_files_inner import ContentFilesInner
from typing import Optional, Set
from typing_extensions import Self

class Content(BaseModel):
    """
    Content
    """ # noqa: E501
    id: StrictInt = Field(description="ID контента")
    author_id: StrictInt = Field(description="ID автора")
    title: StrictStr = Field(description="Название контента")
    description: StrictStr = Field(description="Описание контента")
    content_type: StrictStr = Field(description="Тип файла: - Видеоконтент:     - `video/mp4` - Аудиоконтент:     - `audio/mpeg` - Документ:     - `application/pdf`     - `application/epub+zip`     - `text/plain` ")
    uri: StrictStr = Field(description="URI адрес контента")
    files: List[ContentFilesInner] = Field(description="Список с информацией о дополнительных файлах")
    playlist: StrictStr = Field(description="URI адрес на плейлист контента.<br><br>  Если контент является аудио или видео контентом, то файл декодируется в плейлист ")
    meta: Optional[Any] = Field(default=None, description="Хранит в себе метаданные контента: - `bisac` —  ISBN (Международный стандартный книжный номер) - `voice` — Актер озвучивающий аудиоконтент - `author` — Автор контента - `rating` — Возрастное ограничение - `preview` — Короткий отрезок контента для предварительного просмотра - `duration` — Продолжительность контента - `thumbnail` — Список обложки для контента разного разрешения - `dimensions` — Список разрешений видео - `duration_ms` — Продолжительность контента в миллисекундах - `translator` — Автор перевода - `original_name` — Оригинальное название контента - `pages` — Количество страниц в контенте - `encoded_videos` — Список информации (размер, разрешение) для декодированного видео - `encoded_audios` — Список информации (размер, битрейт) для декодированного аудио ")
    category_id: StrictInt = Field(description="ID категории контента: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ ")
    status: StrictInt = Field(description="Статус контента: - `0` — Создан - `1` — Загружено на сервер - `2` — Опубликован - `3` — Ошибка в обработке или публикации - `4` — Обрабатывается - `5` — Отправлено на сервер ")
    created: StrictStr = Field(description="Дата создания, UTC+3 (Москва)")
    updated: StrictStr = Field(description="Дата обновления, UTC+3 (Москва)")
    __properties: ClassVar[List[str]] = ["id", "author_id", "title", "description", "content_type", "uri", "files", "playlist", "meta", "category_id", "status", "created", "updated"]

    @field_validator('content_type')
    def content_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['video/mp4', 'audio/mpeg', 'text/plain', 'application/pdf', 'application/epub+zip']):
            raise ValueError("must be one of enum values ('video/mp4', 'audio/mpeg', 'text/plain', 'application/pdf', 'application/epub+zip')")
        return value

    @field_validator('category_id')
    def category_id_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set([1, 2, 4]):
            raise ValueError("must be one of enum values (1, 2, 4)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Content from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item_files in self.files:
                if _item_files:
                    _items.append(_item_files.to_dict())
            _dict['files'] = _items
        # set to None if meta (nullable) is None
        # and model_fields_set contains the field
        if self.meta is None and "meta" in self.model_fields_set:
            _dict['meta'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Content from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "author_id": obj.get("author_id"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "content_type": obj.get("content_type"),
            "uri": obj.get("uri"),
            "files": [ContentFilesInner.from_dict(_item) for _item in obj["files"]] if obj.get("files") is not None else None,
            "playlist": obj.get("playlist"),
            "meta": obj.get("meta"),
            "category_id": obj.get("category_id"),
            "status": obj.get("status"),
            "created": obj.get("created"),
            "updated": obj.get("updated")
        })
        return _obj


