# coding: utf-8

"""
    Wildberries Цифровой

    По вопросам работы с WBD API обращайтесь в <a href=\"https://digital.wildberries.ru/support\" target=\"_blank\">техническую поддержку</a> 

    The version of the OpenAPI document: wbd
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ContentMeta(BaseModel):
    """
    Метаданные. Дополнительная информация о контенте 
    """ # noqa: E501
    thumbnail: List[StrictStr] = Field(description="URI адреса обложки контента")
    source_file_name: Optional[Annotated[str, Field(strict=True, max_length=100)]] = Field(default=None, description="Имя исходного файла")
    rating: Optional[StrictStr] = Field(default=None, description="Возрастное ограничение")
    original_name: Optional[Annotated[str, Field(strict=True, max_length=100)]] = Field(default=None, description="Оригинальное название контента")
    voice: Optional[Annotated[str, Field(strict=True, max_length=100)]] = Field(default=None, description="Актер озвучивающий аудиоконтент")
    bisac: Optional[StrictStr] = Field(default=None, description="[ISBN](https://en.wikipedia.org/wiki/ISBN) (Международный стандартный книжный номер) - Каждый ISBN уникален - Состоит из 13 символов, начиная с префикса **978** или **979** ")
    pages: Optional[StrictInt] = Field(default=None, description="Количество страниц в книге (файле)")
    author: Optional[Annotated[str, Field(strict=True, max_length=100)]] = Field(default=None, description="Автор контента")
    translator: Optional[Annotated[str, Field(strict=True, max_length=100)]] = Field(default=None, description="Переводчик ")
    duration: Optional[StrictStr] = Field(default=None, description="Продолжительность контента")
    __properties: ClassVar[List[str]] = ["thumbnail", "source_file_name", "rating", "original_name", "voice", "bisac", "pages", "author", "translator", "duration"]

    @field_validator('rating')
    def rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['0+', '6+', '12+', '14+', '16+', '18+']):
            raise ValueError("must be one of enum values ('0+', '6+', '12+', '14+', '16+', '18+')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentMeta from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentMeta from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "thumbnail": obj.get("thumbnail"),
            "source_file_name": obj.get("source_file_name"),
            "rating": obj.get("rating"),
            "original_name": obj.get("original_name"),
            "voice": obj.get("voice"),
            "bisac": obj.get("bisac"),
            "pages": obj.get("pages"),
            "author": obj.get("author"),
            "translator": obj.get("translator"),
            "duration": obj.get("duration")
        })
        return _obj


