# coding: utf-8

"""
    Wildberries Цифровой

    По вопросам работы с WBD API обращайтесь в <a href=\"https://digital.wildberries.ru/support\" target=\"_blank\">техническую поддержку</a> 

    The version of the OpenAPI document: wbd
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class KeyResponse(BaseModel):
    """
    KeyResponse
    """ # noqa: E501
    id: StrictInt = Field(description="ID ключа")
    value: StrictStr = Field(description="Значение ключа")
    created_at: StrictStr = Field(description="Дата и время создания ключа")
    buyed_at: Optional[StrictStr] = Field(default=None, description="Дата и время покупки ключа")
    deleted_at: Optional[StrictStr] = Field(default=None, description="Дата и время удаления ключа")
    __properties: ClassVar[List[str]] = ["id", "value", "created_at", "buyed_at", "deleted_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KeyResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if buyed_at (nullable) is None
        # and model_fields_set contains the field
        if self.buyed_at is None and "buyed_at" in self.model_fields_set:
            _dict['buyed_at'] = None

        # set to None if deleted_at (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_at is None and "deleted_at" in self.model_fields_set:
            _dict['deleted_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KeyResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "value": obj.get("value"),
            "created_at": obj.get("created_at"),
            "buyed_at": obj.get("buyed_at"),
            "deleted_at": obj.get("deleted_at")
        })
        return _obj


