# coding: utf-8

"""
    Wildberries Цифровой

    По вопросам работы с WBD API обращайтесь в <a href=\"https://digital.wildberries.ru/support\" target=\"_blank\">техническую поддержку</a> 

    The version of the OpenAPI document: wbd
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wildberries_sdk.wbd.models.offer_create_content import OfferCreateContent
from wildberries_sdk.wbd.models.offer_meta_request import OfferMetaRequest
from typing import Optional, Set
from typing_extensions import Self

class OfferCreateRequest(BaseModel):
    """
    Новое предложение
    """ # noqa: E501
    title: Annotated[str, Field(strict=True, max_length=500)] = Field(description="Название предложения.<br>Максимальная длина — **500 символов.**")
    description: Annotated[str, Field(strict=True, max_length=5000)] = Field(description="Описание предложения. Это текст, который описывает ваше предложение и помогает людям понять, что именно представляет из себя продаваемый вами товар и чем он может быть полезен. Важно правильно назвать предложение и более подробно прописать его описание, чтобы пользователи узнали как можно больше информации еще до покупки.<br>Максимальная длина — **5000 символов.**")
    tags: Annotated[List[Annotated[str, Field(strict=True, max_length=45)]], Field(min_length=1, max_length=5)] = Field(description="Массив тегов. Теги нужны для группирования, ранжирования и облегчения поиска вашего товара.<br><br>  **Ограничения**: - Default - Default ")
    section: StrictInt = Field(description="ID категории предложения: - `1` — Видеоконтент - `2` — Аудиоконтент - `3` — Ключи активации - `4` — Электронные книги - `5` — Аудиокниги - `6` — Цифровые товары - `8` — Услуги - `12` — Купоны и развлечения - `13` — Подарочные сертификаты ")
    catalog_path: Annotated[List[StrictInt], Field(min_length=1)] = Field(description="Массив ID подкатегорий, в котором находится предложение.<br> Воспользуйтесь методом [Получить категории и их подкатегории](./wbd#tag/Predlozheniya/operation/GetCatalog) для получения ID и правильного сопоставления с категорией. ")
    age_rating: StrictStr = Field(description="Возрастное ограничение. Это система, которая используется для определения, подходит ли ваше предложение для определенной возрастной группы.")
    price: StrictInt = Field(description="Цена предложения, ₽")
    discount_price: Optional[StrictInt] = Field(default=None, description="Цена с учетом скидки, ₽")
    gallery: Optional[Annotated[List[StrictStr], Field(max_length=8)]] = Field(default=None, description="Список URL-адресов дополнительных изображений, а так же видео превью.<br> **Можно передать до 8 медиафайлов.**<br> **Важно, чтобы все изображения были в формате JPG или PNG, а видео в формате MP4** ")
    keys: Optional[Annotated[List[Annotated[str, Field(strict=True, max_length=200)]], Field(max_length=1000)]] = Field(default=None, description="Список ключей.<br> Это **обязательное поле**, если вы хотите создать предложение из категории (`section`): - **Ключи активации** — `3` - **Купоны и развлечения** — `12` - **Подарочные сертификаты** — `13`  **Ограничения:** - Максимальное количество ключей — **1000** - Максимальная длина ключа — **200 символов** ")
    status: Optional[StrictInt] = Field(default=0, description="Задается статус вашего предложения: - `0` — Добавить в черновик - `1` — Опубликовать ")
    content: Optional[List[OfferCreateContent]] = Field(default=None, description="Список контента")
    meta: Optional[OfferMetaRequest] = None
    __properties: ClassVar[List[str]] = ["title", "description", "tags", "section", "catalog_path", "age_rating", "price", "discount_price", "gallery", "keys", "status", "content", "meta"]

    @field_validator('section')
    def section_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set([1, 2, 3, 4, 5, 6, 8, 9, 12, 13]):
            raise ValueError("must be one of enum values (1, 2, 3, 4, 5, 6, 8, 9, 12, 13)")
        return value

    @field_validator('age_rating')
    def age_rating_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['0+', '6+', '12+', '14+', '16+', '18+']):
            raise ValueError("must be one of enum values ('0+', '6+', '12+', '14+', '16+', '18+')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([0, 1]):
            raise ValueError("must be one of enum values (0, 1)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OfferCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in content (list)
        _items = []
        if self.content:
            for _item_content in self.content:
                if _item_content:
                    _items.append(_item_content.to_dict())
            _dict['content'] = _items
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OfferCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "description": obj.get("description"),
            "tags": obj.get("tags"),
            "section": obj.get("section"),
            "catalog_path": obj.get("catalog_path"),
            "age_rating": obj.get("age_rating"),
            "price": obj.get("price"),
            "discount_price": obj.get("discount_price"),
            "gallery": obj.get("gallery"),
            "keys": obj.get("keys"),
            "status": obj.get("status") if obj.get("status") is not None else 0,
            "content": [OfferCreateContent.from_dict(_item) for _item in obj["content"]] if obj.get("content") is not None else None,
            "meta": OfferMetaRequest.from_dict(obj["meta"]) if obj.get("meta") is not None else None
        })
        return _obj


