# coding: utf-8

"""
    Wildberries Цифровой

    По вопросам работы с WBD API обращайтесь в <a href=\"https://digital.wildberries.ru/support\" target=\"_blank\">техническую поддержку</a> 

    The version of the OpenAPI document: wbd
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from wildberries_sdk.wbd.models.offer_content import OfferContent
from wildberries_sdk.wbd.models.tag import Tag
from typing import Optional, Set
from typing_extensions import Self

class OfferResponse(BaseModel):
    """
    OfferResponse
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="ID предложения")
    title: Optional[StrictStr] = Field(default=None, description="Название предложения")
    description: Optional[StrictStr] = Field(default=None, description="Описание предложения")
    section: Optional[StrictInt] = Field(default=None, description="ID категории товара: - `1` — Видеоконтент - `2` — Аудиоконтент - `3` — Ключи активации - `4` — Электронные книги - `5` — Аудиокниги - `6` — Цифровые товары - `8` — Услуги - `12` — Купоны и развлечения - `13` — Подарочные сертификаты ")
    catalog_path: Optional[List[StrictInt]] = Field(default=None, description="Массив ID подкатегорий, в котором находится предложение")
    price: Optional[StrictInt] = Field(default=None, description="Цена предложения, ₽")
    discount_price: Optional[StrictInt] = Field(default=None, description="Цена с учетом скидки, ₽")
    gallery: Optional[List[StrictStr]] = Field(default=None, description="Список URL-адресов дополнительных изображений, а так же видео превью")
    meta: Optional[StrictStr] = Field(default=None, description="Метаданные предложения")
    tags: Optional[List[Tag]] = Field(default=None, description="Список тегов. Теги нужны для группирования, ранжирования и облегчения поиска вашего товара")
    thumbnail: Optional[List[StrictStr]] = Field(default=None, description="Обложка предложения")
    content: Optional[List[OfferContent]] = Field(default=None, description="Контент предложения")
    created: Optional[StrictStr] = Field(default=None, description="Дата создания, UTC+3 (Москва)")
    updated: Optional[StrictStr] = Field(default=None, description="Дата обновления, UTC+3 (Москва)")
    deleted: Optional[StrictStr] = Field(default=None, description="Дата удаления, UTC+3 (Москва). `1970-01-01T00:00:00Z` — является нулевым значением")
    status: Optional[StrictInt] = Field(default=None, description="Статус вашего предложения: - `0` — Добавить в черновик - `1` — Опубликовать ")
    view_count: Optional[StrictInt] = Field(default=None, description="Количество просмотров")
    purchase_count: Optional[StrictInt] = Field(default=None, description="Количество покупок")
    adult: Optional[StrictBool] = Field(default=None, description="Флаг, который отвечает за ограничение контента для взрослых (блюр контента)")
    age_rating: Optional[StrictStr] = Field(default=None, description="Возрастное ограничение. Это система, которая используется для определения, подходит ли ваше предложение для определенной возрастной группы")
    rating: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Рейтинг предложения")
    __properties: ClassVar[List[str]] = ["id", "title", "description", "section", "catalog_path", "price", "discount_price", "gallery", "meta", "tags", "thumbnail", "content", "created", "updated", "deleted", "status", "view_count", "purchase_count", "adult", "age_rating", "rating"]

    @field_validator('section')
    def section_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1, 2, 3, 4, 5, 6, 8, 9, 10, 12, 13]):
            raise ValueError("must be one of enum values (1, 2, 3, 4, 5, 6, 8, 9, 10, 12, 13)")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([0, 1]):
            raise ValueError("must be one of enum values (0, 1)")
        return value

    @field_validator('age_rating')
    def age_rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['0+', '6+', '12+', '14+', '16+', '18+']):
            raise ValueError("must be one of enum values ('0+', '6+', '12+', '14+', '16+', '18+')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OfferResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in content (list)
        _items = []
        if self.content:
            for _item_content in self.content:
                if _item_content:
                    _items.append(_item_content.to_dict())
            _dict['content'] = _items
        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OfferResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "section": obj.get("section"),
            "catalog_path": obj.get("catalog_path"),
            "price": obj.get("price"),
            "discount_price": obj.get("discount_price"),
            "gallery": obj.get("gallery"),
            "meta": obj.get("meta"),
            "tags": [Tag.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "thumbnail": obj.get("thumbnail"),
            "content": [OfferContent.from_dict(_item) for _item in obj["content"]] if obj.get("content") is not None else None,
            "created": obj.get("created"),
            "updated": obj.get("updated"),
            "deleted": obj.get("deleted"),
            "status": obj.get("status"),
            "view_count": obj.get("view_count"),
            "purchase_count": obj.get("purchase_count"),
            "adult": obj.get("adult"),
            "age_rating": obj.get("age_rating"),
            "rating": obj.get("rating")
        })
        return _obj


