# coding: utf-8

"""
    Wildberries Цифровой

    По вопросам работы с WBD API обращайтесь в <a href=\"https://digital.wildberries.ru/support\" target=\"_blank\">техническую поддержку</a> 

    The version of the OpenAPI document: wbd
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wildberries_sdk.wbd.models.offer_meta_request import OfferMetaRequest
from typing import Optional, Set
from typing_extensions import Self

class OfferUpdateRequest(BaseModel):
    """
    Характеристика предложения
    """ # noqa: E501
    title: Optional[Annotated[str, Field(strict=True, max_length=500)]] = Field(default=None, description="Название предложения.<br>Максимальная длина — **500 символов.**")
    description: Optional[Annotated[str, Field(strict=True, max_length=5000)]] = Field(default=None, description="Описание предложения. Это текст, который описывает ваше предложение и помогает людям понять, что именно представляет из себя продаваемый вами товар и чем он может быть полезен. Важно правильно назвать предложение и более подробно прописать его описание, чтобы пользователи узнали как можно больше информации еще до покупки.<br>Максимальная длина — **5000 символов.**")
    price: Optional[StrictInt] = Field(default=None, description="Цена предложения, ₽")
    discount_price: Optional[StrictInt] = Field(default=None, description="Цена с учетом скидки, ₽")
    gallery: Optional[Annotated[List[StrictStr], Field(max_length=8)]] = Field(default=None, description="Список URL-адресов дополнительных изображений, а так же видео превью.<br> **Можно передать до 8 медиафайлов.**<br> **Важно, чтобы все изображения были в формате JPG или PNG, а видео в формате MP4** ")
    age_rating: Optional[StrictStr] = Field(default=None, description="Возрастное ограничение. Это система, которая используется для определения, подходит ли ваше предложение для определенной возрастной группы.")
    tags: Optional[Annotated[List[Annotated[str, Field(strict=True, max_length=45)]], Field(min_length=1, max_length=5)]] = Field(default=None, description="Массив тегов. Теги нужны для группирования, ранжирования и облегчения поиска вашего товара.<br><br>  **Ограничения**: - Default - Default ")
    status: Optional[StrictInt] = Field(default=None, description="Статус вашего предложения: - `0` — Добавить в черновик - `1` — Опубликовать - `2` — Приостановить продажу - `3` — Удалить ")
    catalog_path: Optional[List[StrictInt]] = Field(default=None, description="Массив ID подкатегорий, в котором находится предложение.<br> Воспользуйтесь методом [Получить категории и их подкатегории](./wbd#tag/Predlozheniya/operation/GetCatalog) для получения ID и правильного сопоставления с категорией. ")
    meta: Optional[OfferMetaRequest] = None
    __properties: ClassVar[List[str]] = ["title", "description", "price", "discount_price", "gallery", "age_rating", "tags", "status", "catalog_path", "meta"]

    @field_validator('age_rating')
    def age_rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['0+', '6+', '12+', '14+', '16+', '18+']):
            raise ValueError("must be one of enum values ('0+', '6+', '12+', '14+', '16+', '18+')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([0, 1, 2, 3]):
            raise ValueError("must be one of enum values (0, 1, 2, 3)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OfferUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        # set to None if discount_price (nullable) is None
        # and model_fields_set contains the field
        if self.discount_price is None and "discount_price" in self.model_fields_set:
            _dict['discount_price'] = None

        # set to None if gallery (nullable) is None
        # and model_fields_set contains the field
        if self.gallery is None and "gallery" in self.model_fields_set:
            _dict['gallery'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OfferUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "description": obj.get("description"),
            "price": obj.get("price"),
            "discount_price": obj.get("discount_price"),
            "gallery": obj.get("gallery"),
            "age_rating": obj.get("age_rating"),
            "tags": obj.get("tags"),
            "status": obj.get("status"),
            "catalog_path": obj.get("catalog_path"),
            "meta": OfferMetaRequest.from_dict(obj["meta"]) if obj.get("meta") is not None else None
        })
        return _obj


