# coding: utf-8

"""
    Wildberries Цифровой

    По вопросам работы с WBD API обращайтесь в <a href=\"https://digital.wildberries.ru/support\" target=\"_blank\">техническую поддержку</a> 

    The version of the OpenAPI document: wbd
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wildberries_sdk.wbd.models.chunk_part import ChunkPart
from wildberries_sdk.wbd.models.content_meta import ContentMeta
from typing import Optional, Set
from typing_extensions import Self

class UploadInitRequest(BaseModel):
    """
    UploadInitRequest
    """ # noqa: E501
    title: Annotated[str, Field(strict=True, max_length=500)] = Field(description="Название контента.<br>Максимальная длина — **500 символов.**")
    description: Annotated[str, Field(strict=True, max_length=1000)] = Field(description="Описание контента.<br>Максимальная длина — **1000 символов.**")
    catalog_id: StrictInt = Field(description="ID категории контента: - `1` — Видеоконтент - `2` — Аудиоконтент - `4` — Документ ")
    content_type: StrictStr = Field(description="Тип файла: - Видеоконтент:     - `video/mp4` - Аудиоконтент:     - `audio/mpeg` - Документ:     - `application/pdf`     - `application/epub+zip`     - `text/plain` ")
    parts: List[ChunkPart] = Field(description="Для оптимальной скорости загрузки контента следует разбить файл на фреймы по 2 Мб. В массиве указываются индекс каждого фрейма и его размер ")
    meta: Optional[ContentMeta]
    __properties: ClassVar[List[str]] = ["title", "description", "catalog_id", "content_type", "parts", "meta"]

    @field_validator('catalog_id')
    def catalog_id_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set([1, 2, 4]):
            raise ValueError("must be one of enum values (1, 2, 4)")
        return value

    @field_validator('content_type')
    def content_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['video/mp4', 'audio/mpeg', 'text/plain', 'application/pdf', 'application/epub+zip']):
            raise ValueError("must be one of enum values ('video/mp4', 'audio/mpeg', 'text/plain', 'application/pdf', 'application/epub+zip')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UploadInitRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in parts (list)
        _items = []
        if self.parts:
            for _item_parts in self.parts:
                if _item_parts:
                    _items.append(_item_parts.to_dict())
            _dict['parts'] = _items
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        # set to None if meta (nullable) is None
        # and model_fields_set contains the field
        if self.meta is None and "meta" in self.model_fields_set:
            _dict['meta'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UploadInitRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "description": obj.get("description"),
            "catalog_id": obj.get("catalog_id"),
            "content_type": obj.get("content_type"),
            "parts": [ChunkPart.from_dict(_item) for _item in obj["parts"]] if obj.get("parts") is not None else None,
            "meta": ContentMeta.from_dict(obj["meta"]) if obj.get("meta") is not None else None
        })
        return _obj


