import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppEngineApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The domain to authenticate users with when using App Engine's User API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#auth_domain AppEngineApplication#auth_domain}
    */
    readonly authDomain?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#database_type AppEngineApplication#database_type}
    */
    readonly databaseType?: string;
    /**
    * The location to serve the app from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#location_id AppEngineApplication#location_id}
    */
    readonly locationId: string;
    /**
    * The project ID to create the application under.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#project AppEngineApplication#project}
    */
    readonly project?: string;
    /**
    * The serving status of the app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#serving_status AppEngineApplication#serving_status}
    */
    readonly servingStatus?: string;
    /**
    * feature_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#feature_settings AppEngineApplication#feature_settings}
    */
    readonly featureSettings?: AppEngineApplicationFeatureSettings;
    /**
    * iap block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#iap AppEngineApplication#iap}
    */
    readonly iap?: AppEngineApplicationIap;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#timeouts AppEngineApplication#timeouts}
    */
    readonly timeouts?: AppEngineApplicationTimeouts;
}
export interface AppEngineApplicationUrlDispatchRule {
}
export declare function appEngineApplicationUrlDispatchRuleToTerraform(struct?: AppEngineApplicationUrlDispatchRule): any;
export declare class AppEngineApplicationUrlDispatchRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppEngineApplicationUrlDispatchRule | undefined;
    set internalValue(value: AppEngineApplicationUrlDispatchRule | undefined);
    get domain(): string;
    get path(): string;
    get service(): string;
}
export declare class AppEngineApplicationUrlDispatchRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppEngineApplicationUrlDispatchRuleOutputReference;
}
export interface AppEngineApplicationFeatureSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#split_health_checks AppEngineApplication#split_health_checks}
    */
    readonly splitHealthChecks: boolean | cdktf.IResolvable;
}
export declare function appEngineApplicationFeatureSettingsToTerraform(struct?: AppEngineApplicationFeatureSettingsOutputReference | AppEngineApplicationFeatureSettings): any;
export declare class AppEngineApplicationFeatureSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppEngineApplicationFeatureSettings | undefined;
    set internalValue(value: AppEngineApplicationFeatureSettings | undefined);
    private _splitHealthChecks?;
    get splitHealthChecks(): boolean | cdktf.IResolvable;
    set splitHealthChecks(value: boolean | cdktf.IResolvable);
    get splitHealthChecksInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AppEngineApplicationIap {
    /**
    * Adapted for use with the app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#enabled AppEngineApplication#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * OAuth2 client ID to use for the authentication flow.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#oauth2_client_id AppEngineApplication#oauth2_client_id}
    */
    readonly oauth2ClientId: string;
    /**
    * OAuth2 client secret to use for the authentication flow. The SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#oauth2_client_secret AppEngineApplication#oauth2_client_secret}
    */
    readonly oauth2ClientSecret: string;
}
export declare function appEngineApplicationIapToTerraform(struct?: AppEngineApplicationIapOutputReference | AppEngineApplicationIap): any;
export declare class AppEngineApplicationIapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppEngineApplicationIap | undefined;
    set internalValue(value: AppEngineApplicationIap | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _oauth2ClientId?;
    get oauth2ClientId(): string;
    set oauth2ClientId(value: string);
    get oauth2ClientIdInput(): string | undefined;
    private _oauth2ClientSecret?;
    get oauth2ClientSecret(): string;
    set oauth2ClientSecret(value: string);
    get oauth2ClientSecretInput(): string | undefined;
    get oauth2ClientSecretSha256(): string;
}
export interface AppEngineApplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#create AppEngineApplication#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#update AppEngineApplication#update}
    */
    readonly update?: string;
}
export declare function appEngineApplicationTimeoutsToTerraform(struct?: AppEngineApplicationTimeoutsOutputReference | AppEngineApplicationTimeouts | cdktf.IResolvable): any;
export declare class AppEngineApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppEngineApplicationTimeouts | undefined;
    set internalValue(value: AppEngineApplicationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_application google_app_engine_application}
*/
export declare class AppEngineApplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_app_engine_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_application google_app_engine_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppEngineApplicationConfig
    */
    constructor(scope: Construct, id: string, config: AppEngineApplicationConfig);
    get appId(): string;
    private _authDomain?;
    get authDomain(): string;
    set authDomain(value: string);
    resetAuthDomain(): void;
    get authDomainInput(): string | undefined;
    get codeBucket(): string;
    private _databaseType?;
    get databaseType(): string;
    set databaseType(value: string);
    resetDatabaseType(): void;
    get databaseTypeInput(): string | undefined;
    get defaultBucket(): string;
    get defaultHostname(): string;
    get gcrDomain(): string;
    get id(): string;
    private _locationId?;
    get locationId(): string;
    set locationId(value: string);
    get locationIdInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _servingStatus?;
    get servingStatus(): string;
    set servingStatus(value: string);
    resetServingStatus(): void;
    get servingStatusInput(): string | undefined;
    private _urlDispatchRule;
    get urlDispatchRule(): AppEngineApplicationUrlDispatchRuleList;
    private _featureSettings;
    get featureSettings(): AppEngineApplicationFeatureSettingsOutputReference;
    putFeatureSettings(value: AppEngineApplicationFeatureSettings): void;
    resetFeatureSettings(): void;
    get featureSettingsInput(): AppEngineApplicationFeatureSettings | undefined;
    private _iap;
    get iap(): AppEngineApplicationIapOutputReference;
    putIap(value: AppEngineApplicationIap): void;
    resetIap(): void;
    get iapInput(): AppEngineApplicationIap | undefined;
    private _timeouts;
    get timeouts(): AppEngineApplicationTimeoutsOutputReference;
    putTimeouts(value: AppEngineApplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppEngineApplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
