import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAnalysisNoteConfig extends cdktf.TerraformMetaArguments {
    /**
    * Time of expiration for this note. Leave empty if note does not expire.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#expiration_time ContainerAnalysisNote#expiration_time}
    */
    readonly expirationTime?: string;
    /**
    * A detailed description of the note
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#long_description ContainerAnalysisNote#long_description}
    */
    readonly longDescription?: string;
    /**
    * The name of the note.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#name ContainerAnalysisNote#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#project ContainerAnalysisNote#project}
    */
    readonly project?: string;
    /**
    * Names of other notes related to this note.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#related_note_names ContainerAnalysisNote#related_note_names}
    */
    readonly relatedNoteNames?: string[];
    /**
    * A one sentence description of the note.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#short_description ContainerAnalysisNote#short_description}
    */
    readonly shortDescription?: string;
    /**
    * attestation_authority block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#attestation_authority ContainerAnalysisNote#attestation_authority}
    */
    readonly attestationAuthority: ContainerAnalysisNoteAttestationAuthority;
    /**
    * related_url block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#related_url ContainerAnalysisNote#related_url}
    */
    readonly relatedUrl?: ContainerAnalysisNoteRelatedUrl[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#timeouts ContainerAnalysisNote#timeouts}
    */
    readonly timeouts?: ContainerAnalysisNoteTimeouts;
}
export interface ContainerAnalysisNoteAttestationAuthorityHint {
    /**
    * The human readable name of this Attestation Authority, for
  example "qa".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#human_readable_name ContainerAnalysisNote#human_readable_name}
    */
    readonly humanReadableName: string;
}
export declare function containerAnalysisNoteAttestationAuthorityHintToTerraform(struct?: ContainerAnalysisNoteAttestationAuthorityHintOutputReference | ContainerAnalysisNoteAttestationAuthorityHint): any;
export declare class ContainerAnalysisNoteAttestationAuthorityHintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAnalysisNoteAttestationAuthorityHint | undefined;
    set internalValue(value: ContainerAnalysisNoteAttestationAuthorityHint | undefined);
    private _humanReadableName?;
    get humanReadableName(): string;
    set humanReadableName(value: string);
    get humanReadableNameInput(): string | undefined;
}
export interface ContainerAnalysisNoteAttestationAuthority {
    /**
    * hint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#hint ContainerAnalysisNote#hint}
    */
    readonly hint: ContainerAnalysisNoteAttestationAuthorityHint;
}
export declare function containerAnalysisNoteAttestationAuthorityToTerraform(struct?: ContainerAnalysisNoteAttestationAuthorityOutputReference | ContainerAnalysisNoteAttestationAuthority): any;
export declare class ContainerAnalysisNoteAttestationAuthorityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAnalysisNoteAttestationAuthority | undefined;
    set internalValue(value: ContainerAnalysisNoteAttestationAuthority | undefined);
    private _hint;
    get hint(): ContainerAnalysisNoteAttestationAuthorityHintOutputReference;
    putHint(value: ContainerAnalysisNoteAttestationAuthorityHint): void;
    get hintInput(): ContainerAnalysisNoteAttestationAuthorityHint | undefined;
}
export interface ContainerAnalysisNoteRelatedUrl {
    /**
    * Label to describe usage of the URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#label ContainerAnalysisNote#label}
    */
    readonly label?: string;
    /**
    * Specific URL associated with the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#url ContainerAnalysisNote#url}
    */
    readonly url: string;
}
export declare function containerAnalysisNoteRelatedUrlToTerraform(struct?: ContainerAnalysisNoteRelatedUrl | cdktf.IResolvable): any;
export interface ContainerAnalysisNoteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#create ContainerAnalysisNote#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#delete ContainerAnalysisNote#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note#update ContainerAnalysisNote#update}
    */
    readonly update?: string;
}
export declare function containerAnalysisNoteTimeoutsToTerraform(struct?: ContainerAnalysisNoteTimeoutsOutputReference | ContainerAnalysisNoteTimeouts | cdktf.IResolvable): any;
export declare class ContainerAnalysisNoteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAnalysisNoteTimeouts | undefined;
    set internalValue(value: ContainerAnalysisNoteTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note google_container_analysis_note}
*/
export declare class ContainerAnalysisNote extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_analysis_note";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note google_container_analysis_note} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAnalysisNoteConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAnalysisNoteConfig);
    get createTime(): string;
    private _expirationTime?;
    get expirationTime(): string;
    set expirationTime(value: string);
    resetExpirationTime(): void;
    get expirationTimeInput(): string | undefined;
    get id(): string;
    get kind(): string;
    private _longDescription?;
    get longDescription(): string;
    set longDescription(value: string);
    resetLongDescription(): void;
    get longDescriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _relatedNoteNames?;
    get relatedNoteNames(): string[];
    set relatedNoteNames(value: string[]);
    resetRelatedNoteNames(): void;
    get relatedNoteNamesInput(): string[] | undefined;
    private _shortDescription?;
    get shortDescription(): string;
    set shortDescription(value: string);
    resetShortDescription(): void;
    get shortDescriptionInput(): string | undefined;
    get updateTime(): string;
    private _attestationAuthority;
    get attestationAuthority(): ContainerAnalysisNoteAttestationAuthorityOutputReference;
    putAttestationAuthority(value: ContainerAnalysisNoteAttestationAuthority): void;
    get attestationAuthorityInput(): ContainerAnalysisNoteAttestationAuthority | undefined;
    private _relatedUrl?;
    get relatedUrl(): ContainerAnalysisNoteRelatedUrl[] | cdktf.IResolvable;
    set relatedUrl(value: ContainerAnalysisNoteRelatedUrl[] | cdktf.IResolvable);
    resetRelatedUrl(): void;
    get relatedUrlInput(): cdktf.IResolvable | ContainerAnalysisNoteRelatedUrl[] | undefined;
    private _timeouts;
    get timeouts(): ContainerAnalysisNoteTimeoutsOutputReference;
    putTimeouts(value: ContainerAnalysisNoteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ContainerAnalysisNoteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
