import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogEntryGroupIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_policy#entry_group DataCatalogEntryGroupIamPolicy#entry_group}
    */
    readonly entryGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_policy#policy_data DataCatalogEntryGroupIamPolicy#policy_data}
    */
    readonly policyData: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_policy#project DataCatalogEntryGroupIamPolicy#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_policy#region DataCatalogEntryGroupIamPolicy#region}
    */
    readonly region?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_policy google_data_catalog_entry_group_iam_policy}
*/
export declare class DataCatalogEntryGroupIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_entry_group_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_policy google_data_catalog_entry_group_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataCatalogEntryGroupIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataCatalogEntryGroupIamPolicyConfig);
    private _entryGroup?;
    get entryGroup(): string;
    set entryGroup(value: string);
    get entryGroupInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
