import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleActiveFolderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/active_folder#display_name DataGoogleActiveFolder#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/active_folder#parent DataGoogleActiveFolder#parent}
    */
    readonly parent: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/active_folder google_active_folder}
*/
export declare class DataGoogleActiveFolder extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_active_folder";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/active_folder google_active_folder} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleActiveFolderConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleActiveFolderConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
