import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleIapClientConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifier of the brand to which this client
  is attached to. The format is
  'projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iap_client#brand DataGoogleIapClient#brand}
    */
    readonly brand: string;
    /**
    * Output only. Unique identifier of the OAuth client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iap_client#client_id DataGoogleIapClient#client_id}
    */
    readonly clientId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/iap_client google_iap_client}
*/
export declare class DataGoogleIapClient extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_iap_client";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/iap_client google_iap_client} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleIapClientConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleIapClientConfig);
    private _brand?;
    get brand(): string;
    set brand(value: string);
    get brandInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    get displayName(): string;
    get id(): string;
    get secret(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
