import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleServiceAccountKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_key#name DataGoogleServiceAccountKey#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_key#project DataGoogleServiceAccountKey#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_key#public_key_type DataGoogleServiceAccountKey#public_key_type}
    */
    readonly publicKeyType?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/service_account_key google_service_account_key}
*/
export declare class DataGoogleServiceAccountKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_service_account_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/service_account_key google_service_account_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleServiceAccountKeyConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleServiceAccountKeyConfig);
    get id(): string;
    get keyAlgorithm(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get publicKey(): string;
    private _publicKeyType?;
    get publicKeyType(): string;
    set publicKeyType(value: string);
    resetPublicKeyType(): void;
    get publicKeyTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
