import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSpannerInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the instance's configuration (similar but not
  quite the same as a region) which defines the geographic placement and
  replication of your databases in this instance. It determines where your data
  is stored. Values are typically of the form 'regional-europe-west1' , 'us-central' etc.
  In order to obtain a valid list please consult the
  [Configuration section of the docs](https://cloud.google.com/spanner/docs/instances).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance#config DataGoogleSpannerInstance#config}
    */
    readonly config?: string;
    /**
    * The descriptive name for this instance as it appears in UIs. Must be
  unique per project and between 4 and 30 characters in length.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance#display_name DataGoogleSpannerInstance#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance#force_destroy DataGoogleSpannerInstance#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * An object containing a list of "key": value pairs.
  Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance#labels DataGoogleSpannerInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * A unique identifier for the instance, which cannot be changed after
  the instance is created. The name must be between 6 and 30 characters
  in length.
  
  
  If not provided, a random string starting with 'tf-' will be selected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance#name DataGoogleSpannerInstance#name}
    */
    readonly name: string;
    /**
    * The number of nodes allocated to this instance. At most one of either node_count or processing_units
  can be present in terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance#num_nodes DataGoogleSpannerInstance#num_nodes}
    */
    readonly numNodes?: number;
    /**
    * The number of processing units allocated to this instance. At most one of processing_units
  or node_count can be present in terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance#processing_units DataGoogleSpannerInstance#processing_units}
    */
    readonly processingUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance#project DataGoogleSpannerInstance#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/spanner_instance google_spanner_instance}
*/
export declare class DataGoogleSpannerInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_spanner_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/spanner_instance google_spanner_instance} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSpannerInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSpannerInstanceConfig);
    private _config?;
    get config(): string;
    set config(value: string);
    resetConfig(): void;
    get configInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _numNodes?;
    get numNodes(): number;
    set numNodes(value: number);
    resetNumNodes(): void;
    get numNodesInput(): number | undefined;
    private _processingUnits?;
    get processingUnits(): number;
    set processingUnits(value: number);
    resetProcessingUnits(): void;
    get processingUnitsInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
