import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLossPreventionStoredInfoTypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the info type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#description DataLossPreventionStoredInfoType#description}
    */
    readonly description?: string;
    /**
    * User set display name of the info type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#display_name DataLossPreventionStoredInfoType#display_name}
    */
    readonly displayName?: string;
    /**
    * The parent of the info type in any of the following formats:
  
  * 'projects/{{project}}'
  * 'projects/{{project}}/locations/{{location}}'
  * 'organizations/{{organization_id}}'
  * 'organizations/{{organization_id}}/locations/{{location}}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#parent DataLossPreventionStoredInfoType#parent}
    */
    readonly parent: string;
    /**
    * dictionary block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#dictionary DataLossPreventionStoredInfoType#dictionary}
    */
    readonly dictionary?: DataLossPreventionStoredInfoTypeDictionary;
    /**
    * large_custom_dictionary block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#large_custom_dictionary DataLossPreventionStoredInfoType#large_custom_dictionary}
    */
    readonly largeCustomDictionary?: DataLossPreventionStoredInfoTypeLargeCustomDictionary;
    /**
    * regex block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#regex DataLossPreventionStoredInfoType#regex}
    */
    readonly regex?: DataLossPreventionStoredInfoTypeRegex;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#timeouts DataLossPreventionStoredInfoType#timeouts}
    */
    readonly timeouts?: DataLossPreventionStoredInfoTypeTimeouts;
}
export interface DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath {
    /**
    * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#path DataLossPreventionStoredInfoType#path}
    */
    readonly path: string;
}
export declare function dataLossPreventionStoredInfoTypeDictionaryCloudStoragePathToTerraform(struct?: DataLossPreventionStoredInfoTypeDictionaryCloudStoragePathOutputReference | DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath): any;
export declare class DataLossPreventionStoredInfoTypeDictionaryCloudStoragePathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath | undefined;
    set internalValue(value: DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface DataLossPreventionStoredInfoTypeDictionaryWordList {
    /**
    * Words or phrases defining the dictionary. The dictionary must contain at least one
  phrase and every phrase must contain at least 2 characters that are letters or digits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#words DataLossPreventionStoredInfoType#words}
    */
    readonly words: string[];
}
export declare function dataLossPreventionStoredInfoTypeDictionaryWordListToTerraform(struct?: DataLossPreventionStoredInfoTypeDictionaryWordListOutputReference | DataLossPreventionStoredInfoTypeDictionaryWordList): any;
export declare class DataLossPreventionStoredInfoTypeDictionaryWordListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionStoredInfoTypeDictionaryWordList | undefined;
    set internalValue(value: DataLossPreventionStoredInfoTypeDictionaryWordList | undefined);
    private _words?;
    get words(): string[];
    set words(value: string[]);
    get wordsInput(): string[] | undefined;
}
export interface DataLossPreventionStoredInfoTypeDictionary {
    /**
    * cloud_storage_path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#cloud_storage_path DataLossPreventionStoredInfoType#cloud_storage_path}
    */
    readonly cloudStoragePath?: DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath;
    /**
    * word_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#word_list DataLossPreventionStoredInfoType#word_list}
    */
    readonly wordList?: DataLossPreventionStoredInfoTypeDictionaryWordList;
}
export declare function dataLossPreventionStoredInfoTypeDictionaryToTerraform(struct?: DataLossPreventionStoredInfoTypeDictionaryOutputReference | DataLossPreventionStoredInfoTypeDictionary): any;
export declare class DataLossPreventionStoredInfoTypeDictionaryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionStoredInfoTypeDictionary | undefined;
    set internalValue(value: DataLossPreventionStoredInfoTypeDictionary | undefined);
    private _cloudStoragePath;
    get cloudStoragePath(): DataLossPreventionStoredInfoTypeDictionaryCloudStoragePathOutputReference;
    putCloudStoragePath(value: DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath): void;
    resetCloudStoragePath(): void;
    get cloudStoragePathInput(): DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath | undefined;
    private _wordList;
    get wordList(): DataLossPreventionStoredInfoTypeDictionaryWordListOutputReference;
    putWordList(value: DataLossPreventionStoredInfoTypeDictionaryWordList): void;
    resetWordList(): void;
    get wordListInput(): DataLossPreventionStoredInfoTypeDictionaryWordList | undefined;
}
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField {
    /**
    * Name describing the field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#name DataLossPreventionStoredInfoType#name}
    */
    readonly name: string;
}
export declare function dataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldToTerraform(struct?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldOutputReference | DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField): any;
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField | undefined;
    set internalValue(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable {
    /**
    * The dataset ID of the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#dataset_id DataLossPreventionStoredInfoType#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The Google Cloud Platform project ID of the project containing the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#project_id DataLossPreventionStoredInfoType#project_id}
    */
    readonly projectId: string;
    /**
    * The name of the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#table_id DataLossPreventionStoredInfoType#table_id}
    */
    readonly tableId: string;
}
export declare function dataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableToTerraform(struct?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableOutputReference | DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable): any;
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable | undefined;
    set internalValue(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField {
    /**
    * field block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#field DataLossPreventionStoredInfoType#field}
    */
    readonly field: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField;
    /**
    * table block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#table DataLossPreventionStoredInfoType#table}
    */
    readonly table: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable;
}
export declare function dataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldToTerraform(struct?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldOutputReference | DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField): any;
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField | undefined;
    set internalValue(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField | undefined);
    private _field;
    get field(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldOutputReference;
    putField(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField): void;
    get fieldInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField | undefined;
    private _table;
    get table(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableOutputReference;
    putTable(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable): void;
    get tableInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable | undefined;
}
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet {
    /**
    * The url, in the format 'gs://<bucket>/<path>'. Trailing wildcard in the path is allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#url DataLossPreventionStoredInfoType#url}
    */
    readonly url: string;
}
export declare function dataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetToTerraform(struct?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetOutputReference | DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet): any;
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet | undefined;
    set internalValue(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath {
    /**
    * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#path DataLossPreventionStoredInfoType#path}
    */
    readonly path: string;
}
export declare function dataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathToTerraform(struct?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathOutputReference | DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath): any;
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath | undefined;
    set internalValue(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionary {
    /**
    * big_query_field block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#big_query_field DataLossPreventionStoredInfoType#big_query_field}
    */
    readonly bigQueryField?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField;
    /**
    * cloud_storage_file_set block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#cloud_storage_file_set DataLossPreventionStoredInfoType#cloud_storage_file_set}
    */
    readonly cloudStorageFileSet?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet;
    /**
    * output_path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#output_path DataLossPreventionStoredInfoType#output_path}
    */
    readonly outputPath: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath;
}
export declare function dataLossPreventionStoredInfoTypeLargeCustomDictionaryToTerraform(struct?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputReference | DataLossPreventionStoredInfoTypeLargeCustomDictionary): any;
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionStoredInfoTypeLargeCustomDictionary | undefined;
    set internalValue(value: DataLossPreventionStoredInfoTypeLargeCustomDictionary | undefined);
    private _bigQueryField;
    get bigQueryField(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldOutputReference;
    putBigQueryField(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField): void;
    resetBigQueryField(): void;
    get bigQueryFieldInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField | undefined;
    private _cloudStorageFileSet;
    get cloudStorageFileSet(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetOutputReference;
    putCloudStorageFileSet(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet): void;
    resetCloudStorageFileSet(): void;
    get cloudStorageFileSetInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet | undefined;
    private _outputPath;
    get outputPath(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathOutputReference;
    putOutputPath(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath): void;
    get outputPathInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath | undefined;
}
export interface DataLossPreventionStoredInfoTypeRegex {
    /**
    * The index of the submatch to extract as findings. When not specified, the entire match is returned. No more than 3 may be included.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#group_indexes DataLossPreventionStoredInfoType#group_indexes}
    */
    readonly groupIndexes?: number[];
    /**
    * Pattern defining the regular expression.
  Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#pattern DataLossPreventionStoredInfoType#pattern}
    */
    readonly pattern: string;
}
export declare function dataLossPreventionStoredInfoTypeRegexToTerraform(struct?: DataLossPreventionStoredInfoTypeRegexOutputReference | DataLossPreventionStoredInfoTypeRegex): any;
export declare class DataLossPreventionStoredInfoTypeRegexOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionStoredInfoTypeRegex | undefined;
    set internalValue(value: DataLossPreventionStoredInfoTypeRegex | undefined);
    private _groupIndexes?;
    get groupIndexes(): number[];
    set groupIndexes(value: number[]);
    resetGroupIndexes(): void;
    get groupIndexesInput(): number[] | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    get patternInput(): string | undefined;
}
export interface DataLossPreventionStoredInfoTypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#create DataLossPreventionStoredInfoType#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#delete DataLossPreventionStoredInfoType#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type#update DataLossPreventionStoredInfoType#update}
    */
    readonly update?: string;
}
export declare function dataLossPreventionStoredInfoTypeTimeoutsToTerraform(struct?: DataLossPreventionStoredInfoTypeTimeoutsOutputReference | DataLossPreventionStoredInfoTypeTimeouts | cdktf.IResolvable): any;
export declare class DataLossPreventionStoredInfoTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionStoredInfoTypeTimeouts | undefined;
    set internalValue(value: DataLossPreventionStoredInfoTypeTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type google_data_loss_prevention_stored_info_type}
*/
export declare class DataLossPreventionStoredInfoType extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_loss_prevention_stored_info_type";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type google_data_loss_prevention_stored_info_type} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLossPreventionStoredInfoTypeConfig
    */
    constructor(scope: Construct, id: string, config: DataLossPreventionStoredInfoTypeConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _dictionary;
    get dictionary(): DataLossPreventionStoredInfoTypeDictionaryOutputReference;
    putDictionary(value: DataLossPreventionStoredInfoTypeDictionary): void;
    resetDictionary(): void;
    get dictionaryInput(): DataLossPreventionStoredInfoTypeDictionary | undefined;
    private _largeCustomDictionary;
    get largeCustomDictionary(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputReference;
    putLargeCustomDictionary(value: DataLossPreventionStoredInfoTypeLargeCustomDictionary): void;
    resetLargeCustomDictionary(): void;
    get largeCustomDictionaryInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionary | undefined;
    private _regex;
    get regex(): DataLossPreventionStoredInfoTypeRegexOutputReference;
    putRegex(value: DataLossPreventionStoredInfoTypeRegex): void;
    resetRegex(): void;
    get regexInput(): DataLossPreventionStoredInfoTypeRegex | undefined;
    private _timeouts;
    get timeouts(): DataLossPreventionStoredInfoTypeTimeoutsOutputReference;
    putTimeouts(value: DataLossPreventionStoredInfoTypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataLossPreventionStoredInfoTypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
