import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FolderAccessApprovalSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the folder of the access approval settings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings#folder_id FolderAccessApprovalSettings#folder_id}
    */
    readonly folderId: string;
    /**
    * A list of email addresses to which notifications relating to approval requests should be sent.
  Notifications relating to a resource will be sent to all emails in the settings of ancestor
  resources of that resource. A maximum of 50 email addresses are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings#notification_emails FolderAccessApprovalSettings#notification_emails}
    */
    readonly notificationEmails?: string[];
    /**
    * enrolled_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings#enrolled_services FolderAccessApprovalSettings#enrolled_services}
    */
    readonly enrolledServices: FolderAccessApprovalSettingsEnrolledServices[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings#timeouts FolderAccessApprovalSettings#timeouts}
    */
    readonly timeouts?: FolderAccessApprovalSettingsTimeouts;
}
export interface FolderAccessApprovalSettingsEnrolledServices {
    /**
    * The product for which Access Approval will be enrolled. Allowed values are listed (case-sensitive):
    * all
    * App Engine
    * BigQuery
    * Cloud Bigtable
    * Cloud Key Management Service
    * Compute Engine
    * Cloud Dataflow
    * Cloud Identity and Access Management
    * Cloud Pub/Sub
    * Cloud Storage
    * Persistent Disk
  
  Note: These values are supported as input, but considered a legacy format:
    * all
    * appengine.googleapis.com
    * bigquery.googleapis.com
    * bigtable.googleapis.com
    * cloudkms.googleapis.com
    * compute.googleapis.com
    * dataflow.googleapis.com
    * iam.googleapis.com
    * pubsub.googleapis.com
    * storage.googleapis.com
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings#cloud_product FolderAccessApprovalSettings#cloud_product}
    */
    readonly cloudProduct: string;
    /**
    * The enrollment level of the service. Default value: "BLOCK_ALL" Possible values: ["BLOCK_ALL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings#enrollment_level FolderAccessApprovalSettings#enrollment_level}
    */
    readonly enrollmentLevel?: string;
}
export declare function folderAccessApprovalSettingsEnrolledServicesToTerraform(struct?: FolderAccessApprovalSettingsEnrolledServices | cdktf.IResolvable): any;
export interface FolderAccessApprovalSettingsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings#create FolderAccessApprovalSettings#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings#delete FolderAccessApprovalSettings#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings#update FolderAccessApprovalSettings#update}
    */
    readonly update?: string;
}
export declare function folderAccessApprovalSettingsTimeoutsToTerraform(struct?: FolderAccessApprovalSettingsTimeoutsOutputReference | FolderAccessApprovalSettingsTimeouts | cdktf.IResolvable): any;
export declare class FolderAccessApprovalSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FolderAccessApprovalSettingsTimeouts | undefined;
    set internalValue(value: FolderAccessApprovalSettingsTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings google_folder_access_approval_settings}
*/
export declare class FolderAccessApprovalSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_folder_access_approval_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings google_folder_access_approval_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FolderAccessApprovalSettingsConfig
    */
    constructor(scope: Construct, id: string, config: FolderAccessApprovalSettingsConfig);
    get enrolledAncestor(): cdktf.IResolvable;
    private _folderId?;
    get folderId(): string;
    set folderId(value: string);
    get folderIdInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _notificationEmails?;
    get notificationEmails(): string[];
    set notificationEmails(value: string[]);
    resetNotificationEmails(): void;
    get notificationEmailsInput(): string[] | undefined;
    private _enrolledServices?;
    get enrolledServices(): FolderAccessApprovalSettingsEnrolledServices[] | cdktf.IResolvable;
    set enrolledServices(value: FolderAccessApprovalSettingsEnrolledServices[] | cdktf.IResolvable);
    get enrolledServicesInput(): cdktf.IResolvable | FolderAccessApprovalSettingsEnrolledServices[] | undefined;
    private _timeouts;
    get timeouts(): FolderAccessApprovalSettingsTimeoutsOutputReference;
    putTimeouts(value: FolderAccessApprovalSettingsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FolderAccessApprovalSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
