import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmsCryptoKeyIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_policy#crypto_key_id KmsCryptoKeyIamPolicy#crypto_key_id}
    */
    readonly cryptoKeyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_policy#policy_data KmsCryptoKeyIamPolicy#policy_data}
    */
    readonly policyData: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_policy google_kms_crypto_key_iam_policy}
*/
export declare class KmsCryptoKeyIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_kms_crypto_key_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_policy google_kms_crypto_key_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmsCryptoKeyIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: KmsCryptoKeyIamPolicyConfig);
    private _cryptoKeyId?;
    get cryptoKeyId(): string;
    set cryptoKeyId(value: string);
    get cryptoKeyIdInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
