import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationIamAuditConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The numeric ID of the organization in which you want to manage the audit logging config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config#org_id OrganizationIamAuditConfig#org_id}
    */
    readonly orgId: string;
    /**
    * Service which will be enabled for audit logging. The special value allServices covers all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config#service OrganizationIamAuditConfig#service}
    */
    readonly service: string;
    /**
    * audit_log_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config#audit_log_config OrganizationIamAuditConfig#audit_log_config}
    */
    readonly auditLogConfig: OrganizationIamAuditConfigAuditLogConfig[] | cdktf.IResolvable;
}
export interface OrganizationIamAuditConfigAuditLogConfig {
    /**
    * Identities that do not cause logging for this type of permission. Each entry can have one of the following values:user:{emailid}: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com. serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. domain:{domain}: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config#exempted_members OrganizationIamAuditConfig#exempted_members}
    */
    readonly exemptedMembers?: string[];
    /**
    * Permission type for which logging is to be configured. Must be one of DATA_READ, DATA_WRITE, or ADMIN_READ.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config#log_type OrganizationIamAuditConfig#log_type}
    */
    readonly logType: string;
}
export declare function organizationIamAuditConfigAuditLogConfigToTerraform(struct?: OrganizationIamAuditConfigAuditLogConfig | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config google_organization_iam_audit_config}
*/
export declare class OrganizationIamAuditConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_organization_iam_audit_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config google_organization_iam_audit_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrganizationIamAuditConfigConfig
    */
    constructor(scope: Construct, id: string, config: OrganizationIamAuditConfigConfig);
    get etag(): string;
    get id(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _auditLogConfig?;
    get auditLogConfig(): OrganizationIamAuditConfigAuditLogConfig[] | cdktf.IResolvable;
    set auditLogConfig(value: OrganizationIamAuditConfigAuditLogConfig[] | cdktf.IResolvable);
    get auditLogConfigInput(): cdktf.IResolvable | OrganizationIamAuditConfigAuditLogConfig[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
