import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectDefaultServiceAccountsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The action to be performed in the default service accounts. Valid values are: DEPRIVILEGE, DELETE, DISABLE.
                  Note that DEPRIVILEGE action will ignore the REVERT configuration in the restore_policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts#action ProjectDefaultServiceAccounts#action}
    */
    readonly action: string;
    /**
    * The project ID where service accounts are created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts#project ProjectDefaultServiceAccounts#project}
    */
    readonly project: string;
    /**
    * The action to be performed in the default service accounts on the resource destroy.
                  Valid values are NONE, REVERT and REVERT_AND_IGNORE_FAILURE. It is applied for any action but in the DEPRIVILEGE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts#restore_policy ProjectDefaultServiceAccounts#restore_policy}
    */
    readonly restorePolicy?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts#timeouts ProjectDefaultServiceAccounts#timeouts}
    */
    readonly timeouts?: ProjectDefaultServiceAccountsTimeouts;
}
export interface ProjectDefaultServiceAccountsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts#create ProjectDefaultServiceAccounts#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts#delete ProjectDefaultServiceAccounts#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts#read ProjectDefaultServiceAccounts#read}
    */
    readonly read?: string;
}
export declare function projectDefaultServiceAccountsTimeoutsToTerraform(struct?: ProjectDefaultServiceAccountsTimeoutsOutputReference | ProjectDefaultServiceAccountsTimeouts | cdktf.IResolvable): any;
export declare class ProjectDefaultServiceAccountsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProjectDefaultServiceAccountsTimeouts | undefined;
    set internalValue(value: ProjectDefaultServiceAccountsTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts google_project_default_service_accounts}
*/
export declare class ProjectDefaultServiceAccounts extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_project_default_service_accounts";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts google_project_default_service_accounts} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectDefaultServiceAccountsConfig
    */
    constructor(scope: Construct, id: string, config: ProjectDefaultServiceAccountsConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _restorePolicy?;
    get restorePolicy(): string;
    set restorePolicy(value: string);
    resetRestorePolicy(): void;
    get restorePolicyInput(): string | undefined;
    serviceAccounts(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): ProjectDefaultServiceAccountsTimeoutsOutputReference;
    putTimeouts(value: ProjectDefaultServiceAccountsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ProjectDefaultServiceAccountsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
