import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceManagerLienConfig extends cdktf.TerraformMetaArguments {
    /**
    * A stable, user-visible/meaningful string identifying the origin
  of the Lien, intended to be inspected programmatically. Maximum length of
  200 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien#origin ResourceManagerLien#origin}
    */
    readonly origin: string;
    /**
    * A reference to the resource this Lien is attached to.
  The server will validate the parent against those for which Liens are supported.
  Since a variety of objects can have Liens against them, you must provide the type
  prefix (e.g. "projects/my-project-name").
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien#parent ResourceManagerLien#parent}
    */
    readonly parent: string;
    /**
    * Concise user-visible strings indicating why an action cannot be performed
  on a resource. Maximum length of 200 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien#reason ResourceManagerLien#reason}
    */
    readonly reason: string;
    /**
    * The types of operations which should be blocked as a result of this Lien.
  Each value should correspond to an IAM permission. The server will validate
  the permissions against those for which Liens are supported.  An empty
  list is meaningless and will be rejected.
  e.g. ['resourcemanager.projects.delete']
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien#restrictions ResourceManagerLien#restrictions}
    */
    readonly restrictions: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien#timeouts ResourceManagerLien#timeouts}
    */
    readonly timeouts?: ResourceManagerLienTimeouts;
}
export interface ResourceManagerLienTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien#create ResourceManagerLien#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien#delete ResourceManagerLien#delete}
    */
    readonly delete?: string;
}
export declare function resourceManagerLienTimeoutsToTerraform(struct?: ResourceManagerLienTimeoutsOutputReference | ResourceManagerLienTimeouts | cdktf.IResolvable): any;
export declare class ResourceManagerLienTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceManagerLienTimeouts | undefined;
    set internalValue(value: ResourceManagerLienTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien google_resource_manager_lien}
*/
export declare class ResourceManagerLien extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_resource_manager_lien";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien google_resource_manager_lien} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceManagerLienConfig
    */
    constructor(scope: Construct, id: string, config: ResourceManagerLienConfig);
    get createTime(): string;
    get id(): string;
    get name(): string;
    private _origin?;
    get origin(): string;
    set origin(value: string);
    get originInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _reason?;
    get reason(): string;
    set reason(value: string);
    get reasonInput(): string | undefined;
    private _restrictions?;
    get restrictions(): string[];
    set restrictions(value: string[]);
    get restrictionsInput(): string[] | undefined;
    private _timeouts;
    get timeouts(): ResourceManagerLienTimeoutsOutputReference;
    putTimeouts(value: ResourceManagerLienTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ResourceManagerLienTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
