"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceAccountKey = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/service_account_key google_service_account_key}
*/
class ServiceAccountKey extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_account_key google_service_account_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceAccountKeyConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_service_account_key',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '3.90.1',
                providerVersionConstraint: '~> 3.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._keepers = config.keepers;
        this._keyAlgorithm = config.keyAlgorithm;
        this._privateKeyType = config.privateKeyType;
        this._publicKeyData = config.publicKeyData;
        this._publicKeyType = config.publicKeyType;
        this._serviceAccountId = config.serviceAccountId;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get keepers() {
        return this.getStringMapAttribute('keepers');
    }
    set keepers(value) {
        this._keepers = value;
    }
    resetKeepers() {
        this._keepers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepersInput() {
        return this._keepers;
    }
    get keyAlgorithm() {
        return this.getStringAttribute('key_algorithm');
    }
    set keyAlgorithm(value) {
        this._keyAlgorithm = value;
    }
    resetKeyAlgorithm() {
        this._keyAlgorithm = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyAlgorithmInput() {
        return this._keyAlgorithm;
    }
    // name - computed: true, optional: false, required: false
    get name() {
        return this.getStringAttribute('name');
    }
    // private_key - computed: true, optional: false, required: false
    get privateKey() {
        return this.getStringAttribute('private_key');
    }
    get privateKeyType() {
        return this.getStringAttribute('private_key_type');
    }
    set privateKeyType(value) {
        this._privateKeyType = value;
    }
    resetPrivateKeyType() {
        this._privateKeyType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyTypeInput() {
        return this._privateKeyType;
    }
    // public_key - computed: true, optional: false, required: false
    get publicKey() {
        return this.getStringAttribute('public_key');
    }
    get publicKeyData() {
        return this.getStringAttribute('public_key_data');
    }
    set publicKeyData(value) {
        this._publicKeyData = value;
    }
    resetPublicKeyData() {
        this._publicKeyData = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicKeyDataInput() {
        return this._publicKeyData;
    }
    get publicKeyType() {
        return this.getStringAttribute('public_key_type');
    }
    set publicKeyType(value) {
        this._publicKeyType = value;
    }
    resetPublicKeyType() {
        this._publicKeyType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicKeyTypeInput() {
        return this._publicKeyType;
    }
    get serviceAccountId() {
        return this.getStringAttribute('service_account_id');
    }
    set serviceAccountId(value) {
        this._serviceAccountId = value;
    }
    // Temporarily expose input value. Use with caution.
    get serviceAccountIdInput() {
        return this._serviceAccountId;
    }
    // valid_after - computed: true, optional: false, required: false
    get validAfter() {
        return this.getStringAttribute('valid_after');
    }
    // valid_before - computed: true, optional: false, required: false
    get validBefore() {
        return this.getStringAttribute('valid_before');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            keepers: cdktf.hashMapper(cdktf.stringToTerraform)(this._keepers),
            key_algorithm: cdktf.stringToTerraform(this._keyAlgorithm),
            private_key_type: cdktf.stringToTerraform(this._privateKeyType),
            public_key_data: cdktf.stringToTerraform(this._publicKeyData),
            public_key_type: cdktf.stringToTerraform(this._publicKeyType),
            service_account_id: cdktf.stringToTerraform(this._serviceAccountId),
        };
    }
}
exports.ServiceAccountKey = ServiceAccountKey;
_a = JSII_RTTI_SYMBOL_1;
ServiceAccountKey[_a] = { fqn: "@cdktf/provider-google.ServiceAccountKey", version: "0.7.6" };
// =================
// STATIC PROPERTIES
// =================
ServiceAccountKey.tfResourceType = "google_service_account_key";
//# sourceMappingURL=data:application/json;base64,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