/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest;

import com.amazon.randomcutforest.MultiVisitor;
import com.amazon.randomcutforest.TreeUpdater;
import com.amazon.randomcutforest.Visitor;
import com.amazon.randomcutforest.returntypes.ConvergingAccumulator;
import com.amazon.randomcutforest.tree.RandomCutTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;

public abstract class AbstractForestTraversalExecutor {
    protected final ArrayList<TreeUpdater> treeUpdaters;
    protected long totalUpdates;

    protected AbstractForestTraversalExecutor(ArrayList<TreeUpdater> treeUpdaters) {
        this.treeUpdaters = treeUpdaters;
        this.totalUpdates = 0L;
    }

    public long getTotalUpdates() {
        return this.totalUpdates;
    }

    public void update(double[] point) {
        ++this.totalUpdates;
        double[] pointCopy = this.cleanCopy(point);
        this.update(pointCopy, this.totalUpdates);
    }

    protected abstract void update(double[] var1, long var2);

    public abstract <R, S> S traverseForest(double[] var1, Function<RandomCutTree, Visitor<R>> var2, BinaryOperator<R> var3, Function<R, S> var4);

    public abstract <R, S> S traverseForest(double[] var1, Function<RandomCutTree, Visitor<R>> var2, Collector<R, ?, S> var3);

    public abstract <R, S> S traverseForest(double[] var1, Function<RandomCutTree, Visitor<R>> var2, ConvergingAccumulator<R> var3, Function<R, S> var4);

    public abstract <R, S> S traverseForestMulti(double[] var1, Function<RandomCutTree, MultiVisitor<R>> var2, BinaryOperator<R> var3, Function<R, S> var4);

    public abstract <R, S> S traverseForestMulti(double[] var1, Function<RandomCutTree, MultiVisitor<R>> var2, Collector<R, ?, S> var3);

    protected double[] cleanCopy(double[] point) {
        double[] pointCopy = Arrays.copyOf(point, point.length);
        for (int i = 0; i < point.length; ++i) {
            if (pointCopy[i] != 0.0) continue;
            pointCopy[i] = 0.0;
        }
        return pointCopy;
    }
}

