/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.sampler.SimpleStreamSampler;
import com.amazon.randomcutforest.sampler.WeightedPoint;
import com.amazon.randomcutforest.tree.RandomCutTree;

public class TreeUpdater {
    private final SimpleStreamSampler sampler;
    private final RandomCutTree tree;

    public TreeUpdater(SimpleStreamSampler sampler, RandomCutTree tree) {
        CommonUtils.checkNotNull(sampler, "sampler must not be null");
        CommonUtils.checkNotNull(tree, "tree must not be null");
        this.sampler = sampler;
        this.tree = tree;
    }

    public SimpleStreamSampler getSampler() {
        return this.sampler;
    }

    public RandomCutTree getTree() {
        return this.tree;
    }

    public void update(double[] point, long sequenceIndex) {
        WeightedPoint candidate = this.sampler.sample(point, sequenceIndex);
        if (candidate != null) {
            WeightedPoint evictedPoint = this.sampler.getEvictedPoint();
            if (evictedPoint != null) {
                this.tree.deletePoint(evictedPoint);
            }
            this.tree.addPoint(candidate);
        }
    }
}

