/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.anomalydetection;

import com.amazon.randomcutforest.anomalydetection.AbstractAttributionVisitor;
import com.amazon.randomcutforest.returntypes.DiVector;
import java.util.function.BiFunction;

public class DynamicAttributionVisitor
extends AbstractAttributionVisitor {
    private final BiFunction<Double, Double, Double> scoreSeen;
    private final BiFunction<Double, Double, Double> damp;
    private final BiFunction<Double, Double, Double> scoreUnseen;

    public DynamicAttributionVisitor(double[] point, int treeMass, int ignoreLeafMassThreshold, BiFunction<Double, Double, Double> scoreSeen, BiFunction<Double, Double, Double> scoreUnseen, BiFunction<Double, Double, Double> damp) {
        super(point, treeMass, ignoreLeafMassThreshold);
        this.scoreSeen = scoreSeen;
        this.scoreUnseen = scoreUnseen;
        this.damp = damp;
    }

    public DynamicAttributionVisitor(double[] point, int treeMass, int ignoreLeafMassThreshold, BiFunction<Double, Double, Double> scoreSeen, BiFunction<Double, Double, Double> scoreUnseen) {
        super(point, treeMass, ignoreLeafMassThreshold);
        this.scoreSeen = scoreSeen;
        this.scoreUnseen = scoreUnseen;
        this.damp = (x, y) -> 1.0;
    }

    @Override
    protected double scoreSeen(int depth, int leafMass) {
        return this.scoreSeen.apply(Double.valueOf(depth), Double.valueOf(leafMass));
    }

    @Override
    protected double scoreUnseen(int depth, int leafMass) {
        return this.scoreUnseen.apply(Double.valueOf(depth), Double.valueOf(leafMass));
    }

    @Override
    protected double damp(int leafMass, int treeMass) {
        return this.damp.apply(Double.valueOf(leafMass), Double.valueOf(treeMass));
    }

    @Override
    public DiVector getResult() {
        return new DiVector(this.directionalAttribution);
    }
}

