/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.anomalydetection;

import com.amazon.randomcutforest.anomalydetection.TransductiveScalarScoreVisitor;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.Node;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SimulatedTransductiveScalarScoreVisitor
extends TransductiveScalarScoreVisitor {
    private final Function<BoundingBox, double[]> vecSepBuild;

    public SimulatedTransductiveScalarScoreVisitor(double[] pointToScore, int treeMass, BiFunction<Double, Double, Double> scoreSeen, BiFunction<Double, Double, Double> scoreUnseen, BiFunction<Double, Double, Double> damp, Function<BoundingBox, double[]> vecSepBuild, Function<BoundingBox, double[]> vecSepScore) {
        super(pointToScore, treeMass, scoreSeen, scoreUnseen, damp, vecSepScore);
        this.vecSepBuild = vecSepBuild;
    }

    @Override
    public void accept(Node node, int depthOfNode) {
        double weight = this.getWeight(node.getCut().getDimension(), this.vecSepBuild, node.getBoundingBox());
        if (this.pointInsideBox) {
            this.score *= weight;
            return;
        }
        double probabilityOfSeparation = this.getProbabilityOfSeparation(node.getBoundingBox());
        if (probabilityOfSeparation == 0.0) {
            this.pointInsideBox = true;
        }
        this.score = probabilityOfSeparation * this.scoreUnseen(depthOfNode, node.getMass()) + weight * this.score;
    }
}

