/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.imputation;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.MultiVisitor;
import com.amazon.randomcutforest.tree.Node;
import java.util.Arrays;

public class ImputeVisitor
implements MultiVisitor<double[]> {
    private final boolean[] missing;
    private final int numberOfMissingValues;
    private double[] queryPoint;
    private double rank;

    public ImputeVisitor(double[] queryPoint, int numberOfMissingValues, int[] missingIndexes) {
        this.queryPoint = Arrays.copyOf(queryPoint, queryPoint.length);
        this.missing = new boolean[queryPoint.length];
        if (missingIndexes == null) {
            missingIndexes = new int[]{};
        }
        this.numberOfMissingValues = numberOfMissingValues;
        for (int i = 0; i < this.numberOfMissingValues; ++i) {
            CommonUtils.checkArgument(0 <= missingIndexes[i] && missingIndexes[i] < queryPoint.length, "Missing value indexes must be between 0 (inclusive) and queryPoint.length (exclusive)");
            this.missing[missingIndexes[i]] = true;
        }
        this.rank = 10.0;
    }

    ImputeVisitor(ImputeVisitor original) {
        int length = original.queryPoint.length;
        this.queryPoint = Arrays.copyOf(original.queryPoint, length);
        this.missing = Arrays.copyOf(original.missing, length);
        this.numberOfMissingValues = original.numberOfMissingValues;
        this.rank = 10.0;
    }

    public double getRank() {
        return this.rank;
    }

    @Override
    public void accept(Node node, int depthOfNode) {
        double probabilityOfSeparation = CommonUtils.getProbabilityOfSeparation(node.getBoundingBox(), this.queryPoint);
        if (probabilityOfSeparation <= 0.0) {
            return;
        }
        this.rank = probabilityOfSeparation * this.scoreUnseen(depthOfNode, node.getMass()) + (1.0 - probabilityOfSeparation) * this.rank;
    }

    @Override
    public void acceptLeaf(Node leafNode, int depthOfNode) {
        for (int i = 0; i < this.queryPoint.length; ++i) {
            if (!this.missing[i]) continue;
            this.queryPoint[i] = leafNode.getBoundingBox().getMinValue(i);
        }
        double probabilityOfSeparation = CommonUtils.getProbabilityOfSeparation(leafNode.getBoundingBox(), this.queryPoint);
        this.rank = probabilityOfSeparation <= 0.0 ? (depthOfNode == 0 ? 0.0 : this.scoreSeen(depthOfNode, leafNode.getMass())) : this.scoreUnseen(depthOfNode, leafNode.getMass());
    }

    @Override
    public double[] getResult() {
        return this.queryPoint;
    }

    @Override
    public boolean trigger(Node node) {
        return this.missing[node.getCut().getDimension()];
    }

    @Override
    public MultiVisitor<double[]> newCopy() {
        return new ImputeVisitor(this);
    }

    @Override
    public void combine(MultiVisitor<double[]> other) {
        ImputeVisitor visitor = (ImputeVisitor)other;
        if (visitor.getRank() < this.rank) {
            System.arraycopy(visitor.queryPoint, 0, this.queryPoint, 0, this.queryPoint.length);
            this.rank = visitor.getRank();
        }
    }

    protected double scoreSeen(int depth, int mass) {
        return CommonUtils.defaultScoreSeenFunction(depth, mass);
    }

    protected double scoreUnseen(int depth, int mass) {
        return CommonUtils.defaultScoreUnseenFunction(depth, mass);
    }
}

