/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.interpolation;

import com.amazon.randomcutforest.Visitor;
import com.amazon.randomcutforest.returntypes.DensityOutput;
import com.amazon.randomcutforest.returntypes.InterpolationMeasure;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.Node;
import java.util.Arrays;

public class SimpleInterpolationVisitor
implements Visitor<InterpolationMeasure> {
    private final double[] pointToScore;
    private final long sampleSize;
    private final boolean centerOfMass;
    public InterpolationMeasure stored;
    double sumOfNewRange = 0.0;
    double sumOfDifferenceInRange = 0.0;
    double[] directionalDistanceVector;
    double[] differenceInRangeVector;
    boolean pointInsideBox;
    boolean[] coordInsideBox;
    private boolean pointEqualsLeaf;
    private BoundingBox theShadowBox;
    private double savedMass;
    private double pointMass;

    public SimpleInterpolationVisitor(double[] pointToScore, int sampleSize, double pointMass, boolean centerOfMass) {
        this.pointToScore = Arrays.copyOf(pointToScore, pointToScore.length);
        this.sampleSize = sampleSize;
        this.pointInsideBox = false;
        this.pointMass = pointMass;
        this.stored = new DensityOutput(pointToScore.length, sampleSize);
        this.directionalDistanceVector = new double[2 * pointToScore.length];
        this.differenceInRangeVector = new double[2 * pointToScore.length];
        this.pointEqualsLeaf = false;
        this.centerOfMass = centerOfMass;
        this.coordInsideBox = new boolean[pointToScore.length];
    }

    @Override
    public InterpolationMeasure getResult() {
        return this.stored;
    }

    @Override
    public void accept(Node node, int depthOfNode) {
        BoundingBox smallBox;
        BoundingBox largeBox;
        if (this.pointInsideBox) {
            return;
        }
        if (this.pointEqualsLeaf) {
            largeBox = node.getBoundingBox();
            Node sibling = Node.isLeftOf(this.pointToScore, node) ? node.getRightChild() : node.getLeftChild();
            smallBox = this.theShadowBox = this.theShadowBox == null ? sibling.getBoundingBox() : this.theShadowBox.getMergedBox(sibling.getBoundingBox());
        } else {
            smallBox = node.getBoundingBox();
            largeBox = smallBox.getMergedBox(this.pointToScore);
        }
        this.updateForCompute(smallBox, largeBox);
        double probOfCut = this.sumOfDifferenceInRange / this.sumOfNewRange;
        if (probOfCut <= 0.0) {
            this.pointInsideBox = true;
        } else {
            double prob;
            int i;
            double fieldVal = this.fieldExt(node, this.centerOfMass, this.savedMass, this.pointToScore);
            double influenceVal = this.influenceExt(node, this.centerOfMass, this.savedMass, this.pointToScore);
            for (i = 0; i < this.pointToScore.length; ++i) {
                prob = this.differenceInRangeVector[2 * i] / this.sumOfNewRange;
                this.stored.probMass.high[i] = prob * influenceVal + (1.0 - probOfCut) * this.stored.probMass.high[i];
                this.stored.measure.high[i] = prob * fieldVal + (1.0 - probOfCut) * this.stored.measure.high[i];
                this.stored.distances.high[i] = prob * this.directionalDistanceVector[2 * i] * influenceVal + (1.0 - probOfCut) * this.stored.distances.high[i];
            }
            for (i = 0; i < this.pointToScore.length; ++i) {
                prob = this.differenceInRangeVector[2 * i + 1] / this.sumOfNewRange;
                this.stored.probMass.low[i] = prob * influenceVal + (1.0 - probOfCut) * this.stored.probMass.low[i];
                this.stored.measure.low[i] = prob * fieldVal + (1.0 - probOfCut) * this.stored.measure.low[i];
                this.stored.distances.low[i] = prob * this.directionalDistanceVector[2 * i + 1] * influenceVal + (1.0 - probOfCut) * this.stored.distances.low[i];
            }
        }
    }

    @Override
    public void acceptLeaf(Node leafNode, int depthOfNode) {
        this.updateForCompute(leafNode.getBoundingBox(), leafNode.getBoundingBox().getMergedBox(this.pointToScore));
        if (this.sumOfDifferenceInRange <= 0.0) {
            this.savedMass = this.pointMass + (double)leafNode.getMass();
            this.pointEqualsLeaf = true;
            for (int i = 0; i < this.pointToScore.length; ++i) {
                this.stored.measure.high[i] = this.stored.measure.low[i] = 0.5 * this.selfField(leafNode, this.savedMass) / (double)this.pointToScore.length;
                this.stored.probMass.high[i] = this.stored.probMass.low[i] = 0.5 * this.selfInfluence(leafNode, this.savedMass) / (double)this.pointToScore.length;
            }
            Arrays.fill(this.coordInsideBox, false);
        } else {
            double prob;
            int i;
            this.savedMass = this.pointMass;
            double fieldVal = this.fieldPoint(leafNode, this.savedMass, this.pointToScore);
            double influenceVal = this.influencePoint(leafNode, this.savedMass, this.pointToScore);
            for (i = 0; i < this.pointToScore.length; ++i) {
                prob = this.differenceInRangeVector[2 * i] / this.sumOfNewRange;
                this.stored.probMass.high[i] = prob * influenceVal;
                this.stored.measure.high[i] = prob * fieldVal;
                this.stored.distances.high[i] = prob * this.directionalDistanceVector[2 * i] * influenceVal;
            }
            for (i = 0; i < this.pointToScore.length; ++i) {
                prob = this.differenceInRangeVector[2 * i + 1] / this.sumOfNewRange;
                this.stored.probMass.low[i] = prob * influenceVal;
                this.stored.measure.low[i] = prob * fieldVal;
                this.stored.distances.low[i] = prob * this.directionalDistanceVector[2 * i + 1] * influenceVal;
            }
        }
    }

    void updateForCompute(BoundingBox smallBox, BoundingBox largeBox) {
        this.sumOfNewRange = 0.0;
        this.sumOfDifferenceInRange = 0.0;
        Arrays.fill(this.directionalDistanceVector, 0.0);
        Arrays.fill(this.differenceInRangeVector, 0.0);
        for (int i = 0; i < this.pointToScore.length; ++i) {
            double minGap;
            this.sumOfNewRange += largeBox.getRange(i);
            if (this.coordInsideBox[i]) continue;
            double maxGap = Math.max(largeBox.getMaxValue(i) - smallBox.getMaxValue(i), 0.0);
            if (maxGap + (minGap = Math.max(smallBox.getMinValue(i) - largeBox.getMinValue(i), 0.0)) > 0.0) {
                this.sumOfDifferenceInRange += minGap + maxGap;
                this.differenceInRangeVector[2 * i] = maxGap;
                this.differenceInRangeVector[2 * i + 1] = minGap;
                if (maxGap > 0.0) {
                    this.directionalDistanceVector[2 * i] = maxGap + smallBox.getRange(i);
                    continue;
                }
                this.directionalDistanceVector[2 * i + 1] = minGap + smallBox.getRange(i);
                continue;
            }
            this.coordInsideBox[i] = true;
        }
    }

    double fieldExt(Node node, boolean centerOfMass, double thisMass, double[] thislocation) {
        return (double)node.getMass() + thisMass;
    }

    double influenceExt(Node node, boolean centerOfMass, double thisMass, double[] thislocation) {
        return 1.0;
    }

    double fieldPoint(Node node, double thisMass, double[] thislocation) {
        return (double)node.getMass() + thisMass;
    }

    double influencePoint(Node node, double thisMass, double[] thislocation) {
        return 1.0;
    }

    double selfField(Node leafNode, double mass) {
        return mass;
    }

    double selfInfluence(Node leafnode, double mass) {
        return 1.0;
    }
}

