/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.runner;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.runner.ArgumentParser;
import com.amazon.randomcutforest.runner.LineTransformer;
import com.amazon.randomcutforest.util.ShingleBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;

public class SimpleRunner {
    protected final ArgumentParser argumentParser;
    protected final Function<RandomCutForest, LineTransformer> algorithmInitializer;
    protected LineTransformer algorithm;
    protected ShingleBuilder shingleBuilder;
    protected double[] pointBuffer;
    protected double[] shingleBuffer;
    protected int lineNumber;

    public SimpleRunner(String runnerClass, String runnerDescription, Function<RandomCutForest, LineTransformer> algorithmInitializer) {
        this(new ArgumentParser(runnerClass, runnerDescription), algorithmInitializer);
    }

    public SimpleRunner(ArgumentParser argumentParser, Function<RandomCutForest, LineTransformer> algorithmInitializer) {
        this.argumentParser = argumentParser;
        this.algorithmInitializer = algorithmInitializer;
    }

    public void parse(String ... arguments) {
        this.argumentParser.parse(arguments);
    }

    public void run(BufferedReader in, PrintWriter out) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            ++this.lineNumber;
            String[] values = line.split(this.argumentParser.getDelimiter());
            if (this.pointBuffer == null) {
                this.prepareAlgorithm(values.length);
            }
            if (this.lineNumber == 1 && this.argumentParser.getHeaderRow()) {
                this.writeHeader(values, out);
                continue;
            }
            this.processLine(values, out);
        }
        this.finish(out);
        out.flush();
    }

    protected void prepareAlgorithm(int dimensions) {
        this.pointBuffer = new double[dimensions];
        this.shingleBuilder = new ShingleBuilder(dimensions, this.argumentParser.getShingleSize(), this.argumentParser.getShingleCyclic());
        this.shingleBuffer = new double[this.shingleBuilder.getShingledPointSize()];
        RandomCutForest forest = ((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)RandomCutForest.builder().numberOfTrees(this.argumentParser.getNumberOfTrees())).sampleSize(this.argumentParser.getSampleSize())).dimensions(this.shingleBuilder.getShingledPointSize())).lambda(this.argumentParser.getLambda())).randomSeed(this.argumentParser.getRandomSeed())).build();
        this.algorithm = this.algorithmInitializer.apply(forest);
    }

    protected void writeHeader(String[] values, PrintWriter out) {
        StringJoiner joiner = new StringJoiner(this.argumentParser.getDelimiter());
        Arrays.stream(values).forEach(joiner::add);
        this.algorithm.getResultColumnNames().forEach(joiner::add);
        out.println(joiner.toString());
    }

    protected void processLine(String[] values, PrintWriter out) {
        List<String> result;
        if (values.length != this.pointBuffer.length) {
            throw new IllegalArgumentException(String.format("Wrong number of values on line %d. Exected %d but found %d.", this.lineNumber, this.pointBuffer.length, values.length));
        }
        this.parsePoint(values);
        this.shingleBuilder.addPoint(this.pointBuffer);
        if (this.shingleBuilder.isFull()) {
            this.shingleBuilder.getShingle(this.shingleBuffer);
            result = this.algorithm.getResultValues(this.shingleBuffer);
        } else {
            result = this.algorithm.getEmptyResultValue();
        }
        StringJoiner joiner = new StringJoiner(this.argumentParser.getDelimiter());
        Arrays.stream(values).forEach(joiner::add);
        result.forEach(joiner::add);
        out.println(joiner.toString());
    }

    protected void parsePoint(String[] stringValues) {
        for (int i = 0; i < this.pointBuffer.length; ++i) {
            this.pointBuffer[i] = Double.parseDouble(stringValues[i]);
        }
    }

    protected void finish(PrintWriter out) {
    }

    protected int getPointSize() {
        return this.pointBuffer != null ? this.pointBuffer.length : 0;
    }

    protected int getShingleSize() {
        return this.shingleBuffer != null ? this.shingleBuffer.length : 0;
    }
}

