/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.sampler;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.sampler.WeightedPoint;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.stream.Collectors;

public class SimpleStreamSampler {
    static Comparator<WeightedPoint> POINT_COMPARATOR = Comparator.comparingDouble(WeightedPoint::getWeight).reversed();
    private final Queue<WeightedPoint> weightedSamples;
    private final int sampleSize;
    private final double lambda;
    private final Random random;
    private long entriesSeen;
    private transient WeightedPoint evictedPoint;

    public SimpleStreamSampler(int sampleSize, double lambda, long seed) {
        this(sampleSize, lambda, new Random(seed));
    }

    protected SimpleStreamSampler(int sampleSize, double lambda, Random random) {
        this.sampleSize = sampleSize;
        this.entriesSeen = 0L;
        this.weightedSamples = new PriorityQueueWrapper<WeightedPoint>();
        this.random = random;
        this.lambda = lambda;
    }

    public static SimpleStreamSampler uniformSampler(int sampleSize, long seed) {
        return new SimpleStreamSampler(sampleSize, 0.0, seed);
    }

    public WeightedPoint sample(double[] newPoint, long sequenceIndex) {
        this.evictedPoint = null;
        WeightedPoint candidate = null;
        double weight = this.computeWeight(sequenceIndex);
        ++this.entriesSeen;
        if (this.entriesSeen <= (long)this.sampleSize || weight < this.weightedSamples.element().getWeight()) {
            if (this.isFull()) {
                this.evictedPoint = this.weightedSamples.poll();
            }
            candidate = new WeightedPoint(newPoint, sequenceIndex, weight);
            this.weightedSamples.add(candidate);
            CommonUtils.checkState(this.weightedSamples.size() <= this.sampleSize, "The number of points in the sampler is greater than the sample size");
        }
        return candidate;
    }

    public WeightedPoint getEvictedPoint() {
        return this.evictedPoint;
    }

    public List<double[]> getSamples() {
        return this.weightedSamples.stream().map(WeightedPoint::getPoint).collect(Collectors.toList());
    }

    public List<WeightedPoint> getWeightedSamples() {
        return new ArrayList<WeightedPoint>(this.weightedSamples);
    }

    public boolean isReady() {
        return this.weightedSamples.size() >= this.sampleSize / 4;
    }

    public boolean isFull() {
        return this.weightedSamples.size() == this.sampleSize;
    }

    protected double computeWeight(long sequenceIndex) {
        double randomNumber = 0.0;
        while (randomNumber == 0.0) {
            randomNumber = this.random.nextDouble();
        }
        return (double)(-sequenceIndex) * this.lambda + Math.log(-Math.log(randomNumber));
    }

    public long getCapacity() {
        return this.sampleSize;
    }

    public long getSize() {
        return this.weightedSamples.size();
    }

    public double getLambda() {
        return this.lambda;
    }

    static class PriorityQueueWrapper<WeightedPoint>
    extends PriorityQueue<WeightedPoint> {
        PriorityQueueWrapper() {
            super(POINT_COMPARATOR);
        }
    }
}

