/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import java.util.Arrays;

public class BoundingBox {
    private final double[] minValues;
    private final double[] maxValues;
    private final int dimensions;
    private final double rangeSum;

    public BoundingBox(double[] point) {
        this.dimensions = point.length;
        this.maxValues = Arrays.copyOf(point, point.length);
        this.minValues = this.maxValues;
        this.rangeSum = 0.0;
    }

    private BoundingBox(double[] minValues, double[] maxValues) {
        this.minValues = minValues;
        this.maxValues = maxValues;
        double sum = 0.0;
        for (int i = 0; i < minValues.length; ++i) {
            sum += maxValues[i] - minValues[i];
        }
        this.rangeSum = sum;
        this.dimensions = minValues.length;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public BoundingBox getMergedBox(BoundingBox otherBoundingBox) {
        double[] minValuesMerged = new double[this.dimensions];
        double[] maxValuesMerged = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            minValuesMerged[i] = Math.min(this.minValues[i], otherBoundingBox.minValues[i]);
            maxValuesMerged[i] = Math.max(this.maxValues[i], otherBoundingBox.maxValues[i]);
        }
        return new BoundingBox(minValuesMerged, maxValuesMerged);
    }

    public BoundingBox getMergedBox(double[] point) {
        double[] minValuesMerged = new double[this.dimensions];
        double[] maxValuesMerged = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            minValuesMerged[i] = Math.min(this.minValues[i], point[i]);
            maxValuesMerged[i] = Math.max(this.maxValues[i], point[i]);
        }
        return new BoundingBox(minValuesMerged, maxValuesMerged);
    }

    public double getRangeSum() {
        return this.rangeSum;
    }

    public double getMaxValue(int dimension) {
        return this.maxValues[dimension];
    }

    public double getMinValue(int dimension) {
        return this.minValues[dimension];
    }

    public boolean contains(double[] point) {
        for (int i = 0; i < this.dimensions; ++i) {
            if (this.contains(i, point[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(BoundingBox other) {
        for (int i = 0; i < this.dimensions; ++i) {
            if (this.contains(i, other.minValues[i]) && this.contains(i, other.maxValues[i])) continue;
            return false;
        }
        return true;
    }

    private boolean contains(int dimension, double value) {
        return this.maxValues[dimension] >= value && value >= this.minValues[dimension];
    }

    public double getRange(int dimension) {
        return this.maxValues[dimension] - this.minValues[dimension];
    }

    public String toString() {
        return String.format("BoundingBox(%s, %s)", Arrays.toString(this.minValues), Arrays.toString(this.maxValues));
    }

    public boolean equals(Object other) {
        if (!(other instanceof BoundingBox)) {
            return false;
        }
        BoundingBox otherBox = (BoundingBox)other;
        return Arrays.equals(this.minValues, otherBox.minValues) && Arrays.equals(this.maxValues, otherBox.maxValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.minValues) + 31 * Arrays.hashCode(this.maxValues);
    }
}

