/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.Cut;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Node {
    private final double[] leafPoint;
    private final double[] pointSum;
    private Node parent;
    private Node rightChild;
    private Node leftChild;
    private Cut cut;
    private BoundingBox boundingBox;
    private int mass;
    private Set<Long> sequenceIndexes;

    public Node(Node leftChild, Node rightChild, Cut cut, BoundingBox boundingBox, boolean enableCenterOfMass) {
        this.rightChild = rightChild;
        this.leftChild = leftChild;
        this.cut = cut;
        this.boundingBox = boundingBox;
        this.sequenceIndexes = null;
        this.pointSum = (double[])(!enableCenterOfMass ? null : new double[boundingBox.getDimensions()]);
        this.leafPoint = null;
    }

    public Node(Node leftChild, Node rightChild, Cut cut, BoundingBox boundingBox) {
        this(leftChild, rightChild, cut, boundingBox, false);
    }

    public Node(double[] leafPoint) {
        this.leafPoint = leafPoint;
        this.sequenceIndexes = null;
        this.pointSum = null;
        this.boundingBox = new BoundingBox(leafPoint);
    }

    public static boolean isLeftOf(double[] point, Node node) {
        return Cut.isLeftOf(point, node.cut);
    }

    public Node getParent() {
        return this.parent;
    }

    protected void setParent(Node parent) {
        this.parent = parent;
    }

    public Node getRightChild() {
        return this.rightChild;
    }

    protected void setRightChild(Node rightChild) {
        CommonUtils.checkState(!this.isLeaf(), "Cannot assign child to a leaf node");
        this.rightChild = rightChild;
    }

    public Node getLeftChild() {
        return this.leftChild;
    }

    protected void setLeftChild(Node leftChild) {
        CommonUtils.checkState(!this.isLeaf(), "Cannot assign child to a leaf node");
        this.leftChild = leftChild;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    protected void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public boolean leafPointEquals(double[] point) {
        return Arrays.equals(this.leafPoint, point);
    }

    public double[] getLeafPoint() {
        CommonUtils.checkState(this.isLeaf(), "Not a leaf node");
        return Arrays.copyOf(this.leafPoint, this.leafPoint.length);
    }

    public double getLeafPoint(int i) {
        CommonUtils.checkState(this.isLeaf(), "Not a leaf node");
        return this.leafPoint[i];
    }

    public int getMass() {
        return this.mass;
    }

    protected void setMass(int mass) {
        this.mass = mass;
    }

    protected void addMass(int massDelta) {
        this.mass += massDelta;
    }

    protected void incrementMass() {
        this.addMass(1);
    }

    protected void decrementMass() {
        this.addMass(-1);
    }

    public Cut getCut() {
        return this.cut;
    }

    public boolean isLeaf() {
        return this.leafPoint != null;
    }

    protected void subtractFromPointSum(double[] point) {
        CommonUtils.checkState(this.pointSum != null, "center of mass computation is disabled");
        for (int i = 0; i < point.length; ++i) {
            int n = i;
            this.pointSum[n] = this.pointSum[n] - point[i];
        }
    }

    protected void addToPointSum(double[] point) {
        CommonUtils.checkState(this.pointSum != null, "center of mass computation is disabled");
        for (int i = 0; i < point.length; ++i) {
            int n = i;
            this.pointSum[n] = this.pointSum[n] + point[i];
        }
    }

    public double[] getPointSum() {
        double[] result = new double[this.boundingBox.getDimensions()];
        if (this.leafPoint != null) {
            for (int i = 0; i < this.boundingBox.getDimensions(); ++i) {
                result[i] = (double)this.mass * this.leafPoint[i];
            }
        } else if (this.pointSum != null && this.boundingBox.getDimensions() >= 0) {
            System.arraycopy(this.pointSum, 0, result, 0, this.pointSum.length);
        }
        return result;
    }

    public double[] getCenterOfMass() {
        double[] result = new double[this.boundingBox.getDimensions()];
        if (this.leafPoint != null) {
            System.arraycopy(this.leafPoint, 0, result, 0, this.boundingBox.getDimensions());
        } else if (this.pointSum != null) {
            for (int i = 0; i < this.boundingBox.getDimensions(); ++i) {
                result[i] = this.pointSum[i] / (double)this.mass;
            }
        }
        return result;
    }

    public Set<Long> getSequenceIndexes() {
        if (this.sequenceIndexes != null) {
            return Collections.unmodifiableSet(this.sequenceIndexes);
        }
        return Collections.emptySet();
    }

    protected void addSequenceIndex(long sequenceIndex) {
        if (this.sequenceIndexes == null) {
            this.sequenceIndexes = new HashSet<Long>();
        }
        this.sequenceIndexes.add(sequenceIndex);
    }

    protected void deleteSequenceIndex(long sequenceIndex) {
        if (this.sequenceIndexes != null) {
            this.sequenceIndexes.remove(sequenceIndex);
        }
    }
}

