import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [groundtruthlabeling](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazongroundtruthlabeling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Groundtruthlabeling extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [groundtruthlabeling](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazongroundtruthlabeling.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Get status of GroundTruthLabeling Jobs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    describeConsoleJob(): this;
    /**
     * Paginated list API to list dataset objects in a manifest file.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    listDatasetObjects(): this;
    /**
     * Filter records from a manifest file using S3 select. Get sample entries based on random sampling.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-data-filtering
     */
    runFilterOrSampleDatasetJob(): this;
    /**
     * List a S3 prefix and create manifest files from objects in that location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    runGenerateManifestByCrawlingJob(): this;
}
