"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Textract = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [textract](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontextract.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Textract extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [textract](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontextract.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'textract';
        this.actionList = {
            "AnalyzeDocument": {
                "url": "https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeDocument.html",
                "description": "Detects instances of real-world document entities within an image provided as input.",
                "accessLevel": "Read",
                "dependentActions": [
                    "s3:GetObject"
                ]
            },
            "DetectDocumentText": {
                "url": "https://docs.aws.amazon.com/textract/latest/dg/API_DetectDocumentText.html",
                "description": "Detects text in document images.",
                "accessLevel": "Read",
                "dependentActions": [
                    "s3:GetObject"
                ]
            },
            "GetDocumentAnalysis": {
                "url": "https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentAnalysis.html",
                "description": "Returns information about a document analysis job.",
                "accessLevel": "Read"
            },
            "GetDocumentTextDetection": {
                "url": "https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentTextDetection.html",
                "description": "Returns information about a document text detection job.",
                "accessLevel": "Read"
            },
            "StartDocumentAnalysis": {
                "url": "https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentAnalysis.html",
                "description": "Starts an asynchronous job to detect instances of real-world document entities within an image or pdf provided as input.",
                "accessLevel": "Write",
                "dependentActions": [
                    "s3:GetObject"
                ]
            },
            "StartDocumentTextDetection": {
                "url": "https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentTextDetection.html",
                "description": "Starts an asynchronous job to detect text in document images or pdfs.",
                "accessLevel": "Write",
                "dependentActions": [
                    "s3:GetObject"
                ]
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Detects instances of real-world document entities within an image provided as input.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeDocument.html
     */
    analyzeDocument() {
        this.add('textract:AnalyzeDocument');
        return this;
    }
    /**
     * Detects text in document images.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_DetectDocumentText.html
     */
    detectDocumentText() {
        this.add('textract:DetectDocumentText');
        return this;
    }
    /**
     * Returns information about a document analysis job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentAnalysis.html
     */
    getDocumentAnalysis() {
        this.add('textract:GetDocumentAnalysis');
        return this;
    }
    /**
     * Returns information about a document text detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentTextDetection.html
     */
    getDocumentTextDetection() {
        this.add('textract:GetDocumentTextDetection');
        return this;
    }
    /**
     * Starts an asynchronous job to detect instances of real-world document entities within an image or pdf provided as input.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentAnalysis.html
     */
    startDocumentAnalysis() {
        this.add('textract:StartDocumentAnalysis');
        return this;
    }
    /**
     * Starts an asynchronous job to detect text in document images or pdfs.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentTextDetection.html
     */
    startDocumentTextDetection() {
        this.add('textract:StartDocumentTextDetection');
        return this;
    }
}
exports.Textract = Textract;
//# sourceMappingURL=data:application/json;base64,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