"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceManagement = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplacemanagementportal.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceManagement extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplacemanagementportal.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aws-marketplace-management';
        this.actionList = {
            "uploadFiles": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions",
                "description": "Allows a user to access the File Upload page inside the AWS Marketplace Management Portal.",
                "accessLevel": "Write"
            },
            "viewMarketing": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions",
                "description": "Allows a user to access the Marketing page inside the AWS Marketplace Management Portal.",
                "accessLevel": "List"
            },
            "viewReports": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions",
                "description": "Allows a user to access the Reports page inside the AWS Marketplace Management Portal.",
                "accessLevel": "List"
            },
            "viewSettings": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions",
                "description": "Allows a user to access the Settings page inside the AWS Marketplace Management Portal.",
                "accessLevel": "List"
            },
            "viewSupport": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions",
                "description": "Allows a user to access the Customer Support Eligibility page inside the AWS Marketplace Management Portal.",
                "accessLevel": "List"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Allows a user to access the File Upload page inside the AWS Marketplace Management Portal.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    uploadFiles() {
        this.add('aws-marketplace-management:uploadFiles');
        return this;
    }
    /**
     * Allows a user to access the Marketing page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    viewMarketing() {
        this.add('aws-marketplace-management:viewMarketing');
        return this;
    }
    /**
     * Allows a user to access the Reports page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    viewReports() {
        this.add('aws-marketplace-management:viewReports');
        return this;
    }
    /**
     * Allows a user to access the Settings page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    viewSettings() {
        this.add('aws-marketplace-management:viewSettings');
        return this;
    }
    /**
     * Allows a user to access the Customer Support Eligibility page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    viewSupport() {
        this.add('aws-marketplace-management:viewSupport');
        return this;
    }
}
exports.AwsMarketplaceManagement = AwsMarketplaceManagement;
//# sourceMappingURL=data:application/json;base64,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