"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = exports.FileSystemProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const nas_generated_1 = require("./nas.generated");
Object.defineProperty(exports, "FileSystemProperty", { enumerable: true, get: function () { return nas_generated_1.RosFileSystem; } });
/**
 * A ROS resource type:  `ALIYUN::NAS::FileSystem`
 */
class FileSystem extends ros.Resource {
    /**
     * Create a new `ALIYUN::NAS::FileSystem`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosFileSystem = new nas_generated_1.RosFileSystem(this, id, {
            description: props.description,
            storageType: props.storageType,
            zoneId: props.zoneId,
            vSwitchId: props.vSwitchId,
            duration: props.duration,
            snapshotId: props.snapshotId,
            deletionForce: props.deletionForce ? props.deletionForce : false,
            encryptType: props.encryptType,
            vpcId: props.vpcId,
            capacity: props.capacity,
            protocolType: props.protocolType,
            chargeType: props.chargeType,
            fileSystemType: props.fileSystemType,
            bandwidth: props.bandwidth,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosFileSystem;
        this.attrFileSystemId = rosFileSystem.attrFileSystemId;
    }
}
exports.FileSystem = FileSystem;
//# sourceMappingURL=data:application/json;base64,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