import cdk = require('@aws-cdk/cdk');
/**
 * Properties for defining a `AWS::Inspector::AssessmentTarget`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttarget.html
 */
export interface CfnAssessmentTargetProps {
    /**
     * `AWS::Inspector::AssessmentTarget.AssessmentTargetName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttarget.html#cfn-inspector-assessmenttarget-assessmenttargetname
     */
    readonly assessmentTargetName?: string;
    /**
     * `AWS::Inspector::AssessmentTarget.ResourceGroupArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttarget.html#cfn-inspector-assessmenttarget-resourcegrouparn
     */
    readonly resourceGroupArn?: string;
}
/**
 * A CloudFormation `AWS::Inspector::AssessmentTarget`
 *
 * @cloudformationResource AWS::Inspector::AssessmentTarget
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttarget.html
 */
export declare class CfnAssessmentTarget extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Inspector::AssessmentTarget";
    /**
     * @cloudformationAttribute Arn
     */
    readonly assessmentTargetArn: string;
    /**
     * Create a new `AWS::Inspector::AssessmentTarget`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnAssessmentTargetProps);
    readonly propertyOverrides: CfnAssessmentTargetProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Inspector::AssessmentTemplate`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttemplate.html
 */
export interface CfnAssessmentTemplateProps {
    /**
     * `AWS::Inspector::AssessmentTemplate.AssessmentTargetArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttemplate.html#cfn-inspector-assessmenttemplate-assessmenttargetarn
     */
    readonly assessmentTargetArn: string;
    /**
     * `AWS::Inspector::AssessmentTemplate.DurationInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttemplate.html#cfn-inspector-assessmenttemplate-durationinseconds
     */
    readonly durationInSeconds: number | cdk.Token;
    /**
     * `AWS::Inspector::AssessmentTemplate.RulesPackageArns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttemplate.html#cfn-inspector-assessmenttemplate-rulespackagearns
     */
    readonly rulesPackageArns: string[];
    /**
     * `AWS::Inspector::AssessmentTemplate.AssessmentTemplateName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttemplate.html#cfn-inspector-assessmenttemplate-assessmenttemplatename
     */
    readonly assessmentTemplateName?: string;
    /**
     * `AWS::Inspector::AssessmentTemplate.UserAttributesForFindings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttemplate.html#cfn-inspector-assessmenttemplate-userattributesforfindings
     */
    readonly userAttributesForFindings?: Array<cdk.CfnTag | cdk.Token> | cdk.Token;
}
/**
 * A CloudFormation `AWS::Inspector::AssessmentTemplate`
 *
 * @cloudformationResource AWS::Inspector::AssessmentTemplate
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttemplate.html
 */
export declare class CfnAssessmentTemplate extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Inspector::AssessmentTemplate";
    /**
     * @cloudformationAttribute Arn
     */
    readonly assessmentTemplateArn: string;
    /**
     * Create a new `AWS::Inspector::AssessmentTemplate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAssessmentTemplateProps);
    readonly propertyOverrides: CfnAssessmentTemplateProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Inspector::ResourceGroup`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-resourcegroup.html
 */
export interface CfnResourceGroupProps {
    /**
     * `AWS::Inspector::ResourceGroup.ResourceGroupTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-resourcegroup.html#cfn-inspector-resourcegroup-resourcegrouptags
     */
    readonly resourceGroupTags: Array<cdk.CfnTag | cdk.Token> | cdk.Token;
}
/**
 * A CloudFormation `AWS::Inspector::ResourceGroup`
 *
 * @cloudformationResource AWS::Inspector::ResourceGroup
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-resourcegroup.html
 */
export declare class CfnResourceGroup extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Inspector::ResourceGroup";
    /**
     * @cloudformationAttribute Arn
     */
    readonly resourceGroupArn: string;
    /**
     * Create a new `AWS::Inspector::ResourceGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceGroupProps);
    readonly propertyOverrides: CfnResourceGroupProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
