"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const integrations_1 = require("./integrations");
const restapi_1 = require("./restapi");
/**
 * Defines an API Gateway REST API with AWS Lambda proxy integration.
 *
 * Use the `proxy` property to define a greedy proxy ("{proxy+}") and "ANY"
 * method from the specified path. If not defined, you will need to explicity
 * add resources and methods to the API.
 */
class LambdaRestApi extends restapi_1.RestApi {
    constructor(scope, id, props) {
        if ((props.options && props.options.defaultIntegration) || props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Lambda integration is automatically defined');
        }
        super(scope, id, {
            defaultIntegration: new integrations_1.LambdaIntegration(props.handler),
            ...props.options,
            ...props,
        });
        if (props.proxy !== false) {
            this.root.addProxy();
            // Make sure users cannot call any other resource adding function
            this.root.addResource = addResourceThrows;
            this.root.addMethod = addMethodThrows;
            this.root.addProxy = addProxyThrows;
        }
    }
}
exports.LambdaRestApi = LambdaRestApi;
function addResourceThrows() {
    throw new Error('Cannot call \'addResource\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addMethodThrows() {
    throw new Error('Cannot call \'addMethod\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addProxyThrows() {
    throw new Error('Cannot call \'addProxy\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWFwaS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxhbWJkYS1hcGkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFFQSxpREFBbUQ7QUFHbkQsdUNBQWtEO0FBK0JsRDs7Ozs7O0dBTUc7QUFDSCxNQUFhLGFBQWMsU0FBUSxpQkFBTztJQUN4QyxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXlCO1FBQ3JFLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsa0JBQWtCLENBQUMsSUFBSSxLQUFLLENBQUMsa0JBQWtCLEVBQUU7WUFDbkYsTUFBTSxJQUFJLEtBQUssQ0FBQyx1RkFBdUYsQ0FBQyxDQUFDO1NBQzFHO1FBRUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixrQkFBa0IsRUFBRSxJQUFJLGdDQUFpQixDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUM7WUFDeEQsR0FBRyxLQUFLLENBQUMsT0FBTztZQUNoQixHQUFHLEtBQUs7U0FDVCxDQUFDLENBQUM7UUFFSCxJQUFJLEtBQUssQ0FBQyxLQUFLLEtBQUssS0FBSyxFQUFFO1lBQ3pCLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7WUFFckIsaUVBQWlFO1lBQ2pFLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxHQUFHLGlCQUFpQixDQUFDO1lBQzFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxHQUFHLGVBQWUsQ0FBQztZQUN0QyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxjQUFjLENBQUM7U0FDckM7SUFDSCxDQUFDO0NBQ0Y7QUFyQkQsc0NBcUJDO0FBRUQsU0FBUyxpQkFBaUI7SUFDeEIsTUFBTSxJQUFJLEtBQUssQ0FBQyxpRkFBaUYsQ0FBQyxDQUFDO0FBQ3JHLENBQUM7QUFFRCxTQUFTLGVBQWU7SUFDdEIsTUFBTSxJQUFJLEtBQUssQ0FBQywrRUFBK0UsQ0FBQyxDQUFDO0FBQ25HLENBQUM7QUFFRCxTQUFTLGNBQWM7SUFDckIsTUFBTSxJQUFJLEtBQUssQ0FBQyw4RUFBOEUsQ0FBQyxDQUFDO0FBQ2xHLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBMYW1iZGFJbnRlZ3JhdGlvbiB9IGZyb20gJy4vaW50ZWdyYXRpb25zJztcbmltcG9ydCB7IE1ldGhvZCB9IGZyb20gJy4vbWV0aG9kJztcbmltcG9ydCB7IFByb3h5UmVzb3VyY2UsIFJlc291cmNlIH0gZnJvbSAnLi9yZXNvdXJjZSc7XG5pbXBvcnQgeyBSZXN0QXBpLCBSZXN0QXBpUHJvcHMgfSBmcm9tICcuL3Jlc3RhcGknO1xuXG5leHBvcnQgaW50ZXJmYWNlIExhbWJkYVJlc3RBcGlQcm9wcyBleHRlbmRzIFJlc3RBcGlQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgZGVmYXVsdCBMYW1iZGEgZnVuY3Rpb24gdGhhdCBoYW5kbGVzIGFsbCByZXF1ZXN0cyBmcm9tIHRoaXMgQVBJLlxuICAgKlxuICAgKiBUaGlzIGhhbmRsZXIgd2lsbCBiZSB1c2VkIGFzIGEgdGhlIGRlZmF1bHQgaW50ZWdyYXRpb24gZm9yIGFsbCBtZXRob2RzIGluXG4gICAqIHRoaXMgQVBJLCB1bmxlc3Mgc3BlY2lmaWVkIG90aGVyd2lzZSBpbiBgYWRkTWV0aG9kYC5cbiAgICovXG4gIHJlYWRvbmx5IGhhbmRsZXI6IGxhbWJkYS5JRnVuY3Rpb247XG5cbiAgLyoqXG4gICAqIElmIHRydWUsIHJvdXRlIGFsbCByZXF1ZXN0cyB0byB0aGUgTGFtYmRhIEZ1bmN0aW9uXG4gICAqXG4gICAqIElmIHNldCB0byBmYWxzZSwgeW91IHdpbGwgbmVlZCB0byBleHBsaWNpdGx5IGRlZmluZSB0aGUgQVBJIG1vZGVsIHVzaW5nXG4gICAqIGBhZGRSZXNvdXJjZWAgYW5kIGBhZGRNZXRob2RgIChvciBgYWRkUHJveHlgKS5cbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgcHJveHk/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBAZGVwcmVjYXRlZCB0aGUgYExhbWJkYVJlc3RBcGlQcm9wc2Agbm93IGV4dGVuZHMgYFJlc3RBcGlQcm9wc2AsIHNvIGFsbFxuICAgKiBvcHRpb25zIGFyZSBqdXN0IGF2YWlsYWJsZSBoZXJlLiBOb3RlIHRoYXQgdGhlIG9wdGlvbnMgc3BlY2lmaWVkIGluXG4gICAqIGBvcHRpb25zYCB3aWxsIGJlIG92ZXJyaWRkZW4gYnkgYW55IHByb3BzIHNwZWNpZmllZCBhdCB0aGUgcm9vdCBsZXZlbC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBvcHRpb25zLlxuICAgKi9cbiAgcmVhZG9ubHkgb3B0aW9ucz86IFJlc3RBcGlQcm9wcztcbn1cblxuLyoqXG4gKiBEZWZpbmVzIGFuIEFQSSBHYXRld2F5IFJFU1QgQVBJIHdpdGggQVdTIExhbWJkYSBwcm94eSBpbnRlZ3JhdGlvbi5cbiAqXG4gKiBVc2UgdGhlIGBwcm94eWAgcHJvcGVydHkgdG8gZGVmaW5lIGEgZ3JlZWR5IHByb3h5IChcIntwcm94eSt9XCIpIGFuZCBcIkFOWVwiXG4gKiBtZXRob2QgZnJvbSB0aGUgc3BlY2lmaWVkIHBhdGguIElmIG5vdCBkZWZpbmVkLCB5b3Ugd2lsbCBuZWVkIHRvIGV4cGxpY2l0eVxuICogYWRkIHJlc291cmNlcyBhbmQgbWV0aG9kcyB0byB0aGUgQVBJLlxuICovXG5leHBvcnQgY2xhc3MgTGFtYmRhUmVzdEFwaSBleHRlbmRzIFJlc3RBcGkge1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IExhbWJkYVJlc3RBcGlQcm9wcykge1xuICAgIGlmICgocHJvcHMub3B0aW9ucyAmJiBwcm9wcy5vcHRpb25zLmRlZmF1bHRJbnRlZ3JhdGlvbikgfHwgcHJvcHMuZGVmYXVsdEludGVncmF0aW9uKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0Nhbm5vdCBzcGVjaWZ5IFwiZGVmYXVsdEludGVncmF0aW9uXCIgc2luY2UgTGFtYmRhIGludGVncmF0aW9uIGlzIGF1dG9tYXRpY2FsbHkgZGVmaW5lZCcpO1xuICAgIH1cblxuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgZGVmYXVsdEludGVncmF0aW9uOiBuZXcgTGFtYmRhSW50ZWdyYXRpb24ocHJvcHMuaGFuZGxlciksXG4gICAgICAuLi5wcm9wcy5vcHRpb25zLCAvLyBkZXByZWNhdGVkLCBidXQgd2Ugc3RpbGwgc3VwcG9ydFxuICAgICAgLi4ucHJvcHMsXG4gICAgfSk7XG5cbiAgICBpZiAocHJvcHMucHJveHkgIT09IGZhbHNlKSB7XG4gICAgICB0aGlzLnJvb3QuYWRkUHJveHkoKTtcblxuICAgICAgLy8gTWFrZSBzdXJlIHVzZXJzIGNhbm5vdCBjYWxsIGFueSBvdGhlciByZXNvdXJjZSBhZGRpbmcgZnVuY3Rpb25cbiAgICAgIHRoaXMucm9vdC5hZGRSZXNvdXJjZSA9IGFkZFJlc291cmNlVGhyb3dzO1xuICAgICAgdGhpcy5yb290LmFkZE1ldGhvZCA9IGFkZE1ldGhvZFRocm93cztcbiAgICAgIHRoaXMucm9vdC5hZGRQcm94eSA9IGFkZFByb3h5VGhyb3dzO1xuICAgIH1cbiAgfVxufVxuXG5mdW5jdGlvbiBhZGRSZXNvdXJjZVRocm93cygpOiBSZXNvdXJjZSB7XG4gIHRocm93IG5ldyBFcnJvcignQ2Fubm90IGNhbGwgXFwnYWRkUmVzb3VyY2VcXCcgb24gYSBwcm94eWluZyBMYW1iZGFSZXN0QXBpOyBzZXQgXFwncHJveHlcXCcgdG8gZmFsc2UnKTtcbn1cblxuZnVuY3Rpb24gYWRkTWV0aG9kVGhyb3dzKCk6IE1ldGhvZCB7XG4gIHRocm93IG5ldyBFcnJvcignQ2Fubm90IGNhbGwgXFwnYWRkTWV0aG9kXFwnIG9uIGEgcHJveHlpbmcgTGFtYmRhUmVzdEFwaTsgc2V0IFxcJ3Byb3h5XFwnIHRvIGZhbHNlJyk7XG59XG5cbmZ1bmN0aW9uIGFkZFByb3h5VGhyb3dzKCk6IFByb3h5UmVzb3VyY2Uge1xuICB0aHJvdyBuZXcgRXJyb3IoJ0Nhbm5vdCBjYWxsIFxcJ2FkZFByb3h5XFwnIG9uIGEgcHJveHlpbmcgTGFtYmRhUmVzdEFwaTsgc2V0IFxcJ3Byb3h5XFwnIHRvIGZhbHNlJyk7XG59XG4iXX0=