"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const path = require("path");
const apigateway = require("../lib");
/*
 * Stack verification steps:
 * * `curl -i <CFN output PetsURL>` should return HTTP code 200
 */
const app = new cdk.App();
const stack = new cdk.Stack(app, 'integtest-restapi-fromdefinition-asset');
const api = new apigateway.SpecRestApi(stack, 'my-api', {
    apiDefinition: apigateway.ApiDefinition.fromAsset(path.join(__dirname, 'sample-definition.yaml')),
});
new cdk.CfnOutput(stack, 'PetsURL', {
    value: api.urlForPath('/pets'),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuYXBpLWRlZmluaXRpb24uYXNzZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5hcGktZGVmaW5pdGlvbi5hc3NldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHFDQUFxQztBQUNyQyw2QkFBNkI7QUFDN0IscUNBQXFDO0FBRXJDOzs7R0FHRztBQUVILE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsd0NBQXdDLENBQUMsQ0FBQztBQUUzRSxNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQVUsQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLFFBQVEsRUFBRTtJQUN0RCxhQUFhLEVBQUUsVUFBVSxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsd0JBQXdCLENBQUMsQ0FBQztDQUNsRyxDQUFDLENBQUM7QUFFSCxJQUFJLEdBQUcsQ0FBQyxTQUFTLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRTtJQUNsQyxLQUFLLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7Q0FDL0IsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIGFwaWdhdGV3YXkgZnJvbSAnLi4vbGliJztcblxuLypcbiAqIFN0YWNrIHZlcmlmaWNhdGlvbiBzdGVwczpcbiAqICogYGN1cmwgLWkgPENGTiBvdXRwdXQgUGV0c1VSTD5gIHNob3VsZCByZXR1cm4gSFRUUCBjb2RlIDIwMFxuICovXG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnaW50ZWd0ZXN0LXJlc3RhcGktZnJvbWRlZmluaXRpb24tYXNzZXQnKTtcblxuY29uc3QgYXBpID0gbmV3IGFwaWdhdGV3YXkuU3BlY1Jlc3RBcGkoc3RhY2ssICdteS1hcGknLCB7XG4gIGFwaURlZmluaXRpb246IGFwaWdhdGV3YXkuQXBpRGVmaW5pdGlvbi5mcm9tQXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJ3NhbXBsZS1kZWZpbml0aW9uLnlhbWwnKSksXG59KTtcblxubmV3IGNkay5DZm5PdXRwdXQoc3RhY2ssICdQZXRzVVJMJywge1xuICB2YWx1ZTogYXBpLnVybEZvclBhdGgoJy9wZXRzJyksXG59KTtcblxuYXBwLnN5bnRoKCk7XG4iXX0=