import setuptools
import time
import math
import setuptools_scm
import os
import subprocess

with open("README.md", "r") as fh:
    long_description = fh.read()

# Automatic versioning via git tags
version_py = os.path.join(os.path.dirname(__file__), 'version.py')

try:
    version_git = subprocess.check_output(["git", "describe", "--abbrev=0"]).rstrip()
except:
    with open(version_py, 'r') as fh:
        version_git = open(version_py).read().strip().split('=')[-1].replace('"','')

if not isinstance(version_git, str):
    version_git = version_git.decode("utf-8")

version_msg = "# Do not edit this file, pipeline versioning is governed by git tags"
with open(version_py, 'w') as fh:
    fh.write(version_msg + os.linesep + "__version__=" + str(version_git))


setuptools.setup(
    name="sphinx-uedoc-theme",
    version="{ver}".format(ver=version_git),
    author="Luca Faggion",
    author_email="luc-af@live.it",
    description="Unreal engine documentation theme for Python Sphinx",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/Raider-Arts/sphinx-uedoc-theme",
    packages=setuptools.find_packages(),
    include_package_data=True,
    install_requires=[
        'sphinx'
    ],
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.6',
)